/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.properties.widget;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.MoveSelectionCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.nattable.selection.EObjectSelectionExtractor;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.painter.CustomizedCellPainter;
import org.eclipse.papyrus.infra.nattable.provider.TableSelectionProvider;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableModelManagerFactory;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrusrt.umlrt.tooling.properties.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.properties.editors.ParameterControlEditor;
import org.eclipse.papyrusrt.umlrt.tooling.properties.widget.ParameterControlWidget;
import org.eclipse.papyrusrt.umlrt.tooling.properties.widget.RTNatTablePropertyEditor;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLPackage;

public class OwnedParameterOperationPropertyEditor
extends RTNatTablePropertyEditor
implements ISelectionChangedListener {
    private static final int ROW_HEIGHT = 40;
    private TableSelectionProvider selectionProvider;
    private int style;
    private ParameterControlWidget buttonWidget;
    private DisposeListener nattableDisposeListener = null;

    public OwnedParameterOperationPropertyEditor(Composite parent, int style) {
        super(parent, style);
        this.style = style;
    }

    protected void createPreviousWidgets(EObject sourceElement, EStructuralFeature feature) {
        super.createPreviousWidgets(sourceElement, feature);
        this.disposeButton();
        this.buttonWidget = this.createControlButton((Composite)this.self, this.style, sourceElement, this.nattableManager);
    }

    @Override
    protected NatTable createNatTableWidget(INattableModelManager manager, Composite parent, int style, Collection<?> rows) {
        NatTable result = super.createNatTableWidget(manager, parent, style, rows);
        result.getConfigRegistry().registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CustomizedCellPainter(){

            protected String convertDataType(ILayerCell cell, IConfigRegistry configRegistry) {
                String result = super.convertDataType(cell, configRegistry);
                if (Strings.isNullOrEmpty((String)result) && OwnedParameterOperationPropertyEditor.this.isTypeColumn(cell.getColumnIndex())) {
                    result = Messages.NoTypeForTypedElement_Label;
                }
                return result;
            }
        });
        this.setSelectionProvider();
        return result;
    }

    protected void createTableWidget(EObject sourceElement, EStructuralFeature feature, Collection<?> rows) {
        ServicesRegistry privateSuperServiceRegistry = (ServicesRegistry)OwnedParameterOperationPropertyEditor.getField((Object)this, "serviceRegistry");
        if (privateSuperServiceRegistry == null) {
            try {
                OwnedParameterOperationPropertyEditor.setField((Object)this, "serviceRegistry", this.createServiceRegistry(sourceElement));
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
        if ((privateSuperServiceRegistry = (ServicesRegistry)OwnedParameterOperationPropertyEditor.getField((Object)this, "serviceRegistry")) == null) {
            this.displayError("Cannot initialize the service registry");
            return;
        }
        TransactionalEditingDomain domain = this.getTableEditingDomain();
        if (domain == null) {
            this.displayError("Cannot found the editing domain");
            return;
        }
        OwnedParameterOperationPropertyEditor.setField((Object)this, "table", this.getOrCreateTable(sourceElement, feature, rows));
        Table privateSuperTable = (Table)OwnedParameterOperationPropertyEditor.getField((Object)this, "table");
        if (privateSuperTable == null) {
            this.displayError("Cannot initialize the table");
            return;
        }
        CompoundCommand cc = new CompoundCommand("Configure table command");
        Resource privateSuperResource = (Resource)OwnedParameterOperationPropertyEditor.getField((Object)this, "resource");
        if (privateSuperTable.eResource() == null) {
            cc.append(OwnedParameterOperationPropertyEditor.addTableToResource(domain, privateSuperResource, privateSuperTable));
        }
        this.configureTable(domain, privateSuperTable, sourceElement, feature, rows, cc);
        if (!cc.canExecute()) {
            this.displayError("The table can't be initialized");
            return;
        }
        ResourceSet resourceSet = this.getResourceSet();
        resourceSet.getResources().remove((Object)privateSuperResource);
        domain.getCommandStack().execute((Command)cc);
        resourceSet.getResources().add((Object)privateSuperResource);
        if (privateSuperTable.getContext() == null) {
            this.displayError("The context of the table hasn't be set");
            return;
        }
        this.nattableManager = NattableModelManagerFactory.INSTANCE.createNatTableModelManager(privateSuperTable, (ISelectionExtractor)new EObjectSelectionExtractor());
        this.natTableWidget = this.createNatTableWidget(this.nattableManager, (Composite)this.self, 0, rows);
        this.self.addDisposeListener(this.getDisposeListener());
        this.configureLayout();
        ((NattableModelManager)this.nattableManager).refreshNatTable();
    }

    protected static void setField(Object object, String fieldName, Object value) {
        Class<?> search = object.getClass();
        while (search != null) {
            try {
                Field field = search.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(object, value);
                break;
            }
            catch (Exception exception) {
                search = search.getSuperclass();
            }
        }
    }

    protected void configureLayout(EObject sourceElement) {
        this.setLayoutData(new GridData(4, 4, false, false));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.self.setLayout((Layout)layout);
        this.buttonWidget.setLayoutData(new GridData(131072, 4, false, false));
        GridData tableData = new GridData(4, 4, true, true);
        tableData.minimumHeight = ((Operation)sourceElement).getOwnedParameters().size() * 40;
        this.natTableWidget.setLayoutData((Object)tableData);
        this.self.layout();
        this.buttonWidget.getEditor().layout();
        super.configureLayout(sourceElement);
    }

    protected void setSelectionProvider() {
        this.selectionProvider = new TableSelectionProvider(this.nattableManager, this.nattableManager.getBodyLayerStack().getSelectionLayer());
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void disposeButton() {
        if (this.buttonWidget != null) {
            this.buttonWidget.getEditor().dispose();
        }
    }

    public INattableModelManager getTableManager(Table table) {
        return NattableModelManagerFactory.INSTANCE.createNatTableModelManager(table, (ISelectionExtractor)new EObjectSelectionExtractor());
    }

    protected DisposeListener getDisposeListener() {
        if (this.nattableDisposeListener == null) {
            this.nattableDisposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    OwnedParameterOperationPropertyEditor.this.nattableManager.dispose();
                    OwnedParameterOperationPropertyEditor.this.natTableWidget.dispose();
                    OwnedParameterOperationPropertyEditor.this.buttonWidget.getEditor().dispose();
                }
            };
        }
        return this.nattableDisposeListener;
    }

    private static final Command addTableToResource(TransactionalEditingDomain domain, final Resource resource, final Table table) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                resource.getContents().add((Object)table);
            }
        };
    }

    protected ParameterControlWidget createControlButton(Composite parent, int style, EObject sourceElement, INattableModelManager nattableManager) {
        ParameterControlWidget widget = null;
        if (sourceElement instanceof Operation) {
            widget = new ParameterControlWidget(parent, style, (Operation)sourceElement, nattableManager);
            ParameterControlEditor editor = (ParameterControlEditor)widget.getEditor();
            editor.onParameterAdded(this::selectParameterType);
            editor.onParameterMoved(this::refreshParameter);
        }
        return widget;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(1);
        TableStructuredSelection selection = (TableStructuredSelection)event.getSelection();
        TableSelectionWrapper wrapper = (TableSelectionWrapper)selection.getAdapter(TableSelectionWrapper.class);
        Collection selectedCells = wrapper.getSelectedCells();
        int rowPosition = 0;
        for (PositionCoordinate coordinate : selectedCells) {
            rowPosition = coordinate.getRowPosition();
            RowHideShowLayer rowHideShowLayer = this.nattableManager.getBodyLayerStack().getRowHideShowLayer();
            int realRowIndex = rowHideShowLayer.getRowIndexByPosition(rowPosition);
            Object rowElement = AxisUtils.getRepresentedElement((Object)this.nattableManager.getRowElement(realRowIndex));
            if (!(rowElement instanceof Parameter) || parameters.contains(rowElement)) continue;
            parameters.add((Parameter)rowElement);
        }
        this.buttonWidget.setParameters(parameters);
        ((ParameterControlEditor)this.buttonWidget.getEditor()).updateButtons();
    }

    protected void selectParameterType(Parameter parameter) {
        this.natTableWidget.getDisplay().asyncExec(() -> {
            BodyLayerStack stack = this.nattableManager.getBodyLayerStack();
            SelectionLayer selectionLayer = stack.getSelectionLayer();
            int type = this.getTypeColumnIndex();
            int index = parameter.getOperation().getOwnedParameters().indexOf((Object)parameter);
            int selectionIndex = selectionLayer.getRowPositionByIndex(index);
            if (selectionIndex >= 0) {
                SelectCellCommand select = new SelectCellCommand((ILayer)selectionLayer, type, selectionIndex, false, false);
                select.setForcingEntireCellIntoViewport(true);
                this.natTableWidget.doCommand((ILayerCommand)select);
            }
        });
    }

    protected void refreshParameter(Parameter parameter, int oldIndex) {
        this.natTableWidget.getDisplay().asyncExec(() -> {
            int index;
            BodyLayerStack stack = this.nattableManager.getBodyLayerStack();
            SelectionLayer selectionLayer = stack.getSelectionLayer();
            int selectionIndex = selectionLayer.getRowPositionByIndex(index = parameter.getOperation().getOwnedParameters().indexOf((Object)parameter));
            if (selectionIndex >= 0) {
                int step = index - oldIndex;
                MoveSelectionCommand follow = new MoveSelectionCommand(step > 0 ? SelectionLayer.MoveDirectionEnum.DOWN : SelectionLayer.MoveDirectionEnum.UP, Integer.valueOf(Math.abs(step)), false, false);
                this.natTableWidget.doCommand((ILayerCommand)follow);
            }
        });
    }

    private boolean isTypeColumn(int columnIndex) {
        Object element = AxisUtils.getRepresentedElement((Object)this.nattableManager.getColumnElement(columnIndex));
        return element == UMLPackage.Literals.TYPED_ELEMENT__TYPE;
    }

    private int getTypeColumnIndex() {
        int result = -1;
        int count = this.nattableManager.getColumnCount();
        int i = 0;
        while (result < 0 && i < count) {
            if (this.isTypeColumn(i)) {
                result = i;
            }
            ++i;
        }
        return result;
    }
}

