/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class ConstantContentProvider implements IHierarchicContentProvider {

	@Override
	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

	@Override
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof EObject) {
			return ((EObject) parentElement).eContents().toArray();
		}
		return null;
	}

	@Override
	public Object getParent(Object element) {
		if (element instanceof EObject) {
			return ((EObject) element).eContainer();
		}
		return null;
	}

	@Override
	public boolean hasChildren(Object element) {
		return getChildren(element).length > 0;
	}

	@Override
	public boolean isValidValue(Object element) {
		// only constant could be selected: constant is represented as class property with default value
		if (!(element instanceof Property)) {
			return false;
		} else {
			// do not allow to select Capsule Part or RT Port
			if (CapsulePartUtils.isCapsulePart((Property) element) || (RTPortUtils.isRTPort((Property) element))) {
				return false;
			} else {
				return ((Property) element).eIsSet(UMLPackage.eINSTANCE.getProperty_DefaultValue());
			}
		}

	}

}