/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.papyrus.infra.widgets.editors.EnumRadio;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/**
 * Value Editor specific to the PortRTKind.
 */
public class PortRTKindValueEditor extends EnumRadio {

	public PortRTKindValueEditor(Composite parent, int style, String label) {
		super(parent, style, label);
	}

	public PortRTKindValueEditor(Composite parent, int style) {
		super(parent, style);
	}

	@Override
	public void setReadOnly(boolean readOnly) {
		for (Button button : values.keySet()) {
			if (readOnly) {
				if (!button.isDisposed()) {
					button.setEnabled(false);
				}
			}
		}
		if (!buttonsArea.isDisposed()) {
			buttonsArea.setEnabled(!readOnly);
		}
	}

	/**
	 * Sets the read only state for a particular value of the enum radio. if the button is the selected one, no change will be applied to it
	 * 
	 * @param value
	 *            the value for which read only status should be applied
	 * @param readOnly
	 *            <code>true</code> if the element should be set read only
	 */
	public void setReadOnly(Object value, boolean readOnly) {
		for (Button button : values.keySet()) {
			// even if not read only, we should check each value if it has some specifics that apply and make it not enable
			Object object = values.get(button);
			if (object == value) {
				if (!button.isDisposed()) {
					button.setEnabled(readOnly);
				}

			}
		}
	}

	@Override
	public boolean isReadOnly() {
		for (Button button : values.keySet()) {
			if (!button.isDisposed() && button.isEnabled()) {
				return false;
			}
		}
		return true;
	}
}
