/*****************************************************************************
 * Copyright (c) 2015 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Ansgar Radermacher (CEA LIST) ansgar.radermacher@cea.fr - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.papyrus.infra.properties.ui.widgets.MultiReference;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrusrt.umlrt.tooling.ui.editors.PortSelectionEditor;
import org.eclipse.swt.widgets.Composite;

/**
 * A dialog for UML/RT port selection within a trigger. References the specific port selection editor.
 */
public class PortReference extends MultiReference {

	public PortReference(Composite parent, int style) {
		super(parent, style);
	}

	/**
	 * Creates the reference editor.
	 *
	 * @param parent
	 *            The composite in which the widget will be displayed
	 * @param style
	 *            The style for the widget
	 * @return The reference editor
	 */
	protected MultipleReferenceEditor createMultipleReferenceEditor(Composite parent, int style) {
		return new PortSelectionEditor(parent, style);
	}
}
