/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.properties.ui.creation.CreationContext;
import org.eclipse.papyrus.infra.properties.ui.creation.EcorePropertyEditorFactory;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.IFilteredObservableList;

public class RTPropertyEditorFactory
extends UMLPropertyEditorFactory {
    private final IObservableList<?> modelProperty;
    private final Map<EObject, Predicate<Object>> modelPropertyFilters = new HashMap<EObject, Predicate<Object>>();

    public RTPropertyEditorFactory(EReference referenceIn) {
        this(referenceIn, null);
    }

    public RTPropertyEditorFactory(EReference referenceIn, IObservableList<?> modelProperty) {
        super(referenceIn);
        this.modelProperty = modelProperty;
    }

    protected CreationContext getCreationContext(Object element) {
        CreationContext result = super.getCreationContext(element);
        return result == null ? result : this.wrapCreationContext(result);
    }

    private CreationContext wrapCreationContext(CreationContext context) {
        return new AttachedCreationContext(context);
    }

    EcorePropertyEditorFactory.CreateIn getCreateIn(CreationContext context, EObject newElement) {
        EcorePropertyEditorFactory.CreateIn result = null;
        if (this.referenceIn.isContainment()) {
            result = new EcorePropertyEditorFactory.CreateIn((EcorePropertyEditorFactory)this){};
            result.createInReference = this.referenceIn;
            result.createInObject = (EObject)context.getCreationContextElement();
        } else {
            result = (EcorePropertyEditorFactory.CreateIn)this.createIn.get(newElement);
        }
        return result;
    }

    void filter(EObject createdObject) {
        IFilteredObservableList<?> list = IFilteredObservableList.getFilteredList(this.modelProperty);
        if (list != null) {
            list.addFilter(this.getFilter(createdObject));
        }
    }

    private Predicate<Object> getFilter(EObject createdObject) {
        return this.modelPropertyFilters.computeIfAbsent(createdObject, v -> o -> o != v);
    }

    void unfilter(EObject createdObject) {
        IFilteredObservableList<?> list = IFilteredObservableList.getFilteredList(this.modelProperty);
        if (list != null) {
            list.removeFilter(this.modelPropertyFilters.remove(createdObject));
        }
    }

    class AttachedCreationContext
    implements CreationContext {
        private final CreationContext delegate;

        AttachedCreationContext(CreationContext delegate) {
            this.delegate = delegate;
        }

        public void pushCreatedElement(Object newElement) {
            EObject created;
            EcorePropertyEditorFactory.CreateIn createIn;
            if (newElement instanceof EObject && (createIn = RTPropertyEditorFactory.this.getCreateIn(this, created = (EObject)newElement)) != null) {
                RTPropertyEditorFactory.this.filter(created);
                this.eAdd(createIn.createInObject, (EStructuralFeature)createIn.createInReference, created);
            }
            this.delegate.pushCreatedElement(newElement);
        }

        private void eAdd(EObject owner, EStructuralFeature feature, Object value) {
            if (feature.isMany()) {
                ((EList)owner.eGet(feature)).add(value);
            } else {
                owner.eSet(feature, value);
            }
        }

        public void popCreatedElement(Object newElement) {
            EObject created;
            EcorePropertyEditorFactory.CreateIn createIn;
            this.delegate.popCreatedElement(newElement);
            if (newElement instanceof EObject && (createIn = RTPropertyEditorFactory.this.getCreateIn(this, created = (EObject)newElement)) != null) {
                this.eRemove(createIn.createInObject, (EStructuralFeature)createIn.createInReference, created);
                RTPropertyEditorFactory.this.unfilter(created);
            }
        }

        private void eRemove(EObject owner, EStructuralFeature feature, Object value) {
            if (feature.isMany()) {
                ((EList)owner.eGet(feature)).remove(value);
            } else if (owner.eGet(feature) == value) {
                owner.eUnset(feature);
            }
        }

        public EObject getCreationContextElement() {
            return (EObject)this.delegate.getCreationContextElement();
        }
    }
}

