/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.providers;

import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.SystemElementsUtils;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Package;

public class PortTypeContentProvider
extends EncapsulatedContentProvider {
    public PortTypeContentProvider(IStaticContentProvider provider) {
        super((IStructuredContentProvider)provider);
    }

    public boolean isValidValue(Object element) {
        boolean result = super.isValidValue(element);
        if (result) {
            EObject eObject = EMFHelper.getEObject((Object)element);
            result = ProtocolUtils.isProtocol((EObject)eObject) != false && !SystemElementsUtils.isBaseProtocol((Collaboration)((Collaboration)eObject));
        }
        return result;
    }

    public Object[] getElements() {
        return Stream.of(super.getElements()).toArray();
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public Object[] getChildren(Object parentElement) {
        return Stream.of(super.getChildren(parentElement)).filter(this::isNavigable).toArray();
    }

    private boolean isNavigable(Object object) {
        EObject element = EMFHelper.getEObject((Object)object);
        return element != null && (element instanceof Package || this.isValidValue(element));
    }
}

