/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguageService;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MultipleAdapter;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class PropertyReplicationObservableValue
extends PapyrusObservableValue
implements IObserving {
    public static final String STAR = "*";
    private Property propertyElement;
    private PartAdapter partAdapter;

    public PropertyReplicationObservableValue(EObject property, TransactionalEditingDomain domain) {
        super(property, property.eContainingFeature(), (EditingDomain)domain);
        if (property instanceof Property) {
            this.propertyElement = (Property)property;
            this.propertyElement.eAdapters().add((Object)this.getPartAdapter());
            if (this.propertyElement.getLowerValue() != null) {
                this.propertyElement.getLowerValue().eAdapters().add((Object)this.getPartAdapter());
            }
            if (this.propertyElement.getUpperValue() != null) {
                this.propertyElement.getUpperValue().eAdapters().add((Object)this.getPartAdapter());
            }
        }
    }

    public synchronized void dispose() {
        try {
            if (this.partAdapter != null) {
                this.partAdapter.dispose();
                this.partAdapter = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    protected Object doGetValue() {
        String value = Integer.toString(this.propertyElement.getUpper());
        if (this.propertyElement.getUpperValue() != null && this.propertyElement.getLowerValue() != null) {
            value = this.propertyElement.getUpperValue().stringValue();
        } else if (this.propertyElement.getLowerValue() == null && this.propertyElement.getUpperValue() == null) {
            value = "None (1)";
        }
        return value;
    }

    public Command getCommand(Object value) {
        OpaqueExpression newUpperValue = null;
        OpaqueExpression newLowerValue = null;
        if (value instanceof String && value != null) {
            if (((String)value).matches("[0-9]*|\\*")) {
                int upperValue = value.equals(STAR) ? -1 : Integer.decode((String)value);
                int lowerValue = CapsulePartUtils.isCapsulePart((Property)this.propertyElement) && this.propertyElement.getLower() == 0 ? 0 : (upperValue == -1 ? 0 : upperValue);
                newUpperValue = UMLFactory.eINSTANCE.createLiteralUnlimitedNatural();
                ((LiteralUnlimitedNatural)newUpperValue).setValue(upperValue);
                newLowerValue = UMLFactory.eINSTANCE.createLiteralInteger();
                ((LiteralInteger)newLowerValue).setValue(lowerValue);
            } else if (((String)value).equals("None (1)")) {
                newLowerValue = null;
                newUpperValue = null;
            } else {
                newUpperValue = UMLFactory.eINSTANCE.createOpaqueExpression();
                this.setOpaqueExpressionProperties(newUpperValue, (String)value);
                if (CapsulePartUtils.isCapsulePart((Property)this.propertyElement)) {
                    if (this.propertyElement.getLower() != 0) {
                        newLowerValue = UMLFactory.eINSTANCE.createOpaqueExpression();
                        this.setOpaqueExpressionProperties(newLowerValue, (String)value);
                    } else {
                        newLowerValue = UMLFactory.eINSTANCE.createLiteralInteger();
                        ((LiteralInteger)newLowerValue).setValue(0);
                    }
                } else if (RTPortUtils.isRTPort((EObject)this.propertyElement)) {
                    newLowerValue = UMLFactory.eINSTANCE.createOpaqueExpression();
                    this.setOpaqueExpressionProperties(newLowerValue, (String)value);
                }
            }
        }
        Command command = this.getCommandForCapsulePart((ValueSpecification)newLowerValue, (ValueSpecification)newUpperValue);
        return command;
    }

    private String getDefaultLanguage() {
        String defaultLanguage = null;
        try {
            if (this.propertyElement != null) {
                IDefaultLanguageService service = (IDefaultLanguageService)ServiceUtilsForEObject.getInstance().getService(IDefaultLanguageService.class, (Object)this.propertyElement);
                service.startService();
                IDefaultLanguage language = service.getActiveDefaultLanguage((Element)this.propertyElement);
                defaultLanguage = language.getName();
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return defaultLanguage;
    }

    private void setOpaqueExpressionProperties(OpaqueExpression oe, String value) {
        oe.getBodies().add((Object)value);
        oe.getLanguages().add((Object)this.getDefaultLanguage());
    }

    protected Command getCommandForCapsulePart(ValueSpecification newLowerValue, ValueSpecification newUpperValue) {
        try {
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getObserved());
            if (provider != null) {
                CompositeCommand cc = new CompositeCommand("Edit value");
                IEditCommandRequest createUpperSetRequest = this.createSetRequest((TransactionalEditingDomain)this.domain, this.eObject, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue(), newUpperValue);
                IEditCommandRequest createLowerSetRequest = this.createSetRequest((TransactionalEditingDomain)this.domain, this.eObject, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue(), newLowerValue);
                if (createLowerSetRequest == null || createUpperSetRequest == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                cc.add((IUndoableOperation)provider.getEditCommand(createUpperSetRequest));
                cc.add((IUndoableOperation)provider.getEditCommand(createLowerSetRequest));
                return new GMFtoEMFCommandWrapper((ICommand)cc);
            }
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected IEditCommandRequest createSetRequest(TransactionalEditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        return new SetRequest(domain, owner, feature, value);
    }

    public Object getObserved() {
        return this.propertyElement;
    }

    public Object getValueType() {
        return String.class;
    }

    protected Adapter getMultiplicityListener() {
        return this.getPartAdapter();
    }

    private Adapter getPartAdapter() {
        if (this.partAdapter == null) {
            this.partAdapter = new PartAdapter();
        }
        return this.partAdapter;
    }

    private class PartAdapter
    extends MultipleAdapter {
        PartAdapter() {
            super(4);
        }

        public void notifyChanged(Notification notification) {
            if (!notification.isTouch()) {
                Object notifier = notification.getNotifier();
                int type = notification.getEventType();
                Object feature = notification.getFeature();
                if (notifier == PropertyReplicationObservableValue.this.propertyElement && type == 1) {
                    if (feature == UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE || feature == UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE) {
                        if (notification.getOldValue() != null) {
                            ((ValueSpecification)notification.getOldValue()).eAdapters().remove((Object)this);
                        }
                        if (notification.getNewValue() != null) {
                            ((ValueSpecification)notification.getNewValue()).eAdapters().add((Object)this);
                        }
                        this.fireDiff(notification);
                    }
                } else if (notifier == PropertyReplicationObservableValue.this.propertyElement.getLowerValue() && type == 1) {
                    this.fireDiff(notification);
                } else if (notifier == PropertyReplicationObservableValue.this.propertyElement.getUpperValue() && type == 1) {
                    this.fireDiff(notification);
                }
            }
        }

        private void fireDiff(Notification notification) {
            final ValueDiff diff = Diffs.createValueDiff((Object)notification.getOldValue(), (Object)notification.getNewValue());
            PropertyReplicationObservableValue.this.getRealm().exec(new Runnable(){

                @Override
                public void run() {
                    PropertyReplicationObservableValue.this.fireValueChange(diff);
                }
            });
        }
    }
}

