/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.trans.to.text;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.trans.from.uml.UML2xtumlrtModelTranslator;
import org.eclipse.papyrusrt.xtumlrt.trans.preproc.ModelPreprocessor;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTLogger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class UMLRT2textTransformer {
    @Inject
    @Named(value="file.extensions")
    private String TUMLRT_FILE_EXTENSION;
    public static final String SRC_GEN = ".";
    private static final String DEFAULT_NAME = "unnamed";
    private static final String DEFAULT_TUMLRT_FILE_EXTENSION = "umlrt";
    private final ModelPreprocessor modelPreprocessor = new ModelPreprocessor();
    private final UML2xtumlrtModelTranslator uml2xtumlrtTranslator = new UML2xtumlrtModelTranslator();
    protected Resource inputModelResource;
    private ResourceSet resourceSet;
    private String fileExtension;

    public ResourceSet setTarget(Target target) {
        XtextResourceSet _switchResult = null;
        if (target != null) {
            switch (target) {
                case TUMLRT: {
                    XtextResourceSet _xblockexpression = null;
                    this.fileExtension = DEFAULT_TUMLRT_FILE_EXTENSION;
                    XtextResourceSet _xtextResourceSet = new XtextResourceSet();
                    this.resourceSet = _xtextResourceSet;
                    _switchResult = _xblockexpression = this.resourceSet;
                    break;
                }
                case XML: {
                    ResourceSetImpl _xblockexpression_1 = null;
                    this.fileExtension = "xml";
                    ResourceSetImpl _resourceSetImpl = new ResourceSetImpl();
                    this.resourceSet = _resourceSetImpl;
                    _xblockexpression_1 = this.resourceSet;
                    _switchResult = _xblockexpression_1;
                    break;
                }
            }
        }
        return _switchResult;
    }

    protected boolean _save(org.eclipse.papyrusrt.xtumlrt.common.Model model) {
        boolean _xblockexpression = false;
        boolean result = false;
        if (model == null) {
            XTUMLRTLogger.error((String)"Attempted to save 'null' as a model");
        } else {
            boolean overwrite;
            URI newURI;
            boolean _modelExists;
            this.modelPreprocessor.preprocess(model);
            if (this.inputModelResource == null) {
                Resource _eResource;
                this.inputModelResource = _eResource = model.eResource();
            }
            if ((_modelExists = UMLRT2textTransformer.modelExists(newURI = this.getTargetURI((EObject)model))) && !(overwrite = UMLRT2textTransformer.askToOverwrite())) {
                result = true;
            }
            if (!result) {
                Resource newResource = this.resourceSet.createResource(newURI);
                if (newResource != null) {
                    EList _contents = newResource.getContents();
                    _contents.add((Object)model);
                    try {
                        newResource.save(Collections.EMPTY_MAP);
                        result = true;
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            XTUMLRTLogger.error((String)("Serialization to " + this.fileExtension + " failed"), (Throwable)e);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                } else {
                    String _string = newURI.toString();
                    String _plus = "Failed to create resource : '" + _string;
                    String _plus_1 = String.valueOf(_plus) + "'";
                    XTUMLRTLogger.error((String)_plus_1);
                }
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected boolean _save(Model model) {
        boolean _xblockexpression = false;
        boolean result = false;
        if (model == null) {
            XTUMLRTLogger.error((String)"Attempted to save 'null' as a model");
        } else {
            boolean _save;
            Resource _eResource;
            this.inputModelResource = _eResource = model.eResource();
            this.uml2xtumlrtTranslator.resetAll();
            CommonElement _translateElement = this.uml2xtumlrtTranslator.translateElement((Element)model);
            org.eclipse.papyrusrt.xtumlrt.common.Model translatedModel = (org.eclipse.papyrusrt.xtumlrt.common.Model)_translateElement;
            result = _save = this.save((EObject)translatedModel);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    private String getFileExtension() {
        String _xblockexpression = null;
        boolean _equals = Objects.equal((Object)this.fileExtension, null);
        if (_equals) {
            String _xifexpression = null;
            _xifexpression = !Objects.equal((Object)this.TUMLRT_FILE_EXTENSION, null) && !this.TUMLRT_FILE_EXTENSION.isEmpty() ? this.TUMLRT_FILE_EXTENSION : DEFAULT_TUMLRT_FILE_EXTENSION;
            this.fileExtension = _xifexpression;
        }
        _xblockexpression = this.fileExtension;
        return _xblockexpression;
    }

    private String setFileExtension(String ext) {
        this.fileExtension = ext;
        return this.fileExtension;
    }

    private URI getTargetURI(EObject eobj) {
        URI _uRI = this.inputModelResource.getURI();
        URI _trimFileExtension = _uRI.trimFileExtension();
        String _fileExtension = this.getFileExtension();
        return _trimFileExtension.appendFileExtension(_fileExtension);
    }

    private String _getModelName(org.eclipse.papyrusrt.xtumlrt.common.Model model) {
        String _xblockexpression = null;
        String name = model.getName();
        String _xifexpression = null;
        _xifexpression = name != null && !name.isEmpty() ? name : DEFAULT_NAME;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String _getModelName(Model model) {
        String _xblockexpression = null;
        String name = model.getName();
        String _xifexpression = null;
        _xifexpression = name != null && !name.isEmpty() ? name : DEFAULT_NAME;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String _getModelName(ENamedElement element) {
        String _xblockexpression = null;
        String name = element.getName();
        String _xifexpression = null;
        _xifexpression = name != null && !name.isEmpty() ? name : DEFAULT_NAME;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String _getModelName(EObject eobj) {
        return DEFAULT_NAME;
    }

    private static boolean modelExists(URI uri) {
        boolean exists;
        boolean _xblockexpression = false;
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = _workspace.getRoot();
        String _platformString = uri.toPlatformString(true);
        Path _path = new Path(_platformString);
        IFile file = _root.getFile((IPath)_path);
        _xblockexpression = exists = file.exists();
        return _xblockexpression;
    }

    private static boolean askToOverwrite() {
        boolean _xblockexpression = false;
        Display _current = Display.getCurrent();
        Shell _activeShell = _current.getActiveShell();
        MessageBox dialog = new MessageBox(_activeShell, 296);
        dialog.setText("Warning");
        dialog.setMessage("Do you want to overwrite the existing model?");
        int _open = dialog.open();
        _xblockexpression = _open == 32;
        return _xblockexpression;
    }

    public boolean save(EObject model) {
        if (model instanceof Model) {
            return this._save((Model)model);
        }
        if (model instanceof org.eclipse.papyrusrt.xtumlrt.common.Model) {
            return this._save((org.eclipse.papyrusrt.xtumlrt.common.Model)model);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(model).toString());
    }

    private String getModelName(EObject model) {
        if (model instanceof Model) {
            return this._getModelName((Model)model);
        }
        if (model instanceof org.eclipse.papyrusrt.xtumlrt.common.Model) {
            return this._getModelName((org.eclipse.papyrusrt.xtumlrt.common.Model)model);
        }
        if (model instanceof ENamedElement) {
            return this._getModelName((ENamedElement)model);
        }
        if (model != null) {
            return this._getModelName(model);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(model).toString());
    }

    public static enum Target {
        TUMLRT,
        XML;

    }
}

