/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.xtext.codegen.ui.cdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.IEObjectLocator;
import org.eclipse.papyrusrt.codegen.UserEditableRegion;
import org.eclipse.papyrusrt.xtumlrt.common.AbstractAction;
import org.eclipse.papyrusrt.xtumlrt.common.ActionCode;
import org.eclipse.papyrusrt.xtumlrt.common.BaseContainer;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.Entity;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.common.Operation;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.statemach.CompositeState;
import org.eclipse.papyrusrt.xtumlrt.statemach.State;
import org.eclipse.papyrusrt.xtumlrt.statemach.StateMachine;
import org.eclipse.papyrusrt.xtumlrt.statemach.Transition;
import org.eclipse.papyrusrt.xtumlrt.statemach.Trigger;
import org.eclipse.papyrusrt.xtumlrt.statemach.Vertex;
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTPassiveClass;
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTPort;
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTTrigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtext.resource.XtextResourceSet;

public class UmlrtXtextEObjectLocator
implements IEObjectLocator {
    public static final String LANGUAGE = "C++";
    private XtextResourceSet resourcelSet = new XtextResourceSet();

    private Model getRoot(String uri) {
        Model result = null;
        URI resourceUri = URI.createURI((String)uri);
        if ("umlrt".equals(resourceUri.fileExtension())) {
            Resource r = this.resourcelSet.getResource(resourceUri, true);
            result = (Model)r.getContents().get(0);
        }
        return result;
    }

    public EObject getEObject(UserEditableRegion.Label label) {
        ArrayList<String> qualifiedNames = new ArrayList<String>();
        qualifiedNames.addAll(Arrays.asList(label.getQualifiedName().split("::")));
        Model nextPackage = this.getRoot(label.getUri());
        if (nextPackage == null) {
            return null;
        }
        Entity capsuleOrClass = null;
        qualifiedNames.remove(0);
        while (!qualifiedNames.isEmpty()) {
            String qname = (String)qualifiedNames.remove(0);
            Package child = this.getChildPackage((BaseContainer)nextPackage, qname);
            if (child == null) {
                capsuleOrClass = this.getChildEntity((BaseContainer)nextPackage, qname);
                break;
            }
            nextPackage = child;
        }
        EObject result = null;
        if (capsuleOrClass == null) {
            CodeGenPlugin.error((String)("Element not found : " + label.getQualifiedName()));
        } else if (label.getType().equals(UMLPackage.Literals.OPERATION.getName().toLowerCase())) {
            RTPassiveClass clazz = (RTPassiveClass)capsuleOrClass;
            Operation operation = null;
            for (Operation op : clazz.getOperations()) {
                if (!label.getDetails().equals(op.getName())) continue;
                operation = op;
                break;
            }
            result = operation.getBody();
        } else {
            EObject smElement = this.getSMElement((Capsule)capsuleOrClass, qualifiedNames);
            result = this.getUserCodeElement(smElement, label.getType(), label.getDetails());
        }
        return result;
    }

    private Entity getChildEntity(BaseContainer container, String name) {
        Entity result = null;
        for (Entity e : container.getEntities()) {
            if (!name.equals(e.getName())) continue;
            result = e;
            break;
        }
        return result;
    }

    private Package getChildPackage(BaseContainer container, String name) {
        Package result = null;
        for (Package e : container.getPackages()) {
            if (!name.equals(e.getName())) continue;
            result = e;
            break;
        }
        return result;
    }

    private EObject getUserCodeElement(EObject container, String type, String details) {
        Transition t;
        AbstractAction result = null;
        if (type.equals(UMLPackage.Literals.TRANSITION.getName().toLowerCase())) {
            Transition t2 = this.getTransition(container, details);
            if (t2 != null && t2.getActionChain() != null) {
                if (t2.getActionChain().getActions().isEmpty()) {
                    CodeGenPlugin.warning((String)("No transition action found for " + UmlrtXtextEObjectLocator.getSMQualifiedName((EObject)t2)));
                } else {
                    result = (EObject)t2.getActionChain().getActions().get(0);
                }
            }
        } else if (type.equals(UMLPackage.Literals.STATE__ENTRY.getName())) {
            if (container instanceof State) {
                State s = (State)container;
                result = s.getEntryAction();
            }
        } else if (type.equals(UMLPackage.Literals.STATE__EXIT.getName())) {
            if (container instanceof State) {
                State s = (State)container;
                result = s.getExitAction();
            }
        } else if (type.equals(UMLPackage.Literals.TRANSITION__GUARD.getName()) && (t = this.getTransition(container, details)) != null) {
            result = t.getGuard().getBody();
        }
        return result;
    }

    private EObject getSMElement(Capsule capsule, List<String> qnameRelativeToSM) {
        StateMachine sm = (StateMachine)capsule.getBehaviour();
        CompositeState nextCompositeState = sm.getTop();
        StateMachine result = sm;
        while (!qnameRelativeToSM.isEmpty()) {
            State subState = null;
            String stateName = qnameRelativeToSM.remove(0);
            for (State s : nextCompositeState.getSubstates()) {
                if (!s.getName().equals(stateName)) continue;
                subState = s;
                break;
            }
            if (subState == null) break;
            if (subState instanceof CompositeState) {
                nextCompositeState = (CompositeState)subState;
            }
            result = subState;
        }
        if (!qnameRelativeToSM.isEmpty()) {
            result = null;
        }
        if (result == null) {
            CodeGenPlugin.error((String)"No matching state machine element found.");
        }
        return result;
    }

    private Transition getTransition(EObject container, String transitionDetails) {
        Transition result = null;
        CompositeState region = null;
        region = container instanceof StateMachine ? ((StateMachine)container).getTop() : (CompositeState)container;
        if (region != null) {
            UserEditableRegion.TransitionDetails details = new UserEditableRegion.TransitionDetails(transitionDetails);
            block0: for (Transition transition : region.getTransitions()) {
                if (!UmlrtXtextEObjectLocator.getSMQualifiedName((EObject)transition.getSourceVertex()).equals(details.getSourceQname()) || !UmlrtXtextEObjectLocator.getSMQualifiedName((EObject)transition.getTargetVertex()).equals(details.getTargetQname())) continue;
                if (details.getTriggerDetailMap().isEmpty()) {
                    result = transition;
                    break;
                }
                boolean found = false;
                for (Map.Entry entry : details.getTriggerDetailMap().entrySet()) {
                    for (Trigger t : transition.getTriggers()) {
                        RTTrigger trigger = (RTTrigger)t;
                        if (trigger.getSignal().getName().equals(entry.getKey()) && this.comparetriggerPorts((List<RTPort>)trigger.getPorts(), (List)entry.getValue())) {
                            found = true;
                            break;
                        }
                        if (!found) break;
                    }
                    if (!found) continue;
                    result = transition;
                    continue block0;
                }
            }
        }
        return result;
    }

    private boolean comparetriggerPorts(List<RTPort> ports, List<String> expectedPorts) {
        ArrayList<String> actualPorts = new ArrayList<String>();
        for (Port port : ports) {
            actualPorts.add(port.getName());
        }
        actualPorts.retainAll(expectedPorts);
        return actualPorts.size() == expectedPorts.size();
    }

    public static String getSMQualifiedName(EObject eObject) {
        String result = "";
        EObject container = eObject;
        while (container != null && !(container.eContainer() instanceof StateMachine)) {
            if (container instanceof Vertex) {
                if (result.length() != 0) {
                    result = "::" + result;
                }
                result = String.valueOf(((Vertex)container).getName()) + result;
            }
            container = container.eContainer();
        }
        return result;
    }

    public EObject saveSource(UserEditableRegion.Label label, String source) {
        EObject eo = this.getEObject(label);
        if (eo instanceof ActionCode) {
            ActionCode action = (ActionCode)eo;
            action.setSource(source);
        }
        return eo;
    }
}

