/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.internal.defaultlanguage;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguageRegistry;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Type;

public class DefaultLanguageRegistry
implements IDefaultLanguageRegistry {
    private static final String EXT_POINT = "defaultLanguage";
    private static final IDefaultLanguage NULL_DEFAULT_LANGUAGE = new IDefaultLanguage(){

        @Override
        public String getId() {
            return "NULL";
        }

        @Override
        public String getName() {
            return "NullName";
        }

        @Override
        public String getIconURL() {
            return null;
        }

        @Override
        public Set<String> getProfilesToApply() {
            return Collections.emptySet();
        }

        @Override
        public Set<String> getLibrariesToImport() {
            return Collections.emptySet();
        }

        @Override
        public Set<Type> getSpecificPrimitiveTypes(ResourceSet resourceSet) {
            return Collections.emptySet();
        }

        @Override
        public Set<Collaboration> getSystemProtocols(ResourceSet resourceSet) {
            return Collections.emptySet();
        }

        @Override
        public Collaboration getBaseProtocol(ResourceSet resourceSet) {
            return null;
        }

        @Override
        public Set<Class> getSystemClasses(ResourceSet resourceSet) {
            return Collections.emptySet();
        }
    };
    private static IDefaultLanguageRegistry instance;
    private boolean needPrune;
    private final List<IDefaultLanguage> defaultLanguages = Lists.newArrayListWithExpectedSize((int)1);

    public static synchronized IDefaultLanguageRegistry getInstance() {
        if (instance == null) {
            instance = new DefaultLanguageRegistry();
        }
        return instance;
    }

    private DefaultLanguageRegistry() {
        new DefaultLanguageRegistryReader().readRegistry();
    }

    @Override
    public List<? extends IDefaultLanguage> getLanguages() {
        this.prune();
        return Collections.unmodifiableList(this.defaultLanguages);
    }

    private void prune() {
        if (this.needPrune) {
            this.needPrune = false;
            ListIterator<IDefaultLanguage> iter = this.defaultLanguages.listIterator();
            while (iter.hasNext()) {
                DefaultLanguageRegistryReader.DefaultLanguageDescriptor desc;
                IDefaultLanguage next = iter.next();
                if (next == NULL_DEFAULT_LANGUAGE) {
                    iter.remove();
                    continue;
                }
                if (!(next instanceof DefaultLanguageRegistryReader.DefaultLanguageDescriptor) || (desc = (DefaultLanguageRegistryReader.DefaultLanguageDescriptor)next).instance == null) continue;
                iter.set(desc.instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProvider(String className) {
        List<IDefaultLanguage> list = this.defaultLanguages;
        synchronized (list) {
            Iterator<IDefaultLanguage> iter = this.defaultLanguages.iterator();
            while (iter.hasNext()) {
                IDefaultLanguage next = iter.next();
                if (next instanceof DefaultLanguageRegistryReader.DefaultLanguageDescriptor) {
                    DefaultLanguageRegistryReader.DefaultLanguageDescriptor desc = (DefaultLanguageRegistryReader.DefaultLanguageDescriptor)next;
                    if (!className.equals(desc.getClassName())) continue;
                    iter.remove();
                    break;
                }
                if (!className.equals(next.getClass().getName())) continue;
                iter.remove();
                break;
            }
        }
    }

    private class DefaultLanguageRegistryReader
    extends RegistryReader {
        private static final String E_DEFAULT_LANGUAGE = "defaultLanguage";
        private static final String A_CLASS = "class";
        private static final String A_ID = "id";
        private static final String A_NAME = "name";
        private static final String A_ICON_URL = "iconURL";
        private DefaultLanguageDescriptor currentDescriptor;

        public DefaultLanguageRegistryReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrusrt.umlrt.core", "defaultLanguage");
            Activator.log.trace("defaultLanguage", "Create a registry reader for DefaultLanguage");
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            return add ? this.handleAdd(element) : this.handleRemove(element);
        }

        private boolean handleAdd(IConfigurationElement element) {
            boolean result = true;
            if ("defaultLanguage".equals(element.getName())) {
                this.currentDescriptor = new DefaultLanguageDescriptor(element, A_CLASS);
                DefaultLanguageRegistry.this.defaultLanguages.add(this.currentDescriptor);
            }
            return result;
        }

        private boolean handleRemove(IConfigurationElement element) {
            String className;
            boolean result = true;
            if ("defaultLanguage".equals(element.getName()) && (className = this.getClassName(element, A_CLASS)) != null) {
                DefaultLanguageRegistry.this.removeProvider(className);
            }
            return result;
        }

        private String getClassName(IConfigurationElement provider, String attributeName) {
            IConfigurationElement[] classes;
            String result = provider.getAttribute(attributeName);
            if (result == null && (classes = provider.getChildren(attributeName)).length > 0) {
                result = classes[0].getAttribute(A_CLASS);
            }
            return result;
        }

        public class DefaultLanguageDescriptor
        extends RegistryReader.PluginClassDescriptor
        implements IDefaultLanguage {
            private IDefaultLanguage instance;

            public DefaultLanguageDescriptor(IConfigurationElement element, String attributeName) {
                super(element, attributeName);
            }

            private String getClassName() {
                return DefaultLanguageRegistryReader.this.getClassName(this.element, this.attributeName);
            }

            private IDefaultLanguage getInstance() {
                if (this.instance == null) {
                    try {
                        String className = this.getClassName();
                        this.instance = className == null ? NULL_DEFAULT_LANGUAGE : (IDefaultLanguage)this.createInstance();
                    }
                    catch (Exception e) {
                        Activator.log.error("Failed to instantiate default language extension.", (Throwable)e);
                        this.instance = NULL_DEFAULT_LANGUAGE;
                    }
                    DefaultLanguageRegistry.this.needPrune = true;
                }
                return this.instance;
            }

            @Override
            public String getId() {
                return this.element.getAttribute(DefaultLanguageRegistryReader.A_ID);
            }

            @Override
            public String getName() {
                return this.element.getAttribute(DefaultLanguageRegistryReader.A_NAME);
            }

            @Override
            public String getIconURL() {
                return this.element.getAttribute(DefaultLanguageRegistryReader.A_ICON_URL);
            }

            @Override
            public Set<String> getProfilesToApply() {
                return this.getInstance().getProfilesToApply();
            }

            @Override
            public Set<String> getLibrariesToImport() {
                return this.getInstance().getLibrariesToImport();
            }

            @Override
            public Set<Type> getSpecificPrimitiveTypes(ResourceSet resourceSet) {
                return this.getInstance().getSpecificPrimitiveTypes(resourceSet);
            }

            @Override
            public Set<Collaboration> getSystemProtocols(ResourceSet resourceSet) {
                return this.getInstance().getSystemProtocols(resourceSet);
            }

            @Override
            public Collaboration getBaseProtocol(ResourceSet resourceSet) {
                return this.getInstance().getBaseProtocol(resourceSet);
            }

            @Override
            public Set<Class> getSystemClasses(ResourceSet resourceSet) {
                return this.getInstance().getSystemClasses(resourceSet);
            }
        }
    }
}

