/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.rsa.umlrt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PortRegistrationType implements Enumerator
{
    AUTOMATIC(0, "Automatic", "Automatic"),
    APPLICATION(1, "Application", "Application"),
    AUTOMATIC_LOCKED(2, "Automatic (locked)", "Automatic (locked)");

    public static final int AUTOMATIC_VALUE = 0;
    public static final int APPLICATION_VALUE = 1;
    public static final int AUTOMATIC_LOCKED_VALUE = 2;
    private static final PortRegistrationType[] VALUES_ARRAY;
    public static final List<PortRegistrationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PortRegistrationType[]{AUTOMATIC, APPLICATION, AUTOMATIC_LOCKED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PortRegistrationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortRegistrationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortRegistrationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortRegistrationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortRegistrationType get(int value) {
        switch (value) {
            case 0: {
                return AUTOMATIC;
            }
            case 1: {
                return APPLICATION;
            }
            case 2: {
                return AUTOMATIC_LOCKED;
            }
        }
        return null;
    }

    private PortRegistrationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

