/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.EObjectValueStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram.DiagramChangesHandler;

public abstract class AbstractCapsuleDiagramChangeHandler
implements DiagramChangesHandler {
    public static final String PAPYRUS_CSS_FORCE_VALUE_KEY = "PapyrusCSSForceValue";
    public static final String STEREOTYPE_COMMENT = "StereotypeComment";

    @Override
    public Set<EObject> getAutomaticallyCreatedShapes(Diff diff) {
        Shape changedShape;
        EObject containerShape;
        LinkedHashSet<EObject> shapes = new LinkedHashSet<EObject>();
        Object changedObject = MatchUtil.getValue((Diff)diff);
        if (changedObject instanceof Shape && (containerShape = (changedShape = (Shape)changedObject).eContainer()) instanceof View) {
            View containerView = (View)containerShape;
            EAnnotation annotation = containerView.getEAnnotation(PAPYRUS_CSS_FORCE_VALUE_KEY);
            if (annotation != null) {
                shapes.add((EObject)annotation);
            }
            Diagram diagram = changedShape.getDiagram();
            EObject elementContainer = changedShape.getElement().eContainer();
            for (Object child : diagram.getChildren()) {
                EObject eObject;
                if (!(child instanceof EObject) || !this.isShapeWithElement(eObject = (EObject)child, elementContainer) || !STEREOTYPE_COMMENT.equals(((Shape)eObject).getType())) continue;
                shapes.add(eObject);
            }
            for (Object edge : changedShape.getDiagram().getEdges()) {
                if (!(edge instanceof EObject) || !this.isStereotypeCommentEdge(edge, elementContainer)) continue;
                shapes.add((EObject)edge);
            }
        }
        return shapes;
    }

    protected boolean isStereotypeCommentEdge(Object edgeObject, EObject element) {
        if (!(edgeObject instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)edgeObject;
        View target = edge.getTarget();
        View source = edge.getSource();
        return source != null && element.equals(source.getElement()) && target != null && STEREOTYPE_COMMENT.contentEquals(target.getType());
    }

    protected boolean isShapeWithElement(EObject shapeObject, EObject element) {
        if (!(shapeObject instanceof Shape)) {
            return false;
        }
        Shape shape = (Shape)shapeObject;
        if (shape.getElement() != null) {
            return shape.getElement().equals(element);
        }
        EObjectValueStyle valueStyle = (EObjectValueStyle)shape.getStyle(NotationPackage.eINSTANCE.getEObjectValueStyle());
        return valueStyle != null && element.equals(valueStyle.getEObjectValue());
    }
}

