/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.AbstractEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateGraphicEditPartOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.IEditPartOperation;
import org.eclipse.gmf.runtime.notation.View;

public abstract class AbstractRTEditPartProvider
extends AbstractEditPartProvider {
    protected final String diagramType;
    protected final Map<String, Function<? super View, Class<?>>> nodeMap = new HashMap();
    protected final Map<String, Function<? super View, Class<?>>> edgeMap = new HashMap();

    protected AbstractRTEditPartProvider(String diagramType) {
        this.diagramType = diagramType;
    }

    protected static <F, T> Function<F, T> always(T value) {
        return __ -> value;
    }

    protected static <T> Function<View, T> ifContainerView(String type, T value) {
        return v -> v.eContainer() instanceof View && type.equals(((View)v.eContainer()).getType()) ? value : null;
    }

    @SafeVarargs
    protected static <T> Function<View, T> anyOf(Function<View, T> ... mappings) {
        return v -> Stream.of(mappings).map(m -> m.apply(v)).filter(Objects::nonNull).findAny().orElse(null);
    }

    public boolean provides(IOperation operation) {
        boolean result = false;
        EObject referenceElement = ((IEditPartOperation)operation).getView().getElement();
        if (operation instanceof CreateGraphicEditPartOperation && this.accept(referenceElement)) {
            result = this.provides((IEditPartOperation)operation, referenceElement);
        }
        return result;
    }

    protected boolean provides(IEditPartOperation createOperation, EObject element) {
        boolean result = false;
        String currentDiagramType = createOperation.getView().getDiagram().getType();
        if (this.diagramType != null && this.diagramType.equals(currentDiagramType)) {
            result = super.provides((IOperation)createOperation);
        }
        return result;
    }

    protected boolean accept(EObject element) {
        return true;
    }

    protected Class getNodeEditPartClass(View view) {
        return this.map(this.nodeMap, view);
    }

    private Class map(Map<String, Function<? super View, Class<?>>> table, View view) {
        Function<View, Class<?>> mapping = table.get(view.getType());
        return mapping == null ? null : mapping.apply((View)view);
    }

    protected Class getEdgeEditPartClass(View view) {
        return this.map(this.edgeMap, view);
    }
}

