/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.canonical;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.BasicDecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.common.canonical.DefaultUMLSemanticChildrenStrategy;
import org.eclipse.papyrusrt.umlrt.core.utils.Either;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.RTStateEditPartUtils;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnectionPoint;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTStateMachine;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTVertex;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTSwitch;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;

public class RTStateMachineSemanticChildrenStrategy
extends DefaultUMLSemanticChildrenStrategy {
    public List<? extends EObject> getCanonicalSemanticChildren(final EObject semanticFromEditPart, final View viewFromEditPart) {
        UMLRTNamedElement subject = this.resolveLocalSemanticElement(semanticFromEditPart, viewFromEditPart);
        Stream result = (Stream)new UMLRTSwitch<Stream<? extends Element>>(){

            public Stream<? extends Element> caseStateMachine(UMLRTStateMachine stateMachine) {
                return semanticFromEditPart instanceof Region ? RTStateMachineSemanticChildrenStrategy.this.toUML(stateMachine.getVertices().stream()) : UMLRTExtensionUtil.getUMLRTContents((EObject)stateMachine.toUML(), (EStructuralFeature)UMLPackage.Literals.STATE_MACHINE__REGION, (EStructuralFeature[])new EStructuralFeature[0]).stream();
            }

            public Stream<? extends Element> caseState(UMLRTState state) {
                Stream<Object> result = Stream.empty();
                Predicate<UMLRTTransition> isInternal = UMLRTTransition::isInternal;
                if (state.isComposite() && RTStateEditPartUtils.isInternalTransitionCompartment(viewFromEditPart)) {
                    result = state.getSubtransitions().stream().filter(isInternal).map(UMLRTTransition::toUML);
                } else if (semanticFromEditPart instanceof Region) {
                    result = RTStateMachineSemanticChildrenStrategy.this.toUML(state.getSubvertices().stream());
                } else {
                    if (!(viewFromEditPart instanceof BasicDecorationNode)) {
                        result = RTStateMachineSemanticChildrenStrategy.this.toUML(state.getConnectionPoints());
                    }
                    if (!RTStateMachineSemanticChildrenStrategy.this.isStateInRegion(viewFromEditPart)) {
                        result = Stream.concat(result, UMLRTExtensionUtil.getUMLRTContents((EObject)state.toUML(), (EStructuralFeature)UMLPackage.Literals.STATE__REGION, (EStructuralFeature[])new EStructuralFeature[0]).stream());
                    }
                }
                return result;
            }
        }.doSwitch((Object)subject);
        return result == null ? null : result.map(UMLRTExtensionUtil::getRootDefinition).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected UMLRTNamedElement resolveLocalSemanticElement(EObject semanticFromEditPart, View viewFromEditPart) {
        StateMachine stateMachine = this.getContextualStateMachine(viewFromEditPart);
        UMLRTNamedElement result = semanticFromEditPart instanceof Region ? this.resolveRedefinition(stateMachine, (UMLRTNamedElement)UMLRTFactory.create((EObject)((Region)semanticFromEditPart).getOwner())) : this.resolveRedefinition(stateMachine, (UMLRTNamedElement)UMLRTFactory.create((EObject)semanticFromEditPart));
        return result;
    }

    StateMachine getContextualStateMachine(View view) {
        return Optional.ofNullable(EditPartInheritanceUtils.getContextStateMachine((View)view)).map(UMLRTStateMachine::toUML).orElse(null);
    }

    StateMachine getContextualStateMachine(IGraphicalEditPart editPart) {
        return this.getContextualStateMachine(editPart.getNotationView());
    }

    <T extends UMLRTNamedElement> T resolveRedefinition(StateMachine context, T facade) {
        Object result = facade;
        if (facade != null && !(facade instanceof UMLRTStateMachine)) {
            UMLRTState compositeState = null;
            if (facade instanceof UMLRTVertex) {
                compositeState = ((UMLRTVertex)facade).getState();
            } else if (facade instanceof UMLRTTransition) {
                compositeState = ((UMLRTTransition)facade).getState();
            }
            if (compositeState != null) {
                compositeState = this.resolveRedefinition(context, compositeState);
                result = compositeState.getRedefinitionOf(facade);
            } else {
                UMLRTStateMachine stateMachine = UMLRTStateMachine.getInstance((StateMachine)context);
                result = stateMachine.getRedefinitionOf(facade);
            }
        }
        return result;
    }

    Stream<Element> toUML(List<? extends FacadeObject> facades) {
        return facades.stream().map(FacadeObject::toUML);
    }

    Stream<Element> toUML(Stream<? extends FacadeObject> facades) {
        return facades.map(FacadeObject::toUML);
    }

    public Collection<? extends EObject> getCanonicalDependents(EObject semanticFromEditPart, View viewFromEditPart) {
        UMLRTNamedElement subject = this.resolveLocalSemanticElement(semanticFromEditPart, viewFromEditPart);
        if (subject instanceof UMLRTState && ((UMLRTState)subject).isComposite() && RTStateEditPartUtils.isInternalTransitionCompartment(viewFromEditPart)) {
            return UMLRTExtensionUtil.getUMLRTContents((EObject)subject.toUML(), (EStructuralFeature)UMLPackage.Literals.STATE__REGION, (EStructuralFeature[])new EStructuralFeature[0]);
        }
        if (subject instanceof UMLRTVertex && RTStateEditPartUtils.isInRegionCompartment(viewFromEditPart)) {
            return Collections.singletonList(subject.toUML().getOwner());
        }
        if (subject instanceof UMLRTConnectionPoint) {
            UMLRTConnectionPoint connPt = (UMLRTConnectionPoint)subject;
            UMLRTState onState = connPt.getState();
            Diagram diagram = viewFromEditPart.getDiagram();
            State state = (State)TypeUtils.as((Object)EditPartInheritanceUtils.resolveSemanticElement((View)diagram), State.class);
            UMLRTState stateContext = state == null ? null : UMLRTState.getInstance((State)state);
            Region region = stateContext != null && onState.redefines((UMLRTNamedElement)stateContext) ? onState.toRegion() : (Region)Either.or((Object)onState.getState(), (Object)onState.getStateMachine()).map(UMLRTState::toRegion, UMLRTStateMachine::toRegion).getEither(Region.class);
            return region == null ? Collections.emptyList() : Collections.singletonList(region);
        }
        return super.getCanonicalDependents(semanticFromEditPart, viewFromEditPart);
    }

    public List<? extends EObject> getCanonicalSemanticConnections(EObject semanticFromEditPart, View viewFromEditPart) {
        List result = null;
        UMLRTNamedElement element = this.resolveLocalSemanticElement(semanticFromEditPart, viewFromEditPart);
        if (element instanceof UMLRTVertex) {
            UMLRTVertex vertex = (UMLRTVertex)element;
            UniqueEList.FastCompare transitions = new UniqueEList.FastCompare((Collection)vertex.getIncomings());
            transitions.addAll(vertex.getOutgoings());
            Predicate<UMLRTTransition> internal = UMLRTTransition::isInternal;
            Either context = EditPartInheritanceUtils.getStateMachineContext((View)viewFromEditPart);
            Region represented = (Region)context.map(UMLRTState::toRegion, UMLRTStateMachine::toRegion).getEither(Region.class);
            Predicate<Transition> inRepresentedRegion = transition -> transition.getContainer() == represented;
            result = transitions.stream().filter(internal.negate()).map(UMLRTTransition::toUML).filter(inRepresentedRegion).map(UMLRTExtensionUtil::getRootDefinition).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        return result;
    }

    protected boolean isStateInRegion(View notationView) {
        boolean result = false;
        while (notationView instanceof BasicDecorationNode && notationView.eContainer() instanceof View) {
            notationView = (View)notationView.eContainer();
        }
        if ("State_Shape".equals(notationView.getType())) {
            result = notationView.eContainer() instanceof BasicDecorationNode;
        }
        return result;
    }

    public IGraphicalEditPart resolveSourceEditPart(EObject connectionElement, IGraphicalEditPart context) {
        if (connectionElement instanceof Transition) {
            connectionElement = this.resolveTransition((Transition)connectionElement, context);
        }
        return super.resolveSourceEditPart(connectionElement, context);
    }

    public IGraphicalEditPart resolveTargetEditPart(EObject connectionElement, IGraphicalEditPart context) {
        if (connectionElement instanceof Transition) {
            connectionElement = this.resolveTransition((Transition)connectionElement, context);
        }
        return super.resolveTargetEditPart(connectionElement, context);
    }

    private Transition resolveTransition(Transition umlTransition, IGraphicalEditPart context) {
        Transition result = umlTransition;
        UMLRTTransition transition = UMLRTTransition.getInstance((Transition)umlTransition);
        StateMachine stateMachine = this.getContextualStateMachine(context);
        if (transition != null && stateMachine != null) {
            result = this.resolveRedefinition(stateMachine, transition).toUML();
        }
        return result;
    }

    public Object getSource(EObject connectionElement) {
        Object result = super.getSource(connectionElement);
        if (connectionElement instanceof Transition) {
            Transition transition = (Transition)connectionElement;
            result = transition.getSource();
        }
        return result;
    }

    public Object getTarget(EObject connectionElement) {
        Object result = super.getTarget(connectionElement);
        if (connectionElement instanceof Transition) {
            Transition transition = (Transition)connectionElement;
            result = transition.getTarget();
        }
        return result;
    }
}

