/*******************************************************************************
 * Copyright (c) 2017 Zeligsoft (2009) Limited and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Young-Soo Roh - Initial API and implementation
 *******************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList.Expression;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrusrt.umlrt.core.utils.StateMachineUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;

/**
 * Code snippet tab for transition guard.
 * 
 * @author ysroh
 *
 */
public class TransitionGuardTab extends AbstractCodeSnippetTab {

	/**
	 * 
	 * Constructor.
	 *
	 */
	public TransitionGuardTab() {
	}

	@Override
	public String getTitle() {
		return "Guard";
	}

	@Override
	public Image getImage() {

		if (shouldShowThisTab(input)) {
			Transition transition = (Transition) input;
			Constraint guard = transition.getGuard();
			if (guard != null) {
				return labelProvider.getImage(guard);
			}
		}
		return org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.Activator
				.getImage(org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.Activator.IMG_OBJ16_GUARD);
	}

	@Override
	public boolean shouldShowThisTab(EObject context) {
		if (context instanceof Transition) {
			Transition transition = (Transition) context;
			StateMachine sm = transition.containingStateMachine();
			return StateMachineUtils.isRTStateMachine(sm);
		}
		return false;
	}

	@Override
	protected IObservable getFeatureObservable() {
		UMLModelElement modelElement = new UMLModelElement(input);
		return modelElement.doGetObservable("guard");
	}

	@Override
	protected ExpressionList getExpressionObservableList() {
		Transition transition = (Transition) input;
		Constraint guard = transition.getGuard();
		if (guard != null) {
			return getExpressionList(guard.getSpecification());
		}

		return null;
	}

	@Override
	protected void saveInitialExpression(Expression ex) {
		UMLRTTransition transition = UMLRTFactory.createTransition((Transition) input);
		transition.createGuard(ex.getLanguage(), ex.getBody());
	}
}
