/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.RTGuard;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.UMLRTStateMachinesPackage;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTGuard;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocolMessage;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTrigger;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeType;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTNamedElementImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLRTTriggerImpl
extends UMLRTNamedElementImpl
implements UMLRTTrigger {
    protected static final boolean RECEIVE_ANY_MESSAGE_EDEFAULT = false;
    static final FacadeType<Trigger, EObject, UMLRTTriggerImpl> TYPE = new FacadeType(UMLRTTriggerImpl.class, UMLPackage.Literals.TRIGGER, null, UMLRTTriggerImpl::getInstance, trigger -> (UMLRTTriggerImpl)trigger.getRedefinedTrigger(), UMLRTTriggerImpl::new);

    protected UMLRTTriggerImpl() {
    }

    public static UMLRTTriggerImpl getInstance(Trigger trigger) {
        return UMLRTTriggerImpl.getTransition(trigger).map(__ -> UMLRTTriggerImpl.getFacade(trigger, TYPE)).orElse(null);
    }

    static Optional<Transition> getTransition(Trigger trigger) {
        return Optional.ofNullable(trigger).map(NamedElement::getNamespace).filter(Transition.class::isInstance).map(Transition.class::cast);
    }

    @Override
    protected EClass eStaticClass() {
        return UMLRTUMLRTPackage.Literals.TRIGGER;
    }

    @Override
    public UMLRTNamedElement getRedefinedElement() {
        UMLRTTrigger redefinedTrigger = this.getRedefinedTrigger();
        if (redefinedTrigger != null) {
            return redefinedTrigger;
        }
        return super.getRedefinedElement();
    }

    @Override
    public UMLRTNamedElement getRedefinitionContext() {
        UMLRTTransition transition = this.getTransition();
        if (transition != null) {
            return transition;
        }
        return super.getRedefinitionContext();
    }

    @Override
    public UMLRTProtocolMessage getProtocolMessage() {
        UMLRTProtocolMessage result = null;
        Event event = this.toUML().getEvent();
        if (event instanceof CallEvent) {
            CallEvent callEvent = (CallEvent)event;
            result = callEvent.getOperation() != null ? UMLRTProtocolMessage.getInstance(callEvent.getOperation()) : null;
        }
        return result;
    }

    @Override
    public void setProtocolMessage(UMLRTProtocolMessage newProtocolMessage) {
        this.toUML().setEvent((Event)(newProtocolMessage == null ? null : newProtocolMessage.toReceiveEvent()));
    }

    @Override
    public List<UMLRTPort> getPorts() {
        Object result;
        CacheAdapter cache = this.getCacheAdapter();
        if (cache == null) {
            result = new PortList(this, 15, (EList<Port>)this.toUML().getPorts());
        } else {
            Object ports = (List)cache.get((EObject)this, (Object)UMLRTUMLRTPackage.Literals.TRIGGER__PORT);
            if (ports == null) {
                ports = new PortList(this, 15, (EList<Port>)this.toUML().getPorts());
                cache.put((EObject)this, (Object)UMLRTUMLRTPackage.Literals.TRIGGER__PORT, ports);
            }
            result = ports;
        }
        return result;
    }

    @Override
    public UMLRTPort getPort(String name) {
        return this.getPort(name, false);
    }

    @Override
    public UMLRTPort getPort(String name, boolean ignoreCase) {
        for (UMLRTPort port : this.getPorts()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(port.getName()) : !name.equals(port.getName()))) continue;
            return port;
        }
        return null;
    }

    @Override
    public UMLRTPort getPort() throws IllegalStateException {
        if (this.hasMultiplePorts()) {
            throw new IllegalStateException("trigger has two or more ports");
        }
        List<UMLRTPort> ports = this.getPorts();
        return ports.isEmpty() ? null : ports.get(0);
    }

    @Override
    public void setPort(UMLRTPort port) {
        EList ports = (EList)this.getPorts();
        if (port == null) {
            if (!ports.isEmpty()) {
                ports.clear();
            }
        } else if (ports.size() != 1 || ports.get(0) != port) {
            ECollections.setEList((EList)ports, Collections.singletonList(port));
        }
    }

    @Override
    public boolean hasMultiplePorts() {
        return this.getPorts().size() > 1;
    }

    @Override
    public Stream<? extends UMLRTTrigger> allRedefinitions() {
        Predicate<UMLRTNamedElement> excluded = UMLRTNamedElement::isExcluded;
        UMLRTNamedElement context = this.getRedefinitionContext();
        return context == null ? Stream.of(this) : context.allRedefinitions().map(c -> c.getRedefinitionOf(this)).filter(Objects::nonNull).filter(excluded.negate());
    }

    Optional<Transition> transition() {
        return UMLRTTriggerImpl.getTransition(this.toUML());
    }

    @Override
    public UMLRTGuard getGuard() {
        return this.getGuard(UMLRTGuard::getInstance);
    }

    protected <T> T getGuard(Function<? super Constraint, T> transformation) {
        UMLRTTransition transition = this.getTransition();
        return transition == null ? null : UMLRTExtensionUtil.getUMLRTContents((EObject)transition.toUML(), (EStructuralFeature)UMLPackage.Literals.NAMESPACE__OWNED_RULE, new EStructuralFeature[0]).stream().filter(this::isConstrainedBy).filter(guard -> UMLUtil.getStereotypeApplication((Element)guard, RTGuard.class) != null).map(transformation).filter(Objects::nonNull).findAny().orElse(null);
    }

    @Override
    public void setGuard(UMLRTGuard newGuard) {
        UMLRTGuard oldGuard = this.getGuard();
        if (newGuard != oldGuard) {
            Constraint uml;
            if (oldGuard != null) {
                uml = oldGuard.toUML();
                uml.getConstrainedElements().remove((Object)this.toUML());
                uml.setContext(null);
            }
            if (newGuard != null) {
                UMLRTTrigger trigger;
                UMLRTTransition transition;
                uml = newGuard.toUML();
                uml.setContext((Namespace)this.getTransition().toUML());
                RTGuard stereo = (RTGuard)UMLUtil.getStereotypeApplication((Element)uml, RTGuard.class);
                if (stereo == null) {
                    UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)uml).applyStereotype((Element)uml, UMLRTStateMachinesPackage.Literals.RT_GUARD);
                }
                if ((transition = newGuard.getTransition()) != null) {
                    transition.setGuard(null);
                }
                if ((trigger = newGuard.getTrigger()) != null) {
                    uml.getConstrainedElements().remove((Object)trigger.toUML());
                }
                uml.getConstrainedElements().add(0, (Object)this.toUML());
            }
        }
    }

    protected boolean isConstrainedBy(Constraint constraint) {
        InternalUMLRTElement trigger;
        EList constrained = constraint.getConstrainedElements();
        return constrained.contains(trigger = (InternalUMLRTElement)this.toUML()) || trigger.rtIsVirtual() && constrained.contains(trigger.rtGetRootDefinition());
    }

    @Override
    public UMLRTTrigger getRedefinedTrigger() {
        UMLRTTrigger result = null;
        if (this.toUML() instanceof InternalUMLRTElement) {
            Trigger superTrigger = (Trigger)((InternalUMLRTElement)this.toUML()).rtGetRedefinedElement();
            result = UMLRTTrigger.getInstance(superTrigger);
        }
        return result;
    }

    @Override
    public boolean isReceiveAnyMessage() {
        return this.toUML().getEvent() instanceof AnyReceiveEvent;
    }

    @Override
    public void setReceiveAnyMessage(boolean newReceiveAnyMessage) {
        if (newReceiveAnyMessage == this.isReceiveAnyMessage()) {
            return;
        }
        UMLRTProtocol protocol = null;
        UMLRTPort port = this.getPort();
        if (port != null) {
            protocol = port.getType();
        } else {
            UMLRTProtocolMessage message = this.getProtocolMessage();
            if (message != null) {
                protocol = message.getProtocol();
            }
        }
        if (protocol == null) {
            throw new IllegalStateException("trigger has neither port nor message from which to infer the protocol");
        }
        if (newReceiveAnyMessage) {
            this.toUML().setEvent((Event)protocol.getAnyReceiveEvent());
        } else {
            this.toUML().setEvent((Event)protocol.getMessages().stream().filter(m -> m.getKind() != RTMessageKind.OUT).findFirst().orElseThrow(() -> new IllegalStateException("protocol has only outbound messages")).toReceiveEvent());
        }
    }

    @Override
    public UMLRTTransition getTransition() {
        return this.transition().map(UMLRTTransition::getInstance).orElse(null);
    }

    @Override
    public Trigger toUML() {
        return (Trigger)super.toUML();
    }

    @Override
    public UMLRTGuard createGuard(String language, String body) {
        return this.transition().map(t -> t.createOwnedRule(null)).map(guard -> {
            this.applyStereotype((Element)guard, RTGuard.class);
            OpaqueExpression expr = (OpaqueExpression)guard.createSpecification(null, null, UMLPackage.Literals.OPAQUE_EXPRESSION);
            expr.getBodies().add((Object)body);
            if (language != null) {
                expr.getLanguages().add((Object)language);
            }
            guard.getConstrainedElements().add((Object)this.toUML());
            return guard;
        }).map(UMLRTGuard::getInstance).orElse(null);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 14: {
                return this.getProtocolMessage();
            }
            case 15: {
                return this.getPorts();
            }
            case 16: {
                return this.getGuard();
            }
            case 17: {
                return this.getRedefinedTrigger();
            }
            case 18: {
                return this.isReceiveAnyMessage();
            }
            case 19: {
                return this.getTransition();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    protected Object facadeGetAll(int referenceID) {
        return this.eGet(referenceID, true, true);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 14: {
                this.setProtocolMessage((UMLRTProtocolMessage)newValue);
                return;
            }
            case 15: {
                this.getPorts().clear();
                this.getPorts().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.setGuard((UMLRTGuard)newValue);
                return;
            }
            case 18: {
                this.setReceiveAnyMessage((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 14: {
                this.setProtocolMessage(null);
                return;
            }
            case 15: {
                this.getPorts().clear();
                return;
            }
            case 16: {
                this.setGuard(null);
                return;
            }
            case 18: {
                this.setReceiveAnyMessage(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.isSetRedefinedElement();
            }
            case 9: {
                return this.isSetRedefinitionContext();
            }
            case 14: {
                return this.getProtocolMessage() != null;
            }
            case 15: {
                return !this.getPorts().isEmpty();
            }
            case 16: {
                return this.getGuard() != null;
            }
            case 17: {
                return this.getRedefinedTrigger() != null;
            }
            case 18: {
                return this.isReceiveAnyMessage();
            }
            case 19: {
                return this.getTransition() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean isSetRedefinedElement() {
        return super.isSetRedefinedElement() || this.eIsSet(17);
    }

    @Override
    public boolean isSetRedefinitionContext() {
        return super.isSetRedefinitionContext() || this.eIsSet(19);
    }

    @Override
    public UMLRTInheritanceKind getInheritanceKind() {
        Constraint guard;
        UMLRTInheritanceKind result = super.getInheritanceKind();
        if (result == UMLRTInheritanceKind.INHERITED && (guard = (Constraint)this.getGuard(Function.identity())) != null && !UMLRTExtensionUtil.isVirtualElement((Element)guard)) {
            result = UMLRTInheritanceKind.REDEFINED;
        }
        return result;
    }

    protected static class PortList
    extends DelegatingEcoreEList<UMLRTPort> {
        private static final long serialVersionUID = 1L;
        protected int featureID;
        protected EList<UMLRTPort> delegateList;
        protected EList<Port> umlPorts;

        public PortList(InternalEObject owner, int featureID, EList<Port> umlPorts) {
            super(owner);
            this.featureID = featureID;
            this.umlPorts = umlPorts;
            this.delegateList = (EList)umlPorts.stream().map(UMLRTPort::getInstance).filter(Objects::nonNull).collect(() -> new UniqueEList.FastCompare(umlPorts.size()), List::add, List::addAll);
        }

        public int getFeatureID() {
            return this.featureID;
        }

        protected List<UMLRTPort> delegateList() {
            return this.delegateList;
        }

        protected void delegateAdd(int index, UMLRTPort port) {
            int delegateIndex = this.delegateList.indexOf((Object)port);
            if (delegateIndex >= 0) {
                if (index != delegateIndex) {
                    this.delegateList.move(index, (Object)port);
                }
            } else if (index < this.delegateList.size()) {
                this.delegateList.add(index, (Object)port);
            } else {
                this.delegateList.add((Object)port);
            }
        }

        protected void didAdd(int index, UMLRTPort newPort) {
            super.didAdd(index, (Object)newPort);
            if (index > this.umlPorts.size()) {
                throw new IllegalStateException("port list is stale");
            }
            this.umlPorts.add(index, (Object)newPort.toUML());
        }

        protected void didRemove(int index, UMLRTPort oldPort) {
            super.didRemove(index, (Object)oldPort);
            if (index >= this.umlPorts.size() || this.umlPorts.get(index) != oldPort.toUML()) {
                throw new IllegalStateException("port list is stale");
            }
            this.umlPorts.remove(index);
        }

        protected void didClear(int size, Object[] oldObjects) {
            if (size != this.umlPorts.size()) {
                throw new IllegalStateException("port list is stale");
            }
            this.umlPorts.clear();
        }

        protected void didSet(int index, UMLRTPort newPort, UMLRTPort oldPort) {
            super.didSet(index, (Object)newPort, (Object)oldPort);
            if (index >= this.umlPorts.size() || this.umlPorts.get(index) != oldPort.toUML()) {
                throw new IllegalStateException("port list is stale");
            }
            this.umlPorts.set(index, (Object)newPort.toUML());
        }

        protected void didMove(int index, UMLRTPort movedPort, int oldIndex) {
            super.didMove(index, (Object)movedPort, oldIndex);
            if (index >= this.umlPorts.size() || oldIndex >= this.umlPorts.size() || this.umlPorts.get(oldIndex) != movedPort.toUML()) {
                throw new IllegalStateException("port list is stale");
            }
            this.umlPorts.move(index, oldIndex);
        }
    }
}

