/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.util;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationWrapper;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.operations.RedefinableElementRTOperations;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class NotificationForwarder
extends AdapterImpl {
    private final InternalUMLRTElement owner;
    private final EReference redefinedElementReference;
    private final Collection<? extends EStructuralFeature> inheritedFeatures;

    public NotificationForwarder(InternalUMLRTElement owner, EReference redefinedElementReference, Collection<? extends EStructuralFeature> inheritedFeatures) {
        this(owner, redefinedElementReference, inheritedFeatures, true);
    }

    NotificationForwarder(InternalUMLRTElement owner, EReference redefinedElementReference, Collection<? extends EStructuralFeature> inheritedFeatures, boolean init) {
        this.owner = owner;
        this.redefinedElementReference = redefinedElementReference;
        this.inheritedFeatures = inheritedFeatures;
        if (init) {
            this.initRedefinedElement();
        }
    }

    void initRedefinedElement() {
        InternalUMLRTElement redefined = this.getRedefinedElement(this.owner);
        if (redefined != this.target) {
            if (this.target != null) {
                this.target.eAdapters().remove((Object)this);
            }
            if (redefined != null) {
                redefined.eAdapters().add((Object)this);
            }
        }
    }

    final InternalUMLRTElement owner() {
        return this.owner;
    }

    <T extends EObject & InternalUMLRTElement> T getRedefinedElement(T element) {
        EObject result = null;
        if (this.redefinedElementReference == null) {
            result = (EObject)((InternalUMLRTElement)element).rtGetRedefinedElement();
        } else {
            EList redefinedElements = (EList)element.eGet((EStructuralFeature)this.redefinedElementReference);
            if (!redefinedElements.isEmpty()) {
                result = (EObject)redefinedElements.get(0);
            }
        }
        return (T)result;
    }

    final EReference redefinedElementReference() {
        return this.redefinedElementReference;
    }

    public void setTarget(Notifier newTarget) {
        if (newTarget != this.owner) {
            super.setTarget(newTarget);
        }
    }

    public void unsetTarget(Notifier oldTarget) {
        if (oldTarget == this.owner && this.getTarget() != null) {
            this.getTarget().eAdapters().remove((Object)this);
        }
        super.unsetTarget(oldTarget);
    }

    public boolean isAdapterForType(Object type) {
        return type == NotificationForwarder.class;
    }

    public void notifyChanged(Notification msg) {
        if (msg.isTouch()) {
            return;
        }
        this.handleNotification(msg);
    }

    protected void handleNotification(Notification msg) {
        EStructuralFeature feature;
        if (msg.getNotifier() == this.owner) {
            if (msg.getFeature() == this.redefinedElementReference) {
                this.initRedefinedElement();
            }
        } else if (this.shouldForward() && this.inheritedFeatures.contains(msg.getFeature()) && !this.owner.rtIsSet(feature = (EStructuralFeature)msg.getFeature())) {
            this.forward(msg);
        }
    }

    public static void forward(InternalEObject forwarder, Notification msg) {
        forwarder.eNotify(NotificationForwarder.wrap(forwarder, msg));
    }

    public static Notification wrap(InternalEObject forwarder, Notification msg) {
        Function<? super EObject, ? extends EObject> inheritanceResolver = NotificationForwarder.getInheritanceResolver(forwarder, msg);
        NotificationWrapper result = inheritanceResolver == null ? new NotificationWrapper(forwarder, msg){

            public int getFeatureID(Class<?> expectedClass) {
                if (this.notification.getNotifier() == null) {
                    EStructuralFeature feature = (EStructuralFeature)this.notification.getFeature();
                    return ((InternalEObject)this.notifier).eDerivedStructuralFeatureID(feature.getFeatureID(), feature.getContainerClass());
                }
                return super.getFeatureID(expectedClass);
            }
        } : new NotificationWrapper(forwarder, msg, inheritanceResolver){
            private final Object oldValue;
            private final Object newValue;
            {
                this.oldValue = RedefinableElementRTOperations.resolveInheritedReference(super.getOldValue(), function);
                this.newValue = RedefinableElementRTOperations.resolveInheritedReference(super.getNewValue(), function);
            }

            public Object getNewValue() {
                return this.newValue;
            }

            public Object getOldValue() {
                return this.oldValue;
            }
        };
        return result;
    }

    private static Function<? super EObject, ? extends EObject> getInheritanceResolver(InternalEObject forwarder, Notification msg) {
        EReference reference;
        Function<? super EObject, ? extends EObject> result = null;
        if (forwarder instanceof InternalUMLRTElement && msg.getFeature() instanceof EReference && !(reference = (EReference)msg.getFeature()).isContainment() && !reference.isContainer()) {
            result = ((InternalUMLRTElement)forwarder).rtGetInheritanceResolver(reference);
        }
        return result;
    }

    void forward(Notification msg) {
        NotificationForwarder.forward(this.owner, msg);
    }

    final boolean shouldForward() {
        return this.owner.eNotificationRequired();
    }

    static boolean isForwarded(Notification notification) {
        return notification instanceof NotificationWrapper && notification.getClass().getEnclosingClass() != null && NotificationForwarder.class.isAssignableFrom(notification.getClass().getEnclosingClass());
    }

    static NotificationForwarder getInstance(InternalUMLRTElement element) {
        NotificationForwarder result = null;
        for (Adapter next : element.eAdapters()) {
            NotificationForwarder forwarder;
            if (!next.isAdapterForType(NotificationForwarder.class) || (forwarder = (NotificationForwarder)next).owner() != element) continue;
            result = forwarder;
            break;
        }
        return result;
    }

    public static boolean unadapt(InternalUMLRTElement element) {
        return element.eAdapters().removeIf(a -> a.isAdapterForType(NotificationForwarder.class) && ((NotificationForwarder)((Object)a)).owner() == element);
    }

    public static boolean adapt(InternalUMLRTElement element, Supplier<? extends NotificationForwarder> forwarderSupplier) {
        boolean result;
        boolean bl = result = NotificationForwarder.getInstance(element) == null;
        if (result) {
            element.eAdapters().add((Object)((Adapter)forwarderSupplier.get()));
        }
        return result;
    }

    public static void initialize(Object object) {
        InternalUMLRTElement element;
        NotificationForwarder forwarder;
        if (object instanceof InternalUMLRTElement && (forwarder = NotificationForwarder.getInstance(element = (InternalUMLRTElement)object)) != null) {
            forwarder.initRedefinedElement();
        }
    }

    public static class FromStereotype
    extends NotificationForwarder {
        private final EReference baseElementReference;

        public FromStereotype(InternalUMLRTElement owner, EReference baseElementReference, EReference redefinedElementReference, Collection<? extends EStructuralFeature> inheritedFeatures) {
            super(owner, redefinedElementReference, inheritedFeatures, false);
            this.baseElementReference = baseElementReference;
            this.initRedefinedElement();
        }

        @Override
        <T extends EObject & InternalUMLRTElement> T getRedefinedElement(T element) {
            EObject result = null;
            if (element instanceof Element) {
                result = super.getRedefinedElement(element);
            } else {
                Element baseElement = (Element)element.eGet((EStructuralFeature)this.baseElementReference);
                if (baseElement instanceof InternalUMLRTElement && (baseElement = (Element)this.getRedefinedElement((InternalUMLRTElement)baseElement)) != null) {
                    EObject redefined;
                    Class stereotype = this.owner().eClass().getInstanceClass();
                    result = redefined = UMLUtil.getStereotypeApplication((Element)baseElement, (Class)stereotype);
                }
            }
            return (T)result;
        }

        @Override
        public void setTarget(Notifier newTarget) {
            if (!(newTarget instanceof Element)) {
                super.setTarget(newTarget);
            }
        }

        @Override
        protected void handleNotification(Notification msg) {
            if (msg.getFeature() == this.baseElementReference) {
                switch (msg.getEventType()) {
                    case 1: 
                    case 2: {
                        if (msg.getOldValue() != null) {
                            ((EObject)msg.getOldValue()).eAdapters().remove((Object)this);
                        }
                        if (msg.getNewValue() != null) {
                            ((EObject)msg.getNewValue()).eAdapters().add((Object)this);
                        }
                        this.initRedefinedElement();
                    }
                }
            } else if (msg.getFeature() == this.redefinedElementReference()) {
                this.initRedefinedElement();
            } else {
                super.handleNotification(msg);
            }
        }
    }
}

