/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;

public class Pair<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private E first;
    private E second;
    private transient int modificationCount;

    public Pair(E first, E second) {
        this.first = Objects.requireNonNull(first, "first");
        this.second = Objects.requireNonNull(second, "first");
    }

    public static <E, T extends E, U extends E> Pair<E> of(T first, U second) {
        return new Pair<T>(first, second);
    }

    public E setFirst(E newFirst) {
        E result = this.first;
        this.first = Objects.requireNonNull(newFirst, "newFirst");
        ++this.modificationCount;
        return result;
    }

    public E setSecond(E newSecond) {
        E result = this.second;
        this.second = Objects.requireNonNull(newSecond, "newSecond");
        ++this.modificationCount;
        return result;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    @Override
    public boolean equals(Object obj) {
        List other;
        boolean result = obj == null ? false : (obj == this ? true : (obj instanceof List ? (other = (List)obj).size() == 2 && this.first.equals(other.get(0)) && this.second.equals(other.get(1)) : false));
        return result;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.first.equals(o) || this.second.equals(o);
    }

    void checkModificationCount(int expected) {
        if (this.modificationCount != expected) {
            throw new ConcurrentModificationException();
        }
    }

    int getModificationCount() {
        return this.modificationCount;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this, this.modificationCount, this::checkModificationCount);
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.first, this.second};
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length >= 2) {
            a[0] = this.first;
            a[1] = this.second;
            if (a.length > 2) {
                a[2] = null;
            }
        } else {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), 2);
            this.toArray(a);
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object next : c) {
            if (this.contains(next)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    @Override
    public E get(int index) {
        switch (index) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    public E set(int index, E element) {
        E result;
        switch (index) {
            case 0: {
                result = this.first;
                this.first = element;
                break;
            }
            case 1: {
                result = this.second;
                this.second = element;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
        }
        return result;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public int indexOf(Object o) {
        return this.first.equals(o) ? 0 : (this.second.equals(o) ? 1 : -1);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.second.equals(o) ? 1 : (this.first.equals(o) ? 0 : -1);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListItr(this, index, this::checkModificationCount, this::getModificationCount);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > 2) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex);
        }
        if (toIndex < fromIndex || toIndex > 2) {
            throw new IndexOutOfBoundsException("toIndex: " + toIndex);
        }
        return fromIndex == toIndex ? Collections.emptyList() : (toIndex - fromIndex == 2 ? this : new SingletonSublist(this, fromIndex, this::checkModificationCount, this::getModificationCount));
    }

    private static class Itr<E>
    implements Iterator<E> {
        private final List<E> list;
        private final int expectedModCount;
        private final IntConsumer checkModificationCount;
        private int cursor;

        Itr(List<E> list, int expectedModCount, IntConsumer checkModificationCount) {
            this.list = list;
            this.expectedModCount = expectedModCount;
            this.checkModificationCount = checkModificationCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < 2;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.checkModificationCount.accept(this.expectedModCount);
            E result = this.list.get(this.cursor);
            ++this.cursor;
            return result;
        }
    }

    private static class ListItr<E>
    implements ListIterator<E> {
        private final List<E> list;
        private final IntConsumer checkModificationCount;
        private final IntSupplier getModificationCount;
        private int expectedModCount;
        private int cursor;
        private boolean forward;
        private E lastReturned;

        ListItr(List<E> list, int index, IntConsumer checkModificationCount, IntSupplier getModificationCount) {
            if (index < 0 || index > list.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            this.list = list;
            this.cursor = index;
            this.checkModificationCount = checkModificationCount;
            this.getModificationCount = getModificationCount;
            this.expectedModCount = getModificationCount.getAsInt();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.list.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.checkModificationCount.accept(this.expectedModCount);
            E result = this.list.get(this.cursor);
            ++this.cursor;
            this.lastReturned = result;
            this.forward = true;
            return result;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.checkModificationCount.accept(this.expectedModCount);
            --this.cursor;
            E result = this.list.get(this.cursor);
            this.lastReturned = result;
            this.forward = false;
            return result;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void set(E e) {
            if (this.lastReturned == null) {
                throw new IllegalStateException("no next nor previous returned");
            }
            int size = this.list.size();
            if (this.cursor == 0) {
                if (this.forward) {
                    throw new IllegalStateException("no next nor previous returned");
                }
                this.list.set(this.cursor, e);
            } else if (this.cursor < size) {
                if (this.forward) {
                    this.list.set(this.cursor - 1, e);
                } else {
                    this.list.set(this.cursor, e);
                }
            } else {
                if (this.cursor != size) throw new IllegalStateException("invalid cursor: " + this.cursor);
                if (!this.forward) throw new IllegalStateException("no next nor previous returned");
                this.list.set(this.cursor - 1, e);
            }
            this.expectedModCount = this.getModificationCount.getAsInt();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException("add");
        }
    }

    private static class SingletonSublist<E>
    implements List<E> {
        private final List<E> list;
        private final IntConsumer checkModificationCount;
        private final IntSupplier getModificationCount;
        private final int index;

        SingletonSublist(List<E> list, int index, IntConsumer checkModificationCount, IntSupplier getModificationCount) {
            this.list = list;
            this.index = index;
            this.checkModificationCount = checkModificationCount;
            this.getModificationCount = getModificationCount;
        }

        @Override
        public int hashCode() {
            return this.get(0).hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            List other;
            boolean result = obj == null ? false : (obj == this ? true : (obj instanceof List ? (other = (List)obj).size() == 1 && this.get(0).equals(other.get(0)) : false));
            return result;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.get(0).equals(o);
        }

        @Override
        public Iterator<E> iterator() {
            return new Itr(this, this.getModificationCount.getAsInt(), this.checkModificationCount);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.get(0)};
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length >= 1) {
                a[0] = this.get(0);
                if (a.length > 1) {
                    a[1] = null;
                }
            } else {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
                a[0] = this.get(0);
            }
            return a;
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException("add");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            E element = this.get(0);
            for (Object next : c) {
                if (element.equals(next)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException("addAll");
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException("addAll");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("removeAll");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("retainAll");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("clear");
        }

        @Override
        public E get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return this.list.get(this.index);
        }

        @Override
        public E set(int index, E element) {
            if (index != 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return this.list.set(this.index, element);
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException("add");
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public int indexOf(Object o) {
            return this.get(0).equals(o) ? 0 : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.get(0).equals(o) ? 0 : -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new ListItr(this, index, this.checkModificationCount, this.getModificationCount);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || fromIndex > 1) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex);
            }
            if (toIndex < fromIndex || toIndex > 1) {
                throw new IndexOutOfBoundsException("toIndex: " + toIndex);
            }
            return fromIndex == toIndex ? Collections.emptyList() : this;
        }
    }
}

