/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import org.eclipse.papyrusrt.xtumlrt.aexpr.lexer.tokens.Token;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@ToString(singleLine=true)
public class Operator
extends Token {
    private static final char PLUS_CHAR = '+';
    private static final char MINUS_CHAR = '-';
    private static final char TIMES_CHAR = '*';
    private static final char DIV_CHAR = '/';
    private static final char MOD_CHAR = '%';
    public static final String PLUS_STR = "+";
    public static final String MINUS_STR = "-";
    public static final String TIMES_STR = "*";
    public static final String DIV_STR = "/";
    public static final String MOD_STR = "%";
    public static final List<Character> BUILT_IN_CHAR = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Character[]{Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%')}));
    public static final List<String> BUILT_IN_STR = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"+", "-", "*", "/", "%"}));
    private Kind kind;

    public Operator(int line, int column, String text) {
        super(line, column, text);
        Kind _kind;
        this.kind = _kind = this.getKind();
    }

    public Kind getKind() {
        Kind _xblockexpression = null;
        if (this.kind == null) {
            Kind _switchResult = null;
            String _text = this.getText();
            boolean _matched = false;
            if (Objects.equal((Object)_text, (Object)PLUS_STR)) {
                _matched = true;
                _switchResult = Kind.PLUS;
            }
            if (!_matched && Objects.equal((Object)_text, (Object)MINUS_STR)) {
                _matched = true;
                _switchResult = Kind.MINUS;
            }
            if (!_matched && Objects.equal((Object)_text, (Object)TIMES_STR)) {
                _matched = true;
                _switchResult = Kind.TIMES;
            }
            if (!_matched && Objects.equal((Object)_text, (Object)DIV_STR)) {
                _matched = true;
                _switchResult = Kind.DIV;
            }
            if (!_matched && Objects.equal((Object)_text, (Object)MOD_STR)) {
                _matched = true;
                _switchResult = Kind.MOD;
            }
            if (!_matched) {
                _switchResult = Kind.UNKNOWN;
            }
            this.kind = _switchResult;
        }
        _xblockexpression = this.kind;
        return _xblockexpression;
    }

    public static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '%';
    }

    @Override
    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().singleLine().toString();
        return result;
    }

    public static enum Kind {
        UNKNOWN,
        PLUS,
        MINUS,
        TIMES,
        DIV,
        MOD;

    }
}

