/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.internal.expressions;

import java.util.Optional;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class UMLRTElementPropertyTester
extends PropertyTester {
    private static final String IS_INHERITED = "isInherited";
    private static final String IS_REDEFINITION = "isRedefinition";
    private static final String IS_EXCLUDED = "isExcluded";
    private static final String CAN_EXCLUDE = "canExclude";
    private static final String CAN_REINHERIT = "canReinherit";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Element element = (Element)PlatformHelper.getAdapter((Object)receiver, Element.class);
        switch (property) {
            case "isInherited": {
                return this.isInherited(element) == this.asBoolean(expectedValue, true);
            }
            case "isRedefinition": {
                return this.isRedefinition(element) == this.asBoolean(expectedValue, true);
            }
            case "isExcluded": {
                return this.isExcluded(element) == this.asBoolean(expectedValue, true);
            }
            case "canExclude": {
                return this.canExclude(element) == this.asBoolean(expectedValue, true);
            }
            case "canReinherit": {
                return this.canReinherit(element) == this.asBoolean(expectedValue, true);
            }
        }
        return false;
    }

    boolean asBoolean(Object value, boolean defaultValue) {
        return value instanceof Boolean ? (Boolean)value : (value == null ? defaultValue : Boolean.valueOf(String.valueOf(value)));
    }

    protected Optional<UMLRTNamedElement> toUMLRT(Element element) {
        return Optional.ofNullable(element).filter(NamedElement.class::isInstance).map(NamedElement.class::cast).map(UMLRTFactory::create);
    }

    protected boolean isInherited(Element element) {
        return UMLRTInheritanceKind.of((Element)element) == UMLRTInheritanceKind.INHERITED;
    }

    protected boolean isRedefinition(Element element) {
        return UMLRTInheritanceKind.of((Element)element) == UMLRTInheritanceKind.REDEFINED;
    }

    protected boolean isExcluded(Element element) {
        return UMLRTInheritanceKind.of((Element)element) == UMLRTInheritanceKind.EXCLUDED;
    }

    protected boolean canExclude(Element element) {
        return this.isInherited(element) || this.isRedefinition(element);
    }

    protected boolean canReinherit(Element element) {
        return this.isExcluded(element) || this.isRedefinition(element);
    }
}

