/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.postprocessor.AbstractUMLChangeFactory;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.AbstractUMLRTChangeFactory;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTCompareUtil;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.ProtocolChange;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.UMLRTCompareFactory;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRTProtocolChangeFactory
extends AbstractUMLRTChangeFactory {
    private static final Function<Diff, List<Diff>> TO_REFINING_DIFFS = new Function<Diff, List<Diff>>(){

        public List<Diff> apply(Diff input) {
            return input.getRefines();
        }
    };

    public boolean handles(Diff input) {
        return this.isAddDeleteOrMoveOfProtocolContainer(input) || UMLRTCompareUtil.isAttributeChangeOfProtocol(input);
    }

    private boolean isAddDeleteOrMoveOfProtocolContainer(Diff diff) {
        if (diff instanceof ReferenceChange) {
            ReferenceChange referenceChange = (ReferenceChange)diff;
            EObject value = referenceChange.getValue();
            EReference reference = referenceChange.getReference();
            return this.isPackagedElementReference(reference) && ProtocolContainerUtils.isProtocolContainer((EObject)value);
        }
        return false;
    }

    private boolean isPackagedElementReference(EReference reference) {
        return UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT.equals(reference);
    }

    public Class<? extends UMLDiff> getExtensionKind() {
        return ProtocolChange.class;
    }

    public UMLDiff createExtension() {
        return UMLRTCompareFactory.eINSTANCE.createProtocolChange();
    }

    protected EObject getDiscriminant(Diff diff) {
        return (EObject)Iterables.find((Iterable)this.getDiscriminants(diff), (Predicate)Predicates.instanceOf(Collaboration.class), null);
    }

    protected Switch<Set<EObject>> getDiscriminantsGetter() {
        return new AbstractUMLChangeFactory.DiscriminantsGetter(this){

            public Set<EObject> caseCollaboration(Collaboration protocol) {
                return this.casePackage(ProtocolUtils.getProtocolContainer((Collaboration)protocol));
            }

            public Set<EObject> casePackage(Package protocolContainer) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                builder.add((Object)protocolContainer);
                builder.addAll((Iterable)protocolContainer.getStereotypeApplications());
                Collaboration collaboration = ProtocolContainerUtils.getCollaboration((Package)protocolContainer);
                builder.add((Object)collaboration);
                builder.addAll((Iterable)collaboration.getStereotypeApplications());
                Interface messageSetIn = ProtocolContainerUtils.getMessageSetIn((Package)protocolContainer);
                builder.add((Object)messageSetIn);
                builder.addAll((Iterable)messageSetIn.getStereotypeApplications());
                Interface messageSetInOut = ProtocolContainerUtils.getMessageSetInOut((Package)protocolContainer);
                builder.add((Object)messageSetInOut);
                builder.addAll((Iterable)messageSetInOut.getStereotypeApplications());
                Interface messageSetOut = ProtocolContainerUtils.getMessageSetOut((Package)protocolContainer);
                builder.add((Object)messageSetOut);
                builder.addAll((Iterable)messageSetOut.getStereotypeApplications());
                return builder.build();
            }
        };
    }

    protected DifferenceKind getRelatedExtensionKind(Diff input) {
        return input.getKind();
    }

    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        super.setRefiningChanges(extension, extensionKind, refiningDiff);
        extension.getRefinedBy().add((Object)refiningDiff);
        ArrayList allRefiningDiffs = Lists.newArrayList((Iterable)extension.getRefinedBy());
        extension.getRefinedBy().clear();
        Iterable refiningDiffs = Iterables.filter((Iterable)allRefiningDiffs, refiningDiff.getClass());
        Iterable refiningDiffsOfRefiningDiffs = Iterables.concat((Iterable)Iterables.transform((Iterable)refiningDiffs, TO_REFINING_DIFFS));
        Iterables.addAll((Collection)extension.getRefinedBy(), (Iterable)Iterables.concat((Iterable)refiningDiffs, (Iterable)refiningDiffsOfRefiningDiffs));
        extension.getRefinedBy().remove((Object)extension);
        if (UMLRTCompareUtil.isProtocolRenameAttributeChange(refiningDiff)) {
            extension.getRefinedBy().addAll(this.getRefiningDiffsOfProtocolRenameIfItIsOne(refiningDiff));
        }
    }

    public void fillRequiredDifferences(Comparison comparison, Diff extension) {
        super.fillRequiredDifferences(comparison, extension);
        extension.getRequires().remove((Object)extension);
        extension.getRequiredBy().remove((Object)extension);
    }

    private Collection<Diff> getRefiningDiffsOfProtocolRenameIfItIsOne(Diff diff) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Comparison comparison = ComparisonUtil.getComparison((Diff)diff);
        for (EObject discriminant : this.getDiscriminants(diff)) {
            Match match = comparison.getMatch(discriminant);
            EList differences = match.getDifferences();
            Iterable refiningDiffs = Iterables.filter((Iterable)differences, (Predicate)Predicates.and(UMLRTCompareUtil.NAME_ATTRIBUTE_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)diff.getSource())));
            builder.addAll(refiningDiffs);
        }
        return builder.build();
    }
}

