/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram.DiagramChangesHandler;

public final class DiagramChangesHandlerService {
    private static final DiagramChangesHandlerService INSTANCE = new DiagramChangesHandlerService();
    private final Set<DiagramChangesHandler> diagramChangesHandlers = new HashSet<DiagramChangesHandler>();

    private DiagramChangesHandlerService() {
    }

    public static DiagramChangesHandlerService getService() {
        return INSTANCE;
    }

    public boolean registerDiagramChangesHandler(DiagramChangesHandler handler) {
        return this.diagramChangesHandlers.add(handler);
    }

    public boolean unregisterNotationChangesHandler(DiagramChangesHandler handler) {
        return this.diagramChangesHandlers.remove(handler);
    }

    public DiagramChangesHandler getHandlerForDiff(Diff diff) {
        DiagramChangesHandler bestMatchingHandler = null;
        double highestPriority = Double.MIN_VALUE;
        for (DiagramChangesHandler handler : this.diagramChangesHandlers) {
            double prio = handler.isHandlerFor(diff);
            if (!(prio > highestPriority)) continue;
            bestMatchingHandler = handler;
            highestPriority = prio;
        }
        return bestMatchingHandler;
    }
}

