/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.IInternalLayoutRunnable;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeProvider;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;

public class RestrictedArrangeCommand
extends AbstractTransactionalCommand {
    private final ILayoutNodeProvider layoutService;
    private List<LayoutNode> nodes;
    private boolean selectionArrange;
    private IAdaptable layoutHint;

    public RestrictedArrangeCommand(TransactionalEditingDomain domain, String label, ILayoutNodeProvider layoutService, List<? extends IFile> affectedFiles, Collection<IGraphicalEditPart> editparts, IAdaptable layoutHint, boolean selectionArrange) {
        super(domain, label, affectedFiles);
        this.layoutService = layoutService;
        this.layoutHint = layoutHint;
        this.selectionArrange = selectionArrange;
        this.initLayoutNodes(editparts);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ICommand cmd = this.getCommandForExecution();
        if (cmd.canExecute()) {
            cmd.execute(monitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    private void initLayoutNodes(Collection<IGraphicalEditPart> editparts) {
        this.nodes = new ArrayList<LayoutNode>(editparts.size());
        for (IGraphicalEditPart ep : editparts) {
            View view = ep.getNotationView();
            if (!ep.isActive() || view == null || !(view instanceof Node) || ep == this.layoutHint.getAdapter(EditPart.class) || ep instanceof IInheritableEditPart && ((IInheritableEditPart)ep).isInherited()) continue;
            Rectangle bounds = ep.getFigure().getBounds();
            this.nodes.add(new LayoutNode((Node)view, bounds.width, bounds.height));
        }
    }

    private ICommand getCommandForExecution() {
        final Runnable layoutRun = this.layoutService.layoutLayoutNodes(this.nodes, this.selectionArrange, this.layoutHint);
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(editingDomain, "");
        if (layoutRun instanceof IInternalLayoutRunnable) {
            Command cmd = ((IInternalLayoutRunnable)layoutRun).getCommand();
            if (cmd != null) {
                ctc.add((IUndoableOperation)new CommandProxy(cmd));
            }
        } else {
            ctc.add((IUndoableOperation)new AbstractTransactionalCommand(editingDomain, "", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    layoutRun.run();
                    return CommandResult.newOKCommandResult();
                }
            });
        }
        return ctc;
    }

    public boolean canExecute() {
        return this.layoutService.canLayoutNodes(this.nodes, this.selectionArrange, this.layoutHint);
    }
}

