/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.labelprovider;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.OpaqueBehaviorUtil;
import org.eclipse.papyrus.uml.tools.utils.OpaqueExpressionUtil;
import org.eclipse.papyrus.uml.tools.utils.OperationUtil;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.utils.CodeSnippetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.InterfaceRealizationUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTMessageUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UsageUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTGuard;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTrigger;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;

public final class LabelUtils {
    private static final String NL_DELIMITER = "\n";
    private static final String ANY_RECEIVE_EVENT_LABEL = "*";
    private static final String EMPTY = Strings.nullToEmpty(null);
    private static final String SPACE = " ";

    private LabelUtils() {
    }

    public static String getProtocolContainerLabel(Package protocolContainer, IItemLabelProvider referenceLabelProvider) {
        Collaboration collaboration = ProtocolContainerUtils.getProtocol((Package)protocolContainer);
        if (collaboration != null && collaboration.getName() != null) {
            return String.valueOf(referenceLabelProvider.getText((Object)protocolContainer)) + SPACE + collaboration.getName();
        }
        return referenceLabelProvider.getText((Object)protocolContainer);
    }

    public static String getCallEventForProtocolMessageLabel(CallEvent callEvent, IItemLabelProvider referenceLabelProvider) {
        Operation operation = callEvent.getOperation();
        if (operation != null && operation.getName() != null) {
            RTMessageKind kind = RTMessageUtils.getMessageKind((Object)operation);
            String direction = kind != null ? kind.getName() : EMPTY;
            return String.valueOf(direction) + SPACE + operation.getName();
        }
        return referenceLabelProvider.getText((Object)callEvent);
    }

    public static String getMessageSetLabel(Interface messageSet, IItemLabelProvider referenceLabelProvider) {
        Collaboration protocol;
        RTMessageKind kind = MessageSetUtils.getMessageKind((Object)messageSet);
        if (kind != null && (protocol = MessageSetUtils.getProtocol((Interface)messageSet)) != null) {
            switch (kind) {
                case IN: {
                    return MessageSetUtils.computeInterfaceInName((String)protocol.getName());
                }
                case OUT: {
                    return MessageSetUtils.computeInterfaceOutName((String)protocol.getName());
                }
                case IN_OUT: {
                    return MessageSetUtils.computeInterfaceInOutName((String)protocol.getName());
                }
            }
            return protocol.getName();
        }
        return referenceLabelProvider.getText((Object)messageSet);
    }

    public static String getInterfaceRealizationLabel(InterfaceRealization interfaceRealization, IItemLabelProvider referenceLabelProvider) {
        Interface messageSet = InterfaceRealizationUtils.getMessageSet((InterfaceRealization)interfaceRealization);
        if (messageSet != null) {
            return LabelUtils.getMessageSetLabel(messageSet, referenceLabelProvider);
        }
        return referenceLabelProvider.getText((Object)interfaceRealization);
    }

    public static String getUsageLabel(Usage usage, IItemLabelProvider referenceLabelProvider) {
        Interface messageSet = UsageUtils.getMessageSet((Usage)usage);
        if (messageSet != null) {
            return LabelUtils.getMessageSetLabel(messageSet, referenceLabelProvider);
        }
        return referenceLabelProvider.getText((Object)usage);
    }

    public static String getTransitionLabel(Transition transition, IItemLabelProvider labelprovider) {
        if (transition.getName() != null && !transition.getName().isEmpty()) {
            return transition.getName();
        }
        EContentsEList triggers = UMLRTExtensionUtil.getUMLRTContents((EObject)transition, (EStructuralFeature)UMLPackage.Literals.TRANSITION__TRIGGER, (EStructuralFeature[])new EStructuralFeature[0]);
        if (!triggers.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            List events = triggers.stream().map(t -> t.getEvent()).collect(Collectors.toList());
            if (!events.isEmpty()) {
                builder.append(LabelUtils.getEventLabel((Event)events.get(0), labelprovider));
                if (events.size() > 1) {
                    builder.append('+');
                }
            }
            String label = builder.toString();
            return label;
        }
        return EMPTY;
    }

    public static String getInternalTransitionLabel(Transition transition, IItemLabelProvider labelprovider) {
        return LabelUtils.getTransitionLabel(transition, labelprovider);
    }

    public static String getEventLabel(Event event, IItemLabelProvider labelprovider) {
        if (event instanceof CallEvent) {
            Operation op = ((CallEvent)event).getOperation();
            if (op != null) {
                return op.getName();
            }
        } else if (event instanceof AnyReceiveEvent) {
            return ANY_RECEIVE_EVENT_LABEL;
        }
        if (labelprovider != null) {
            return labelprovider.getText((Object)event);
        }
        return null;
    }

    public static String getTransitionTooltip(Transition transition, IItemLabelProvider labelprovider) {
        String label = transition.getName();
        if (Strings.isNullOrEmpty((String)label) && !transition.getTriggers().isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            transition.getTriggers().stream().map(t -> t.getEvent()).filter(CallEvent.class::isInstance).map(CallEvent.class::cast).map(ce -> ce.getOperation()).filter(Objects::nonNull).map(op -> op.getName()).collect(Collectors.joining(NL_DELIMITER));
            label = buffer.toString();
        }
        return Strings.nullToEmpty((String)label);
    }

    public static String getInternalTransitionTooltip(Transition transition, IItemLabelProvider labelprovider) {
        return LabelUtils.getTransitionTooltip(transition, labelprovider);
    }

    public static String getGuardTooltip(Constraint guard) {
        return guard != null && guard.getSpecification() instanceof OpaqueExpression ? LabelUtils.getOpaqueExpressionTooltip((OpaqueExpression)guard.getSpecification()) : "";
    }

    public static String getGuardTooltip(UMLRTGuard guard) {
        return guard != null && !guard.getBodies().isEmpty() ? LabelUtils.getBodyForLanguage(guard, null) : "";
    }

    public static String getOpaqueExpressionTooltip(OpaqueExpression specification) {
        return OpaqueExpressionUtil.getBodyForLanguage((OpaqueExpression)specification, null);
    }

    public static String getEffectTooltip(Behavior effect) {
        return effect instanceof OpaqueBehavior ? (((OpaqueBehavior)effect).getLanguages().size() > 0 ? OpaqueBehaviorUtil.getBody((OpaqueBehavior)((OpaqueBehavior)effect), (int)0) : "<Empty Effect definition>") : "<Effect is not an opaque behavior>";
    }

    public static String getGuardTooltip(Transition transition) {
        String triggerGuards;
        UMLRTTransition facade;
        UMLRTTransition uMLRTTransition = facade = transition == null ? null : UMLRTTransition.getInstance((Transition)transition);
        if (facade == null) {
            return EMPTY;
        }
        StringBuilder builder = new StringBuilder();
        UMLRTGuard guard = facade.getGuard();
        if (guard != null && !guard.getBodies().isEmpty()) {
            builder.append("transition ");
            String name = LabelUtils.getTransitionLabel(transition, null);
            if (!Strings.isNullOrEmpty((String)name)) {
                builder.append(name);
                builder.append(' ');
            }
            builder.append('[');
            builder.append(LabelUtils.getBodyForLanguage(guard, null));
            builder.append(']');
        }
        if (!Strings.isNullOrEmpty((String)(triggerGuards = facade.getTriggers().stream().filter(t -> t.getGuard() != null).map(t -> LabelUtils.getTriggerGuardTooltip(t)).filter(((Predicate<String>)Strings::isNullOrEmpty).negate()).map("trigger "::concat).collect(Collectors.joining(NL_DELIMITER))))) {
            if (builder.length() > 0) {
                builder.append(NL_DELIMITER);
            }
            builder.append(triggerGuards);
        }
        return builder.toString();
    }

    public static String getBodyForLanguage(UMLRTGuard guard, String language) {
        String result = null;
        if (language == null) {
            IDefaultLanguage default_ = CodeSnippetUtils.getDefaultLanguage((Element)guard.toUML());
            if (default_ != null) {
                result = (String)guard.getBodies().get(default_.getName());
            }
        } else {
            result = (String)guard.getBodies().get(language);
        }
        if (result == null && language == null && !guard.getBodies().isEmpty()) {
            result = (String)guard.getBodies().values().iterator().next();
        }
        return result;
    }

    public static String getTriggerGuardTooltip(Trigger t) {
        UMLRTTrigger facade = UMLRTTrigger.getInstance((Trigger)t);
        return facade == null ? null : LabelUtils.getTriggerGuardTooltip(facade);
    }

    public static String getTriggerGuardTooltip(UMLRTTrigger t) {
        UMLRTGuard guard = t.getGuard();
        String s = null;
        if (guard != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(LabelUtils.getTriggerName(t.toUML()).trim());
            sb.append(" [");
            sb.append(LabelUtils.getGuardTooltip(guard));
            sb.append(']');
            s = sb.toString();
        }
        return s;
    }

    private static String getTriggerName(Trigger t) {
        String s = null;
        if (t.getEvent() instanceof CallEvent) {
            Operation op = ((CallEvent)t.getEvent()).getOperation();
            if (op != null) {
                s = OperationUtil.getCustomLabel((Operation)op, Collections.singleton("name"));
            }
        } else if (t.getEvent() instanceof AnyReceiveEvent) {
            s = ANY_RECEIVE_EVENT_LABEL;
        }
        return s;
    }

    public static String abbreviateLines(String string, int maxNumberOfLines, String ellipsis) {
        String[] lines = string.split("\r?\n", maxNumberOfLines);
        if (lines.length == maxNumberOfLines) {
            lines[maxNumberOfLines - 1] = ellipsis;
        }
        return Arrays.stream(lines).collect(Collectors.joining(NL_DELIMITER));
    }
}

