/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.properties;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.properties.ui.creation.CreationContext;
import org.eclipse.papyrus.infra.properties.ui.creation.EcorePropertyEditorFactory;
import org.eclipse.papyrus.infra.ui.emf.dialog.NestedEditingDialogContext;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.IFilteredObservableList;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLFactory;

public class RTPropertyEditorFactory<E>
extends UMLPropertyEditorFactory {
    private final IObservableList<E> modelProperty;
    private final Map<EObject, Predicate<Object>> modelPropertyFilters = new HashMap<EObject, Predicate<Object>>();

    public RTPropertyEditorFactory(EReference referenceIn) {
        this(referenceIn, null);
    }

    public RTPropertyEditorFactory(EReference referenceIn, IObservableList<E> modelProperty) {
        super(referenceIn);
        this.modelProperty = modelProperty;
    }

    protected final CreationContext getCreationContext(Object element) {
        CreationContext result = this.basicGetCreationContext(element);
        return result == null ? result : this.wrapCreationContext(result);
    }

    protected CreationContext basicGetCreationContext(Object element) {
        return super.getCreationContext(element);
    }

    private CreationContext wrapCreationContext(CreationContext context) {
        return new AttachedCreationContext(context);
    }

    protected Object doCreateObject(Control widget, Object context) {
        EObject instance = this.isContainment(this.referenceIn) ? this.simpleCreateObject(widget) : this.createObjectInDifferentContainer(widget);
        return this.createObject(widget, context, instance);
    }

    EcorePropertyEditorFactory.CreateIn getCreateIn(CreationContext context, EObject newElement) {
        EcorePropertyEditorFactory.CreateIn result = null;
        if (this.isContainment(this.referenceIn)) {
            result = new EcorePropertyEditorFactory.CreateIn((EcorePropertyEditorFactory)this){};
            result.createInReference = this.referenceIn;
            result.createInObject = (EObject)context.getCreationContextElement();
        } else {
            result = (EcorePropertyEditorFactory.CreateIn)this.createIn.get(newElement);
        }
        return result;
    }

    public Collection<Object> validateObjects(Collection<Object> objectsToValidate) {
        if (!this.isContainment(this.referenceIn)) {
            for (Object objectToValidate : objectsToValidate) {
                EcorePropertyEditorFactory.CreateIn creationInformation = (EcorePropertyEditorFactory.CreateIn)this.createIn.get(objectToValidate);
                if (creationInformation != null) {
                    this.set(creationInformation.createInObject, creationInformation.createInReference, objectToValidate);
                    continue;
                }
                Activator.log.warn("Unknown object : " + objectToValidate);
            }
        }
        return objectsToValidate;
    }

    protected boolean isContainment(EReference reference) {
        EAnnotation annotation;
        boolean result = reference.isContainment();
        if (!result && (annotation = reference.getEAnnotation("subsets")) != null) {
            for (EObject next : annotation.getReferences()) {
                EReference superset;
                if (!(next instanceof EReference) || !this.isContainment(superset = (EReference)next)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    void filter(EObject createdObject) {
        IFilteredObservableList<Object> list = this.getFilteredObservableList();
        if (list != null) {
            list.addFilter(this.getFilter(createdObject));
        }
    }

    protected final IObservableList<E> getModelProperty() {
        return this.modelProperty;
    }

    protected final IFilteredObservableList<E> getFilteredObservableList() {
        return IFilteredObservableList.getFilteredList(this.getModelProperty());
    }

    private Predicate<Object> getFilter(EObject createdObject) {
        return this.modelPropertyFilters.computeIfAbsent(createdObject, this.filterFunction());
    }

    protected Function<EObject, Predicate<Object>> filterFunction() {
        return v -> o -> o != v;
    }

    void unfilter(EObject createdObject) {
        IFilteredObservableList<Object> list = this.getFilteredObservableList();
        if (list != null) {
            list.removeFilter(this.modelPropertyFilters.remove(createdObject));
        }
    }

    protected EObject simpleCreateObject(Control widget) {
        EClass toCreate = this.chooseEClass(widget);
        if (toCreate == null) {
            toCreate = this.type;
        }
        return this.create(toCreate);
    }

    protected EObject create(EClass eClass) {
        ResourceSet rset = NestedEditingDialogContext.getInstance().getResourceSet();
        EFactory factory = rset.getPackageRegistry().getEFactory("http://www.eclipse.org/uml2/5.0.0/UML");
        if (factory == null) {
            factory = UMLFactory.eINSTANCE;
        }
        return factory.create(eClass);
    }

    protected void applyStereotypes(Element newElement) {
    }

    class AttachedCreationContext
    implements CreationContext {
        private final CreationContext delegate;

        AttachedCreationContext(CreationContext delegate) {
            this.delegate = delegate;
        }

        public void pushCreatedElement(Object newElement) {
            EObject created;
            EcorePropertyEditorFactory.CreateIn createIn;
            if (newElement instanceof EObject && (createIn = RTPropertyEditorFactory.this.getCreateIn(this, created = (EObject)newElement)) != null) {
                RTPropertyEditorFactory.this.filter(created);
                this.withoutReification(createIn, () -> this.eAdd(createIn.createInObject, (EStructuralFeature)createIn.createInReference, created));
            }
            this.delegate.pushCreatedElement(newElement);
        }

        void withoutReification(EcorePropertyEditorFactory.CreateIn creationContext, Runnable action) {
            if (creationContext.createInObject instanceof Element) {
                UMLRTExtensionUtil.run((Element)((Element)creationContext.createInObject), (Runnable)action);
            } else {
                action.run();
            }
        }

        private void eAdd(EObject owner, EStructuralFeature feature, Object value) {
            if (feature.isMany()) {
                ((EList)owner.eGet(feature)).add(value);
            } else {
                owner.eSet(feature, value);
            }
            if (value instanceof Element) {
                RTPropertyEditorFactory.this.applyStereotypes((Element)value);
            }
        }

        public void popCreatedElement(Object newElement) {
            EObject created;
            EcorePropertyEditorFactory.CreateIn createIn;
            this.delegate.popCreatedElement(newElement);
            if (newElement instanceof EObject && (createIn = RTPropertyEditorFactory.this.getCreateIn(this, created = (EObject)newElement)) != null) {
                this.withoutReification(createIn, () -> this.eRemove(createIn.createInObject, (EStructuralFeature)createIn.createInReference, created));
                RTPropertyEditorFactory.this.unfilter(created);
            }
        }

        private void eRemove(EObject owner, EStructuralFeature feature, Object value) {
            if (feature.isMany()) {
                ((EList)owner.eGet(feature)).remove(value);
            } else if (owner.eGet(feature) == value) {
                owner.eUnset(feature);
            }
        }

        public EObject getCreationContextElement() {
            return (EObject)this.delegate.getCreationContextElement();
        }
    }
}

