/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.profile.RTCppProperties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ClassKind implements Enumerator
{
    CLASS(0, "Class", "Class"),
    STRUCT(1, "Struct", "Struct"),
    UNION(2, "Union", "Union"),
    TYPEDEF(3, "Typedef", "Typedef");

    public static final int CLASS_VALUE = 0;
    public static final int STRUCT_VALUE = 1;
    public static final int UNION_VALUE = 2;
    public static final int TYPEDEF_VALUE = 3;
    private static final ClassKind[] VALUES_ARRAY;
    public static final List<ClassKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ClassKind[]{CLASS, STRUCT, UNION, TYPEDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ClassKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClassKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClassKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClassKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClassKind get(int value) {
        switch (value) {
            case 0: {
                return CLASS;
            }
            case 1: {
                return STRUCT;
            }
            case 2: {
                return UNION;
            }
            case 3: {
                return TYPEDEF;
            }
        }
        return null;
    }

    private ClassKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

