/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTClassifier;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class ClassifierEditHelperAdvice
extends AbstractEditHelperAdvice {
    private static final Set<EReference> NESTED_CLASSIFIER_REFERENCES = ImmutableSet.of((Object)UMLPackage.Literals.CLASS__NESTED_CLASSIFIER, (Object)UMLPackage.Literals.INTERFACE__NESTED_CLASSIFIER);

    public boolean approveRequest(IEditCommandRequest request) {
        boolean result = request instanceof CreateElementRequest ? this.approveCreateRequest((CreateElementRequest)request) : (request instanceof SetRequest ? this.approveSetRequest((SetRequest)request) : super.approveRequest(request));
        return result;
    }

    protected boolean approveSetRequest(SetRequest request) {
        boolean result = true;
        if (NESTED_CLASSIFIER_REFERENCES.contains(request.getFeature()) && UMLRTProfileUtils.isUMLRTProfileApplied((Element)((Classifier)request.getElementToEdit()))) {
            Set<EObject> collection = request.getValue() instanceof Collection ? (Set<EObject>)request.getValue() : Collections.singleton((EObject)request.getValue());
            result = !collection.isEmpty() && !collection.stream().anyMatch(ProtocolUtils::isProtocol);
        }
        return result;
    }

    protected boolean approveCreateRequest(CreateElementRequest request) {
        UMLRTNamedElement element;
        boolean result = true;
        if (ElementTypeUtils.isTypeCompatible(request.getElementType(), (IElementType)UMLElementTypes.GENERALIZATION) && request.getContainer() instanceof Classifier && (element = UMLRTFactory.create((NamedElement)((Classifier)request.getContainer()))) instanceof UMLRTClassifier) {
            UMLRTClassifier classifier = (UMLRTClassifier)element;
            result = classifier.toUML().getGeneralizations().isEmpty();
        }
        return result;
    }
}

