/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguageService;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocolMessage;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;

public class ProtocolUtils {
    public static final String INTERNAL = "Internal";
    public static final String UMLRT_BASE_COMM_PROTOCOL = "UMLRTBaseCommProtocol";

    public static Package getProtocolContainer(Collaboration protocol) {
        return protocol.getNearestPackage();
    }

    public static Boolean isProtocol(EObject context) {
        return ElementTypeUtils.matches(context, "org.eclipse.papyrusrt.umlrt.core.Protocol");
    }

    public static List<Operation> getRTMessages(Collaboration protocol, RTMessageKind direction, boolean showInherited) {
        List<Object> result;
        UMLRTProtocol facade = UMLRTProtocol.getInstance((Collaboration)protocol);
        if (facade == null) {
            result = Collections.emptyList();
        } else {
            Stream<Object> messages = facade.getMessages(direction, true).stream();
            if (!showInherited) {
                messages = messages.filter(m -> !m.isVirtualRedefinition());
            }
            result = messages.map(UMLRTProtocolMessage::toUML).collect(Collectors.toList());
        }
        return result;
    }

    public static Interface getMessageSet(Collaboration editContext, RTMessageKind direction) {
        Package protocolContainer = ProtocolUtils.getProtocolContainer(editContext);
        if (protocolContainer != null) {
            return ProtocolContainerUtils.getMessageSet(protocolContainer, direction);
        }
        return null;
    }

    public static Interface getMessageSetIn(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.IN);
    }

    public static Interface getMessageSetOut(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.OUT);
    }

    public static Interface getMessageSetInOut(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.IN_OUT);
    }

    public static List<UMLRTProtocol> getAllProtocols(UMLRTProtocol protocol) {
        ArrayList<UMLRTProtocol> allProtocols = new ArrayList<UMLRTProtocol>();
        allProtocols.addAll(protocol.getAncestry());
        Collaboration baseProtocol = ProtocolUtils.getBaseProtocol((Element)protocol.toUML());
        if (baseProtocol != null && protocol != baseProtocol) {
            allProtocols.add(UMLRTProtocol.getInstance((Collaboration)baseProtocol));
        }
        Collections.reverse(allProtocols);
        return allProtocols;
    }

    public static boolean isCommonProtocol(Collection<UMLRTProtocol> protocolSet, UMLRTProtocol protocolCandidate) {
        for (UMLRTProtocol protocol : protocolSet) {
            if (ProtocolUtils.getAllProtocols(protocol).contains(protocolCandidate)) continue;
            return false;
        }
        return true;
    }

    public static Collaboration getBaseProtocol(Element anElement) {
        if (anElement != null) {
            IDefaultLanguage language = null;
            try {
                IDefaultLanguageService service = (IDefaultLanguageService)ServiceUtilsForEObject.getInstance().getService(IDefaultLanguageService.class, (Object)anElement);
                language = service.getActiveDefaultLanguage(anElement);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
            if (language != null) {
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)anElement);
                return language.getBaseProtocol(domain.getResourceSet());
            }
        }
        return null;
    }
}

