/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElement;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.PortRegistrationType;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.system.profile.util.SystemElementsUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.CompositeValidator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.ChangeListenerUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.CapsulePartKindObservableValue;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.PortRTKindObservableValue;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class RTStereotypeModelElement
extends StereotypeModelElement {
    protected static final ILabelProvider registrationLabelProvider = new RegistrationLabelProvider();

    public RTStereotypeModelElement(EObject stereoApplication, Stereotype stereotype, EditingDomain domain) {
        super(stereoApplication, stereotype, domain);
    }

    protected boolean isFeatureEditable(String propertyPath) {
        boolean editable = true;
        EStructuralFeature feature = this.getFeature(propertyPath);
        EObject source = this.getSource();
        if (source instanceof RTPort) {
            RTPort rtPort = (RTPort)source;
            UMLRTPort port = UMLRTPort.getInstance((Port)rtPort.getBase_Port());
            if (port != null) {
                UMLRTProtocol protocol = port.getType();
                if (protocol != null && SystemElementsUtils.isSystemProtocol((Collaboration)protocol.toUML())) {
                    editable = false;
                } else if ("kind".equals(propertyPath)) {
                    editable = true;
                } else if (feature == UMLRealTimePackage.Literals.RT_PORT__IS_NOTIFICATION) {
                    editable = port.isBehavior();
                } else if (feature == UMLRealTimePackage.Literals.RT_PORT__IS_WIRED) {
                    editable = !port.isInherited();
                    editable = editable && port.isBehavior() && !port.isConnected() && !RTPortUtils.isLegacySpp((Port)port.toUML()) && !RTPortUtils.isLegacySap((Port)port.toUML());
                } else {
                    editable = feature == UMLRealTimePackage.Literals.RT_PORT__IS_PUBLISH ? false : (feature == UMLRealTimePackage.Literals.RT_PORT__REGISTRATION ? !rtPort.isWired() && !port.isInherited() : (feature == UMLRealTimePackage.Literals.RT_PORT__REGISTRATION_OVERRIDE ? !rtPort.isWired() && !port.isInherited() : super.isFeatureEditable(propertyPath)));
                }
            }
        } else {
            editable = source instanceof CapsulePart ? true : super.isFeatureEditable(propertyPath);
        }
        return editable;
    }

    public IObservable doGetObservable(String propertyPath) {
        Object observe = null;
        if ("kind".equals(propertyPath)) {
            EObject source = this.getSource();
            if (source instanceof RTPort) {
                observe = new PortRTKindObservableValue(source, (TransactionalEditingDomain)this.domain);
            } else if (source instanceof CapsulePart) {
                observe = new CapsulePartKindObservableValue(source, (TransactionalEditingDomain)this.domain);
            }
        } else {
            observe = super.doGetObservable(propertyPath);
        }
        if (this.getSource() instanceof RTPort) {
            observe.addChangeListener((IChangeListener)new RTStereotypeModelElementChangeListener());
        }
        return observe;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        IStaticContentProvider provider = null;
        EObject source = this.getSource();
        if ("kind".equals(propertyPath) && source instanceof RTPort) {
            LinkedHashMap<RTPortKindEnum, String> map = new LinkedHashMap<RTPortKindEnum, String>(RTPortKindEnum.values().length);
            map.put(RTPortKindEnum.EXTERNAL, RTPortKindEnum.EXTERNAL.getLabel());
            map.put(RTPortKindEnum.INTERNAL, RTPortKindEnum.INTERNAL.getLabel());
            map.put(RTPortKindEnum.RELAY, RTPortKindEnum.RELAY.getLabel());
            map.put(RTPortKindEnum.SAP, RTPortKindEnum.SAP.getLabel());
            map.put(RTPortKindEnum.SPP, RTPortKindEnum.SPP.getLabel());
            provider = new StaticContentProvider(map.keySet().toArray());
        } else if ("kind".equals(propertyPath) && source instanceof CapsulePart) {
            LinkedHashMap<CapsulePartKindEnum, String> map = new LinkedHashMap<CapsulePartKindEnum, String>(CapsulePartKindEnum.values().length);
            map.put(CapsulePartKindEnum.FIXED, CapsulePartKindEnum.FIXED.getLabel());
            map.put(CapsulePartKindEnum.OPTIONAL, CapsulePartKindEnum.OPTIONAL.getLabel());
            map.put(CapsulePartKindEnum.PLUGIN, CapsulePartKindEnum.PLUGIN.getLabel());
            provider = new StaticContentProvider(map.keySet().toArray());
        } else {
            provider = super.getContentProvider(propertyPath);
        }
        return provider;
    }

    public IValidator getValidator(String propertyPath) {
        IValidator result = super.getValidator(propertyPath);
        if ("kind".equals(propertyPath)) {
            result = CompositeValidator.of(result, enumValue -> {
                if (this.source instanceof RTPort && enumValue instanceof RTPortKindEnum ? RTPortUtils.isKindEditable((Port)((RTPort)this.source).getBase_Port(), (RTPortKindEnum)((RTPortKindEnum)enumValue)) : this.source instanceof CapsulePart && enumValue instanceof CapsulePartKindEnum && CapsulePartUtils.isKindEditable((Property)((CapsulePart)this.source).getBase_Property(), (CapsulePartKindEnum)((CapsulePartKindEnum)enumValue))) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            });
        }
        return result;
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        if ("registration".equals(propertyPath) && this.source instanceof RTPort) {
            return registrationLabelProvider;
        }
        return super.getLabelProvider(propertyPath);
    }

    public boolean forceRefresh(String propertyPath) {
        return true;
    }

    boolean isViable() {
        boolean result;
        Object selected;
        Object object = selected = this.dataSource != null ? this.dataSource.getSelection().getFirstElement() : null;
        if (selected == null) {
            result = false;
        } else {
            View view = (View)PlatformHelper.getAdapter((Object)selected, View.class);
            boolean bl = result = view == null || view.eResource() != null;
            if (result) {
                EObject source = this.getSource();
                result = source != null && source.eResource() != null;
            }
        }
        return result;
    }

    public class RTStereotypeModelElementChangeListener
    implements IChangeListener {
        public void handleChange(ChangeEvent event) {
            if (RTStereotypeModelElement.this.isViable()) {
                try {
                    ChangeListenerUtils.fireDataSourceChanged(RTStereotypeModelElement.this.dataSource);
                }
                catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                    Activator.log.debug(e.getMessage());
                }
            }
        }
    }

    public static class RegistrationLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof PortRegistrationType) {
                switch ((PortRegistrationType)element) {
                    case APPLICATION: {
                        return "Application";
                    }
                    case AUTOMATIC: {
                        return "Automatic";
                    }
                    case AUTOMATIC_LOCKED: {
                        return "Automatic (locked)";
                    }
                }
                return super.getText(element);
            }
            return super.getText(element);
        }
    }
}

