/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement.RTStereotypeModelElement;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.RTEnumRadioValueEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RTKindEnumPropertyEditor
extends AbstractPropertyEditor {
    protected RTEnumRadioValueEditor kindValueEditor = (RTEnumRadioValueEditor)this.valueEditor;
    protected int numColumns = -1;
    protected Class<? extends Enum<?>> enumType;

    public RTKindEnumPropertyEditor(Composite parent, int style) {
        super((AbstractValueEditor)new RTEnumRadioValueEditor(parent, style));
    }

    public void setEnumType(Class<? extends Enum<?>> enumType) {
        this.enumType = enumType;
        if (this.input != null && this.propertyPath != null) {
            this.applyReadOnly(this.readOnly);
        }
    }

    public Class<? extends Enum<?>> getEnumType() {
        return this.enumType;
    }

    protected void applyReadOnly(boolean readOnly) {
        ModelElement element;
        Element uml;
        super.applyReadOnly(readOnly);
        if (!readOnly && this.enumType != null && (uml = this.getSourceUMLElement(element = this.input.getModelElement(this.propertyPath))) != null) {
            Enum<?>[] enumArray = this.enumType.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum<?> enumValue = enumArray[n2];
                this.kindValueEditor.setReadOnly(enumValue, this.isKindEditable(uml, enumValue));
                ++n2;
            }
        }
    }

    protected Element getSourceUMLElement(ModelElement element) {
        Element result = null;
        if (element instanceof UMLModelElement) {
            result = (Element)((UMLModelElement)element).getSource();
        } else if (element instanceof RTStereotypeModelElement) {
            result = UMLUtil.getBaseElement((EObject)((RTStereotypeModelElement)element).getSource());
        }
        return result;
    }

    protected boolean isKindEditable(Element element, Enum<?> enumValue) {
        boolean result = true;
        try {
            IStatus status = this.getValidator().validate(enumValue);
            result = status == null || status.getSeverity() < 4;
        }
        catch (Exception e) {
            Activator.log.error("Failed to determine validity of enum value; probable properties view configuration fault", (Throwable)e);
        }
        return result;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
        this.kindValueEditor.setNumColumns(numColumns);
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    protected void doBinding() {
        this.kindValueEditor.setProviders(this.input.getContentProvider(this.propertyPath), this.input.getLabelProvider(this.propertyPath));
        super.doBinding();
    }
}

