/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.internal.ICodeSnippetPage;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.ChoicePointTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.ICodeSnippetTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.OperationTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.StateEntryTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.StateExitTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.TransitionEffectTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.TransitionGuardTab;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.TriggerGuardTab;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.uml2.uml.Trigger;

public class CodeSnippetPage
extends Page
implements ICodeSnippetPage {
    private Composite pageControl;
    private EObject currentSelectedEObject;
    private Control defaultPage;
    private List<ICodeSnippetTab> tabs = new ArrayList<ICodeSnippetTab>();
    private Map<IElementType, Control> elementTypeToPage = new HashMap<IElementType, Control>();
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private PageBook pageBook;

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            if (selection.isEmpty()) {
                this.currentSelectedEObject = null;
            } else {
                EObject eo = EMFHelper.getEObject((Object)((IStructuredSelection)selection).getFirstElement());
                if (eo != null && !eo.equals(this.currentSelectedEObject)) {
                    this.currentSelectedEObject = eo;
                }
            }
            CTabFolder tabFolder = null;
            for (ICodeSnippetTab tab : this.tabs) {
                if (!tab.shouldShowThisTab(this.currentSelectedEObject)) continue;
                tabFolder = this.getPageFolder(this.currentSelectedEObject);
                if (!tab.controlCreated()) {
                    tab.createControl(tabFolder);
                }
                tab.setInput(this.currentSelectedEObject);
            }
            if (tabFolder != null) {
                if (tabFolder.getSelection() == null) {
                    tabFolder.setSelection(0);
                }
                this.pageBook.showPage(tabFolder);
            } else {
                this.pageBook.showPage(this.defaultPage);
            }
        }
    }

    private CTabFolder getPageFolder(EObject context) {
        IElementType type = ElementTypeRegistry.getInstance().getElementType(context, ElementTypeUtils.getEditContext());
        Control folder = this.elementTypeToPage.get(type);
        if (folder != null) {
            return (CTabFolder)folder;
        }
        CTabFolder tabFolder = new CTabFolder((Composite)this.pageBook, 1024);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.elementTypeToPage.put(type, (Control)tabFolder);
        return tabFolder;
    }

    public void createControl(Composite parent) {
        this.tabs.add(new TransitionEffectTab());
        this.tabs.add(new TransitionGuardTab());
        this.tabs.add(new StateEntryTab());
        this.tabs.add(new StateExitTab());
        this.tabs.add(new TriggerGuardTab());
        this.tabs.add(new OperationTab());
        this.tabs.add(new ChoicePointTab());
        this.pageControl = new Composite(parent, 0);
        this.pageControl.setLayout((Layout)new FillLayout());
        this.pageBook = new PageBook(this.pageControl, 0);
        this.createDefaultPage();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    private void createDefaultPage() {
        Composite page = new Composite((Composite)this.pageBook, 0);
        page.setLayoutData((Object)new GridData(1808));
        page.setLayout((Layout)new GridLayout());
        CLabel label = new CLabel(page, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText("Code snippet view is not available for the current selection.");
        this.defaultPage = page;
    }

    public Control getControl() {
        return this.pageControl;
    }

    public void setFocus() {
        this.pageControl.setFocus();
    }

    public void dispose() {
        this.getSite().setSelectionProvider(null);
        this.tabs.stream().forEach(t -> t.dispose());
        super.dispose();
    }

    public ISelection getSelection() {
        StructuredSelection selection = new StructuredSelection();
        if (this.currentSelectedEObject != null) {
            selection = this.currentSelectedEObject instanceof Trigger ? new StructuredSelection((Object)this.currentSelectedEObject.eContainer()) : new StructuredSelection((Object)this.currentSelectedEObject);
        }
        return selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }
}

