/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs;

import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.TransitionGuardTab;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class ChoicePointTransitionGuardTab
extends TransitionGuardTab {
    protected Pseudostate choice;

    public ChoicePointTransitionGuardTab(Pseudostate choice) {
        this.choice = choice;
    }

    @Override
    public String getTitle() {
        Transition transition = (Transition)this.input;
        String name = transition.getName();
        if (!UML2Util.isEmpty((String)name)) {
            return name;
        }
        String transitionIdentifier = " --> ";
        Vertex target = transition.getTarget();
        String targetName = target.getName();
        if (!UML2Util.isEmpty((String)targetName)) {
            return String.valueOf(transitionIdentifier) + targetName;
        }
        targetName = target.eClass().getName();
        if (target instanceof Pseudostate) {
            State containingState;
            PseudostateKind kind = ((Pseudostate)target).getKind();
            targetName = kind.getName();
            targetName = String.valueOf(targetName.substring(0, 1).toUpperCase()) + targetName.substring(1);
            if ((PseudostateKind.ENTRY_POINT_LITERAL.equals((Object)kind) || PseudostateKind.EXIT_POINT_LITERAL.equals((Object)kind)) && (containingState = ((Pseudostate)target).getState()).isComposite()) {
                targetName = containingState.getName();
                if (!UML2Util.isEmpty((String)targetName)) {
                    return String.valueOf(transitionIdentifier) + targetName;
                }
                targetName = "CompositeState";
            }
        }
        return String.valueOf(transitionIdentifier) + "<" + targetName + ">";
    }

    @Override
    protected void updateLabel() {
        super.updateLabel();
        if (this.choice != null) {
            this.label.setImage(this.labelProvider.getImage((Object)this.choice));
            this.label.setText(this.labelProvider.getText((Object)this.choice));
        }
    }
}

