package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;

import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePartKind;

/**
 * @deprecated Use the {@link UMLRTCapsulePartKind} enumeration type, instead.
 */
public enum CapsulePartKindEnum {

	/**
	 * Fixed kind of capsule Part
	 */
	FIXED(0, "Fixed", UMLRTCapsulePartKind.FIXED),

	/**
	 * Optional kind of capsule Part
	 */
	OPTIONAL(1, "Optional", UMLRTCapsulePartKind.OPTIONAL),

	/**
	 * Plugin kind of capsule Part
	 */
	PLUGIN(2, "Plugin", UMLRTCapsulePartKind.PLUG_IN);


	private static final Map<UMLRTCapsulePartKind, CapsulePartKindEnum> FACADE_MAP = new EnumMap<>(UMLRTCapsulePartKind.class);

	private final String label;

	private final int index;
	private final UMLRTCapsulePartKind facadeKind;

	static {
		FACADE_MAP.put(UMLRTCapsulePartKind.NULL, null);
		Arrays.asList(values()).forEach(k -> FACADE_MAP.put(k.toFacade(), k));
	}

	public String getLabel() {

		return label;
	}

	public int getIndex() {

		return index;
	}

	private CapsulePartKindEnum(int index, String label, UMLRTCapsulePartKind facadeKind) {
		this.label = label;
		this.index = index;
		this.facadeKind = facadeKind;
	}

	public static CapsulePartKindEnum fromFacade(UMLRTCapsulePartKind facadeKind) {
		return FACADE_MAP.get(facadeKind);
	}

	public UMLRTCapsulePartKind toFacade() {
		return facadeKind;
	}

	public static UMLRTCapsulePartKind toFacade(CapsulePartKindEnum kind) {
		return (kind == null) ? UMLRTCapsulePartKind.NULL : kind.toFacade();
	}

	@Override
	public String toString() {
		return label;
	}

}
