/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.internal.types.advice;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTCommandUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTStateMachine;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;

public class StateMachineInheritanceAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
        ICommand result = null;
        if (ElementTypeUtils.isTypeCompatible(request.getElementType(), (IElementType)UMLElementTypes.STATE_MACHINE)) {
            result = this.getBeforeCreateStateMachineCommand(request);
        }
        return result;
    }

    protected ICommand getAfterCreateCommand(CreateElementRequest request) {
        ICommand result = null;
        if (ElementTypeUtils.isTypeCompatible(request.getElementType(), (IElementType)UMLElementTypes.STATE_MACHINE)) {
            result = this.getAfterCreateStateMachineCommand(request);
        }
        return result;
    }

    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        ICommand result = null;
        if (ElementTypeUtils.isTypeCompatible(request.getElementType(), (IElementType)UMLElementTypes.GENERALIZATION)) {
            result = this.getBeforeCreateGeneralizationCommand(request);
        }
        return result;
    }

    protected ICommand getBeforeCreateStateMachineCommand(CreateElementRequest request) {
        UMLRTCapsule general;
        ICommand result = null;
        if (request.getContainer() instanceof BehavioredClassifier && CapsuleUtils.isCapsule((Classifier)request.getContainer()) && (general = UMLRTCapsule.getInstance((Class)((Class)request.getContainer()))) != null) {
            result = this.deleteDefaultSMContents((IEditCommandRequest)request, general.getHierarchy().skip(1L));
        }
        return result;
    }

    protected ICommand getAfterCreateStateMachineCommand(CreateElementRequest request) {
        UMLRTCapsule general;
        ICommand result = null;
        if (request.getContainer() instanceof BehavioredClassifier && CapsuleUtils.isCapsule((Classifier)request.getContainer()) && (general = UMLRTCapsule.getInstance((Class)((Class)request.getContainer()))) != null) {
            result = this.initializeContents((IEditCommandRequest)request, general.getHierarchy().skip(1L));
        }
        return result;
    }

    protected ICommand getBeforeCreateGeneralizationCommand(CreateRelationshipRequest request) {
        ICommand result = null;
        if (request.getSource() instanceof Classifier && request.getTarget() instanceof Classifier && CapsuleUtils.isCapsule((Classifier)request.getSource()) && CapsuleUtils.isCapsule((Classifier)request.getTarget())) {
            UMLRTCapsule specific = UMLRTCapsule.getInstance((Class)((Class)request.getSource()));
            UMLRTCapsule general = UMLRTCapsule.getInstance((Class)((Class)request.getTarget()));
            if (specific != null && general != null && general.getStateMachine() != null) {
                result = this.deleteDefaultSMContents((IEditCommandRequest)request, specific.getHierarchy());
            }
        }
        return result;
    }

    ICommand deleteDefaultSMContents(IEditCommandRequest trigger, Stream<UMLRTCapsule> capsuleHierarchy) {
        return capsuleHierarchy.map(UMLRTCapsule::getStateMachine).filter(Objects::nonNull).filter(StateMachineInheritanceAdvice.isRootDefinition()).filter(UMLRTStateMachine::isDefaultContent).map(sm -> this.deleteContents(trigger, (UMLRTStateMachine)sm)).reduce(UMLRTCommandUtils::flatCompose).orElse(null);
    }

    static Predicate<UMLRTNamedElement> isRootDefinition() {
        Predicate<UMLRTNamedElement> isInherited = UMLRTNamedElement::isInherited;
        return isInherited.negate();
    }

    protected ICommand deleteContents(IEditCommandRequest trigger, UMLRTStateMachine stateMachine) {
        return stateMachine.toRegion().getOwnedElements().stream().map(e -> UMLRTCommandUtils.destroy(trigger, (EObject)e)).reduce(UMLRTCommandUtils::flatCompose).orElse(null);
    }

    ICommand initializeContents(IEditCommandRequest trigger, Stream<UMLRTCapsule> capsuleHierarchy) {
        return capsuleHierarchy.map(UMLRTCapsule::getStateMachine).filter(StateMachineInheritanceAdvice.isRootDefinition()).map(sm -> this.initializeContents(trigger, (UMLRTStateMachine)sm)).reduce(UMLRTCommandUtils::flatCompose).orElse(null);
    }

    protected ICommand initializeContents(IEditCommandRequest trigger, final UMLRTStateMachine stateMachine) {
        return new AbstractTransactionalCommand(trigger.getEditingDomain(), "Initialize State Machine", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                stateMachine.ensureDefaultContents();
                return CommandResult.newOKCommandResult((Object)stateMachine.toUML());
            }
        };
    }
}

