/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartKindEnum;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePartKind;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CapsulePartUtils {
    public static boolean isCapsulePart(Property property) {
        return ElementTypeUtils.matches((EObject)property, "org.eclipse.papyrusrt.umlrt.core.CapsulePart");
    }

    public static CapsulePart getStereotypeApplication(Property property) {
        return (CapsulePart)UMLUtil.getStereotypeApplication((Element)property, CapsulePart.class);
    }

    @Deprecated
    public static boolean isKindEditable(Property capsulePart, CapsulePartKindEnum newKind) {
        return CapsulePartUtils.isKindEditable(capsulePart, newKind.toFacade());
    }

    public static boolean isKindEditable(Property capsulePart, UMLRTCapsulePartKind newKind) {
        UMLRTCapsulePart partFacade;
        boolean result = true;
        UMLRTCapsulePart uMLRTCapsulePart = partFacade = capsulePart == null ? null : UMLRTCapsulePart.getInstance((Property)capsulePart);
        if (partFacade != null) {
            UMLRTCapsulePartKind currentKind = partFacade.getKind();
            if (newKind == UMLRTCapsulePartKind.NULL) {
                result = false;
            } else if (newKind != currentKind) {
                if (partFacade.isInherited()) {
                    boolean bl = result = currentKind != UMLRTCapsulePartKind.PLUG_IN && newKind != UMLRTCapsulePartKind.PLUG_IN;
                }
                if (newKind == UMLRTCapsulePartKind.FIXED && CapsulePartUtils.completesCycle(capsulePart.getType(), capsulePart)) {
                    result = false;
                }
            }
        }
        return result;
    }

    public static boolean completesCycle(Type newType, Property elementToEdit) {
        boolean result = false;
        HashSet<Type> allTypes = new HashSet<Type>();
        EObject container = elementToEdit.eContainer();
        allTypes.add(newType);
        result = container == newType ? true : CapsulePartUtils.getAllInvolvedCapsuleTypes(newType, allTypes).contains(container);
        return result;
    }

    private static Set<Type> getAllInvolvedCapsuleTypes(Type newType, Set<Type> allTypes) {
        if (newType != null && newType instanceof Classifier) {
            for (Property next : ((Classifier)newType).getAllAttributes()) {
                Type thisType;
                if (!CapsulePartUtils.isCapsulePart(next) || !UMLRTCapsulePart.getInstance((Property)next).getKind().equals((Object)UMLRTCapsulePartKind.FIXED) || (thisType = next.getType()) == null || !allTypes.add(thisType)) continue;
                CapsulePartUtils.getAllInvolvedCapsuleTypes(thisType, allTypes);
            }
        }
        return allTypes;
    }
}

