/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.emf.facet.custom.ui.ICustomizedToolTipLabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.appearance.helper.AppearanceHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.services.labelprovider.service.ExtensibleLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.diagram.common.editparts.EditableLabelForNodeEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.Activator;
import org.eclipse.swt.graphics.Image;

public class LabelInListCompartmentEditPart
extends EditableLabelForNodeEditPart {
    private Label toolTipLabel = new Label();

    public LabelInListCompartmentEditPart(View view) {
        super(view);
    }

    protected Image getLabelIcon() {
        EObject parserElement = this.getParserElement();
        if (parserElement == null || this.getViewer() == null && parserElement.eResource() != null) {
            return null;
        }
        List views = DiagramEditPartsUtil.findViews((EObject)parserElement, (EditPartViewer)this.getViewer());
        for (View view : views) {
            if (!AppearanceHelper.showElementIcon((EModelElement)view)) continue;
            try {
                return ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)parserElement)).getLabelProvider().getImage((Object)parserElement);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    protected void handleNotificationEvent(Notification event) {
        ISemanticParser modelParser;
        super.handleNotificationEvent(event);
        if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
            this.refreshLabel();
        }
        if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
            this.removeSemanticListeners();
            if (this.resolveSemanticElement() != null) {
                this.addSemanticListeners();
            }
            this.refreshLabel();
        }
    }

    protected void refreshLabel() {
        View view = (View)this.getModel();
        if (view.isVisible() && view.getElement() != null && view.getElement().eResource() != null) {
            super.refreshLabel();
            this.getFigure().setToolTip(this.getLabelToolTip());
        }
    }

    protected IFigure getLabelToolTip() {
        String text = this.getToolTipText();
        if (text != null && text.length() > 0) {
            this.toolTipLabel.setText(text);
            return this.toolTipLabel;
        }
        return null;
    }

    protected String getToolTipText() {
        EObject parserElement = this.getParserElement();
        if (parserElement != null && parserElement.eResource() != null) {
            try {
                ILabelProvider labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)parserElement)).getLabelProvider();
                if (labelProvider instanceof ExtensibleLabelProvider) {
                    Method getProvider = ExtensibleLabelProvider.class.getDeclaredMethod("getProvider", Object.class);
                    getProvider.setAccessible(true);
                    Object result = getProvider.invoke((Object)labelProvider, parserElement);
                    if (result instanceof ICustomizedToolTipLabelProvider) {
                        return ((ICustomizedToolTipLabelProvider)result).getToolTipText((Object)parserElement, null);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | ServiceException e) {
                Activator.log.error(e);
            }
        }
        return null;
    }
}

