/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrus.uml.tools.listeners.StereotypeElementListener;
import org.eclipse.papyrusrt.umlrt.core.utils.CodeSnippetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MultipleAdapter;
import org.eclipse.papyrusrt.umlrt.core.utils.StateMachineUtils;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.RTGuard;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.views.codesnippet.tabs.AbstractCodeSnippetTab;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTrigger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;

public class TriggerGuardTab
extends AbstractCodeSnippetTab {
    private TriggerGuardAdapter guardAdapter;

    @Override
    public String getTitle() {
        return "Trigger Guard";
    }

    @Override
    public Image getImage() {
        Trigger trigger;
        Constraint guard;
        if (this.shouldShowThisTab(this.input) && (guard = CodeSnippetUtils.getTriggerGuard((Trigger)(trigger = (Trigger)this.input))) != null) {
            return this.getLabelProvider().getImage((Object)guard);
        }
        return Activator.getImage((String)"obj16_guard");
    }

    @Override
    public boolean shouldShowThisTab(EObject context) {
        if (context instanceof Trigger) {
            Transition transition = (Transition)context.eContainer();
            StateMachine sm = transition.containingStateMachine();
            return StateMachineUtils.isRTStateMachine((StateMachine)sm);
        }
        return false;
    }

    @Override
    protected IObservable getFeatureObservable() {
        Transition transition = (Transition)this.input.eContainer();
        if (this.meForFeatureObservable == null) {
            this.meForFeatureObservable = this.rtModelFactory.createFromSource((Object)transition, null);
        }
        IObservable observable = this.meForFeatureObservable.getObservable("ownedRule");
        observable.addChangeListener(event -> {
            IObservableList list = (IObservableList)event.getObservable();
            for (Constraint c : list) {
                c.eAdapters().add((Object)this.getGuardListener());
            }
        });
        return observable;
    }

    @Override
    protected ExpressionList getExpressionObservableList() {
        Trigger trigger = (Trigger)this.input;
        Constraint guard = CodeSnippetUtils.getTriggerGuard((Trigger)trigger);
        if (guard != null) {
            return this.getExpressionList((EObject)guard.getSpecification());
        }
        return null;
    }

    @Override
    protected void saveInitialExpression(ExpressionList.Expression ex) {
        UMLRTTrigger trigger = UMLRTFactory.createTrigger((Trigger)((Trigger)this.input));
        trigger.createGuard(ex.getLanguage(), ex.getBody());
    }

    @Override
    protected IObservable getSpecificationObservable() {
        Trigger trigger = (Trigger)this.input;
        Constraint guard = CodeSnippetUtils.getTriggerGuard((Trigger)trigger);
        return this.getSpecificationObservable((EObject)guard);
    }

    private TriggerGuardAdapter getGuardListener() {
        if (this.guardAdapter == null) {
            this.guardAdapter = new TriggerGuardAdapter();
        }
        return this.guardAdapter;
    }

    @Override
    public void dispose() {
        if (this.guardAdapter != null) {
            this.guardAdapter.dispose();
        }
        super.dispose();
    }

    private class TriggerGuardAdapter
    extends MultipleAdapter {
        TriggerGuardAdapter() {
            super(1);
        }

        public void notifyChanged(Notification notification) {
            if (!notification.isTouch()) {
                Object value = notification.getNewValue();
                if (notification instanceof StereotypeElementListener.StereotypeExtensionNotification && value instanceof RTGuard) {
                    TriggerGuardTab.this.updateExpressionObservableList();
                    TriggerGuardTab.this.refresh();
                }
            }
        }
    }
}

