/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToIntFunction;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.impl.InternalUMLRTElement;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Element;

public enum UMLRTInheritanceKind implements Enumerator
{
    INHERITED(0, "inherited", "inherited"),
    REDEFINED(1, "redefined", "redefined"),
    EXCLUDED(2, "excluded", "excluded"),
    NONE(3, "none", "none");

    public static final int INHERITED_VALUE = 0;
    public static final int REDEFINED_VALUE = 1;
    public static final int EXCLUDED_VALUE = 2;
    public static final int NONE_VALUE = 3;
    private static final UMLRTInheritanceKind[] VALUES_ARRAY;
    public static final List<UMLRTInheritanceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UMLRTInheritanceKind[]{INHERITED, REDEFINED, EXCLUDED, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UMLRTInheritanceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UMLRTInheritanceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UMLRTInheritanceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UMLRTInheritanceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UMLRTInheritanceKind get(int value) {
        switch (value) {
            case 0: {
                return INHERITED;
            }
            case 1: {
                return REDEFINED;
            }
            case 2: {
                return EXCLUDED;
            }
            case 3: {
                return NONE;
            }
        }
        return null;
    }

    private UMLRTInheritanceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public static UMLRTInheritanceKind of(Element element) {
        UMLRTInheritanceKind result = NONE;
        if (UMLRTExtensionUtil.isInherited(element)) {
            result = UMLRTExtensionUtil.isExcluded(element) ? EXCLUDED : (UMLRTExtensionUtil.isVirtualElement(element) ? INHERITED : REDEFINED);
        }
        return result;
    }

    public static UMLRTInheritanceKind of(UMLRTNamedElement element) {
        return UMLRTInheritanceKind.nullSafe(element.getInheritanceKind());
    }

    static UMLRTInheritanceKind nullSafe(UMLRTInheritanceKind kind) {
        return kind == null ? NONE : kind;
    }

    public static Comparator<Element> comparator() {
        Comparator<Element> firstStage = Comparator.comparing(UMLRTInheritanceKind::of);
        return firstStage.thenComparing(UMLRTInheritanceKind.byInheritanceDepth());
    }

    public static Comparator<UMLRTNamedElement> facadeComparator() {
        return Comparator.comparing(UMLRTNamedElement::toUML, UMLRTInheritanceKind.comparator());
    }

    private static Comparator<Element> byInheritanceDepth() {
        return Comparator.comparingInt(UMLRTInheritanceKind.inheritanceDepth());
    }

    private static ToIntFunction<Element> inheritanceDepth() {
        return element -> {
            int result = 0;
            if (UMLRTExtensionUtil.isVirtualElement(element)) {
                InternalUMLRTElement rt = (InternalUMLRTElement)element;
                try {
                    result = -UMLRTInheritanceKind.inheritanceDepth(rt, 0);
                }
                catch (IllegalStateException illegalStateException) {}
            }
            return result;
        };
    }

    private static int inheritanceDepth(InternalUMLRTElement element, int depthSoFar) {
        int count = 0;
        Object rt = element.rtGetRedefinedElement();
        while (rt != null) {
            ++depthSoFar;
            if (++count > 100000) {
                return UMLRTInheritanceKind.inheritanceDepth(rt, depthSoFar);
            }
            if (rt == element) {
                throw new IllegalStateException("Redefinition cycle including " + rt);
            }
            rt = rt.rtGetRedefinedElement();
        }
        return depthSoFar;
    }

    public String toString() {
        return this.literal;
    }
}

