/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Name;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberFunction;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.AbstractFunctionCall;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class MemberFunctionCall
extends AbstractFunctionCall {
    private final Impl receiver;
    private final MemberFunction function;

    public MemberFunctionCall(Expression container, MemberFunction function) {
        super(new Expression[0]);
        this.receiver = new Expr(container);
        this.function = function;
    }

    public MemberFunctionCall(NamedElement element, MemberFunction function) {
        super(new Expression[0]);
        this.receiver = new QualName(element);
        this.function = function;
    }

    @Override
    protected Type createType() {
        return this.function.getReturnType();
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        return this.receiver.addDependencies(deps) && deps.add(new ElementDependency(this.function)) && super.addDependencies(deps);
    }

    @Override
    public boolean write(CppFormatter fmt) {
        return this.receiver.write(fmt) && fmt.write(this.function.getName().getIdentifier()) && super.write(fmt);
    }

    private class Expr
    implements Impl {
        private final Expression receiver;

        public Expr(Expression receiver) {
            this.receiver = receiver;
        }

        @Override
        public boolean addDependencies(DependencyList deps) {
            return this.receiver.addDependencies(deps);
        }

        @Override
        public boolean write(CppFormatter fmt) {
            return this.receiver.write(fmt, MemberFunctionCall.this) && fmt.write(this.receiver.getType().isIndirect() ? "->" : ".");
        }
    }

    private static interface Impl {
        public boolean addDependencies(DependencyList var1);

        public boolean write(CppFormatter var1);
    }

    private static class QualName
    implements Impl {
        private final NamedElement element;
        private final Name receiver;

        public QualName(NamedElement element) {
            this.element = element;
            this.receiver = element.getName();
        }

        @Override
        public boolean addDependencies(DependencyList deps) {
            return this.element.getType().addDependencies(deps);
        }

        @Override
        public boolean write(CppFormatter fmt) {
            return fmt.write(this.receiver) && fmt.write("::");
        }
    }
}

