/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrusrt.umlrt.core.commands.ExcludeDependentsRequest;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.advice.IInheritanceEditHelperAdvice;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnector;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTReplicatedElement;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Property;

public class RTConnectorEditHelperAdvice
extends AbstractEditHelperAdvice
implements IInheritanceEditHelperAdvice {
    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
        return super.getBeforeCreateCommand(request);
    }

    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof ReorientRelationshipRequest) {
            EObject relationship = ((ReorientRelationshipRequest)request).getRelationship();
            if (ElementTypeUtils.matches(relationship, "org.eclipse.papyrusrt.umlrt.core.RTConnector").booleanValue()) {
                Connector connector = (Connector)relationship;
                EObject target = ((ReorientRelationshipRequest)request).getNewRelationshipEnd();
                View targetView = (View)request.getParameter("RECONNECT_END_VIEW");
                if (targetView != null && targetView.eContainer() != null) {
                    EObject partWithTargetPort = ((View)targetView.eContainer()).getElement();
                    EObject oldEnd = ((ReorientRelationshipRequest)request).getOldRelationshipEnd();
                    ConnectableElement source = ((ConnectorEnd)connector.getEnds().get(0)).getRole();
                    Property partWithSourcePort = ((ConnectorEnd)connector.getEnds().get(0)).getPartWithPort();
                    if (oldEnd.equals(source)) {
                        source = ((ConnectorEnd)connector.getEnds().get(1)).getRole();
                        partWithSourcePort = ((ConnectorEnd)connector.getEnds().get(1)).getPartWithPort();
                    }
                    return this.canConnect((EObject)source, (EObject)partWithSourcePort, target, partWithTargetPort);
                }
            }
            return super.approveRequest(request);
        }
        if (request instanceof GetEditContextRequest && ((GetEditContextRequest)request).getEditCommandRequest() instanceof CreateRelationshipRequest) {
            CreateRelationshipRequest editRequest = (CreateRelationshipRequest)((GetEditContextRequest)request).getEditCommandRequest();
            View targetView = (View)editRequest.getParameter("TARGET_GRAPHICAL_VIEW");
            View sourceView = (View)editRequest.getParameter("SOURCE_GRAPHICAL_VIEW");
            if (sourceView != null && sourceView.eContainer() != null && targetView != null && targetView.eContainer() != null) {
                EObject partWithSourcePort = ((View)sourceView.eContainer()).getElement();
                EObject partWithTargetPort = ((View)targetView.eContainer()).getElement();
                return this.canConnect(editRequest.getSource(), partWithSourcePort, editRequest.getTarget(), partWithTargetPort);
            }
        }
        return super.approveRequest(request);
    }

    protected boolean canConnect(EObject source, EObject partWithSourcePort, EObject target, EObject partWithTargetPort) {
        if (source == target || !this.checkEnd(source) || !this.checkEnd(target)) {
            return false;
        }
        if ((partWithSourcePort == null || !ElementTypeUtils.matches(partWithSourcePort, "org.eclipse.papyrusrt.umlrt.core.CapsulePart").booleanValue()) && ElementTypeUtils.matches(source, "org.eclipse.papyrusrt.umlrt.core.ExternalBehaviorPort").booleanValue()) {
            return false;
        }
        return partWithTargetPort != null && ElementTypeUtils.matches(partWithTargetPort, "org.eclipse.papyrusrt.umlrt.core.CapsulePart") != false || ElementTypeUtils.matches(target, "org.eclipse.papyrusrt.umlrt.core.ExternalBehaviorPort") == false;
    }

    protected boolean checkEnd(EObject newEnd) {
        if (newEnd != null && ElementTypeUtils.matches(newEnd, "org.eclipse.papyrusrt.umlrt.core.RTPort").booleanValue()) {
            if (ElementTypeUtils.matches(newEnd, "org.eclipse.papyrusrt.umlrt.core.ServiceAccessPoint").booleanValue()) {
                return false;
            }
            return ElementTypeUtils.matches(newEnd, "org.eclipse.papyrusrt.umlrt.core.ServiceProvisionPoint") == false;
        }
        return false;
    }

    protected ICommand getBeforeReorientRelationshipCommand(ReorientRelationshipRequest request) {
        return super.getBeforeReorientRelationshipCommand(request);
    }

    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        ICommand result = this.getInheritanceEditCommand(request);
        if (result == null) {
            result = super.getBeforeEditCommand(request);
        }
        return result;
    }

    @Override
    public ICommand getExcludeDependentsCommand(ExcludeDependentsRequest request) {
        ICommand excludeConnectors;
        List connectablesToReinherit;
        UMLRTConnector connector;
        ICommand result = IInheritanceEditHelperAdvice.super.getExcludeDependentsCommand(request);
        if (!request.isExclude() && request.getElementToExclude() instanceof Connector && (connector = UMLRTConnector.getInstance((Connector)((Connector)request.getElementToExclude()))) != null && !(connectablesToReinherit = Stream.of(connector.getSource(), connector.getSourcePartWithPort(), connector.getTarget(), connector.getTargetPartWithPort()).filter(Objects::nonNull).filter(UMLRTNamedElement::isExcluded).map(UMLRTReplicatedElement::toUML).collect(Collectors.toList())).isEmpty() && (excludeConnectors = request.getExcludeDependentsCommand(connectablesToReinherit)) != null) {
            result = CompositeCommand.compose((ICommand)result, (ICommand)excludeConnectors);
        }
        return result;
    }
}

