/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editpolicies;

import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.uml.diagram.composite.custom.edit.policies.CustomDiagramDragDropEditPolicy;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IRTPortEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.RTPropertyPartEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTPortPositionLocator;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RTCustomDiagramDragDropEditPolicy
extends CustomDiagramDragDropEditPolicy {
    protected Command dropAffixedNode(DropObjectsRequest dropRequest, Element droppedElement, String nodeVISUALID) {
        if (!(droppedElement instanceof Port)) {
            Activator.log.error((Throwable)new Exception("Incorrect parameter type (droppedElement should be a Port or Parameter)"));
            return UnexecutableCommand.INSTANCE;
        }
        Boolean isCompartmentTarget = false;
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        Point dropLocation = dropRequest.getLocation().getCopy();
        if (graphicalParentEditPart instanceof ShapeCompartmentEditPart) {
            isCompartmentTarget = true;
            graphicalParentEditPart = (GraphicalEditPart)graphicalParentEditPart.getParent();
            Point targetLocation = graphicalParentEditPart.getContentPane().getBounds().getLocation();
            ShapeCompartmentFigure compartmentFigure = (ShapeCompartmentFigure)this.getHostFigure();
            Viewport compartmentViewPort = compartmentFigure.getScrollPane().getViewport();
            Point compartmentViewPortLocation = compartmentViewPort.getLocation();
            Point compartmentViewPortViewLocation = compartmentViewPort.getViewLocation();
            Point delta = compartmentViewPortLocation.translate(targetLocation.negate());
            delta = delta.translate(compartmentViewPortViewLocation.negate());
            dropLocation = dropRequest.getLocation().getTranslated(delta);
        }
        graphicalParentEditPart.getFigure().getBounds().getLocation().getCopy();
        boolean isPortOnPart = graphicalParentEditPart instanceof RTPropertyPartEditPart;
        RTPortPositionLocator locator = new RTPortPositionLocator(droppedElement, graphicalParentEditPart.getFigure(), 0, IRTPortEditPart.getDefaultScaleFactor(isPortOnPart));
        Rectangle proposedBounds = new Rectangle(dropLocation, IRTPortEditPart.getDefaultSize(isPortOnPart));
        Rectangle preferredBounds = locator.getPreferredLocation(proposedBounds);
        if (preferredBounds != null) {
            dropLocation = preferredBounds.getLocation();
            EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
            if (graphicalParentObject instanceof EncapsulatedClassifier && ((EncapsulatedClassifier)graphicalParentObject).getAllAttributes().contains((Object)droppedElement)) {
                if (isCompartmentTarget.booleanValue()) {
                    return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
                }
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
            }
            if (graphicalParentObject instanceof Property && UMLUtil.getStereotypeApplication((Element)((Property)graphicalParentObject), CapsulePart.class) != null) {
                if (isCompartmentTarget.booleanValue()) {
                    return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
                }
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
            }
            if (graphicalParentObject instanceof ConnectableElement) {
                Type type = ((ConnectableElement)graphicalParentObject).getType();
                if (type != null && type instanceof EncapsulatedClassifier && ((EncapsulatedClassifier)type).getAllAttributes().contains((Object)droppedElement)) {
                    if (isCompartmentTarget.booleanValue()) {
                        return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
                    }
                    return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
                }
            } else if (graphicalParentObject instanceof Behavior && ((Behavior)graphicalParentObject).getOwnedParameters().contains((Object)droppedElement)) {
                if (isCompartmentTarget.booleanValue()) {
                    return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
                }
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
            }
        }
        return UnexecutableCommand.INSTANCE;
    }
}

