/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;

public abstract class AbstractInheritanceEditPolicy<V extends View>
extends GraphicalEditPolicyEx {
    public static final String INHERITANCE_ROLE = "umlrtInheritance";
    private final Class<V> viewType;
    private final NotificationPreCommitListener redefinedViewListener;
    private final CopyOnWriteArrayList<EObject> listeningTo = new CopyOnWriteArrayList();
    private V redefinedView;
    private volatile Future<?> pendingRefresh;

    public AbstractInheritanceEditPolicy(Class<V> viewType) {
        this.viewType = viewType;
        this.redefinedViewListener = this::redefinedViewChanged;
    }

    IInheritableEditPart inheritableHost() {
        return (IInheritableEditPart)this.getHost();
    }

    boolean isInherited() {
        return this.getRedefinedElementView() != null;
    }

    public void deactivate() {
        this.setRedefinedElementView(null);
        super.deactivate();
    }

    V getRedefinedElementView() {
        return this.redefinedView;
    }

    private void setRedefinedElementView(V newRedefinedView) {
        if (this.redefinedView != newRedefinedView) {
            if (this.redefinedView != null) {
                this.getEventBroker().ifPresent(this::removeUpdateListeners);
            }
            this.redefinedView = newRedefinedView;
            if (this.redefinedView != null) {
                this.getEventBroker().ifPresent(this::addUpdateListeners);
            }
        }
    }

    protected final void addUpdateListeners(DiagramEventBroker broker) {
        V redefined = this.getRedefinedElementView();
        this.listen(broker, (EObject)redefined);
        EContentsEList.FeatureIterator iter = (EContentsEList.FeatureIterator)redefined.eContents().iterator();
        while (iter.hasNext()) {
            EObject next = (EObject)iter.next();
            if (!this.shouldListen(redefined, (EReference)iter.feature())) continue;
            this.listen(broker, next);
        }
    }

    protected abstract boolean shouldListen(V var1, EReference var2);

    private boolean listen(DiagramEventBroker broker, EObject object) {
        boolean result = this.listeningTo.addIfAbsent(object);
        if (result) {
            broker.addNotificationListener(object, this.redefinedViewListener);
        }
        return result;
    }

    private boolean unlisten(DiagramEventBroker broker, EObject object) {
        boolean result = this.listeningTo.remove(object);
        if (result) {
            broker.removeNotificationListener(object, this.redefinedViewListener);
        }
        return result;
    }

    protected final void removeUpdateListeners(DiagramEventBroker broker) {
        this.listeningTo.forEach(e -> broker.removeNotificationListener(e, this.redefinedViewListener));
        this.listeningTo.clear();
    }

    protected final Command redefinedViewChanged(Notification msg) {
        Command refresh;
        Object feature;
        V redefined;
        if (!this.checkInheritance()) {
            return null;
        }
        CompoundCommand result = new CompoundCommand();
        EObject notifier = (EObject)msg.getNotifier();
        if ((notifier == (redefined = this.getRedefinedElementView()) || notifier.eContainer() == redefined) && (feature = msg.getFeature()) instanceof EReference) {
            EReference reference = (EReference)feature;
            V view = this.getRedefinedElementView();
            if (reference.isContainment() && this.shouldListen(view, reference)) {
                DiagramEventBroker broker = this.getEventBroker().get();
                Consumer<EObject> processNew = added -> {
                    Command refresh;
                    if (this.listen(broker, (EObject)added) && (refresh = this.update(view, (EObject)added, reference, msg.getPosition(), false)) != null) {
                        result.append(refresh);
                    }
                };
                Consumer<EObject> processOld = removed -> {
                    Command refresh;
                    if (this.unlisten(broker, (EObject)removed) && (refresh = this.update(view, (EObject)removed, reference, msg.getPosition(), true)) != null) {
                        result.append(refresh);
                    }
                };
                switch (msg.getEventType()) {
                    case 3: {
                        processNew.accept((EObject)msg.getNewValue());
                        break;
                    }
                    case 5: {
                        ((Collection)msg.getNewValue()).forEach(processNew);
                        break;
                    }
                    case 4: {
                        processOld.accept((EObject)msg.getOldValue());
                        break;
                    }
                    case 6: {
                        ((Collection)msg.getOldValue()).forEach(processOld);
                        break;
                    }
                    case 1: {
                        processOld.accept((EObject)msg.getOldValue());
                        processNew.accept((EObject)msg.getNewValue());
                    }
                }
            }
        }
        if ((refresh = this.update(notifier)) != null) {
            result.append(refresh);
        }
        if (result.canExecute()) {
            this.postRefresh();
        }
        return result.isEmpty() ? null : result.unwrap();
    }

    protected Command update(V redefinedView, EObject contained, EReference containment, int position, boolean isRemoved) {
        Command result = null;
        V view = this.getView();
        if (isRemoved) {
            if (!containment.isMany()) {
                EObject myContained = (EObject)view.eGet((EStructuralFeature)containment);
                if (myContained != null) {
                    result = RemoveCommand.create((EditingDomain)this.getEditingDomain(), view, (Object)containment, (Object)myContained);
                }
            } else {
                EList myList = (EList)view.eGet((EStructuralFeature)containment);
                if (position >= 0 && position < myList.size()) {
                    result = RemoveCommand.create((EditingDomain)this.getEditingDomain(), view, (Object)containment, (Object)myList.get(position));
                }
            }
        } else if (!containment.isMany()) {
            EObject myContained = (EObject)view.eGet((EStructuralFeature)containment);
            EObject newContained = EcoreUtil.copy((EObject)contained);
            result = myContained != null ? SetCommand.create((EditingDomain)this.getEditingDomain(), view, (Object)containment, (Object)newContained) : AddCommand.create((EditingDomain)this.getEditingDomain(), view, (Object)containment, (Object)newContained);
        } else {
            EList myList = (EList)view.eGet((EStructuralFeature)containment);
            if (position >= 0 && position <= myList.size()) {
                EObject newContained = EcoreUtil.copy((EObject)contained);
                result = AddCommand.create((EditingDomain)this.getEditingDomain(), view, (Object)containment, (Object)newContained, (int)position);
            }
        }
        return result;
    }

    protected abstract Command update(EObject var1);

    private boolean checkInheritance() {
        this.setRedefinedElementView(this.computeRedefinedElementView());
        return this.isInherited();
    }

    private V computeRedefinedElementView() {
        return (V)(!this.inheritableHost().isInherited() ? null : (View)this.viewType.cast(this.inheritableHost().getRedefinedView()));
    }

    private Optional<DiagramEventBroker> getEventBroker() {
        return Optional.ofNullable(((IGraphicalEditPart)this.getHost()).getEditingDomain()).map(DiagramEventBroker::getInstance);
    }

    public org.eclipse.gef.commands.Command getCommand(Request request) {
        org.eclipse.gef.commands.Command reifyView;
        org.eclipse.gef.commands.Command result = super.getCommand(request);
        if (this.isInherited() && this.isVisualEdit(request) && (reifyView = this.inheritableHost().getReifyViewCommand()) != null) {
            result = result != null ? reifyView.chain(result) : reifyView;
        }
        return result;
    }

    protected abstract boolean isVisualEdit(Request var1);

    public void refresh() {
        this.checkInheritance();
        if (this.isInherited()) {
            this.refreshInheritance();
        }
        super.refresh();
    }

    protected final void refreshInheritance() {
        CompoundCommand refresh = new CompoundCommand();
        this.listeningTo.forEach(e -> {
            Command update = this.update((EObject)e);
            if (update != null) {
                refresh.append(update);
            }
        });
        if (refresh.canExecute()) {
            CommandUtil.executeUnsafeCommand((Command)refresh.unwrap(), (Object)this.getHost());
        }
    }

    V getView() {
        IGraphicalEditPart host = (IGraphicalEditPart)this.getHost();
        return (V)((View)this.viewType.cast(host.getNotationView()));
    }

    Optional<UMLRTNamedElement> getUMLRTElement() {
        return this.inheritableHost().getUMLRTElement();
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    private void postRefresh() {
        if (this.pendingRefresh == null) {
            final EditPart toRefresh = this.getHost();
            this.pendingRefresh = DiagramHelper.submit((EditPart)toRefresh, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    AbstractInheritanceEditPolicy.this.pendingRefresh = null;
                    if (toRefresh.isActive()) {
                        DiagramHelper.scheduleRefresh((DiagramEditPart)DiagramEditPartsUtil.getDiagramEditPart((EditPart)toRefresh));
                    }
                    return null;
                }
            });
        }
    }
}

