/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.canonical.editpolicy.PapyrusCanonicalEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Element;

public class PapyrusRTCanonicalEditPolicy
extends PapyrusCanonicalEditPolicy {
    public EObject getSemanticHost() {
        IGraphicalEditPart host = this.host();
        if (host instanceof ShapeCompartmentEditPart && host.getParent() instanceof IGraphicalEditPart) {
            host = (IGraphicalEditPart)host.getParent();
        }
        return host.resolveSemanticElement();
    }

    protected CreateRequest createCreateRequest(CreateViewRequest.ViewDescriptor viewDescriptor) {
        CreateRequest result = super.createCreateRequest(viewDescriptor);
        Map extendedData = result.getExtendedData();
        extendedData.put("Canonical", true);
        return result;
    }

    protected List<IAdaptable> refreshSemanticChildren(PapyrusCanonicalEditPolicy.ChildrenKind kind) {
        if (this.resolveSemanticElement() != null && this.isInState(PapyrusCanonicalEditPolicy.State.ACTIVE)) {
            List viewChildren = this.getViewChildren(kind);
            List semanticChildren = this.getSemanticChildrenList(kind);
            if (!viewChildren.isEmpty() && !semanticChildren.isEmpty()) {
                this.adjustSemanticElements(viewChildren, semanticChildren);
            }
        }
        return super.refreshSemanticChildren(kind);
    }

    protected void adjustSemanticElements(List<? extends View> visualChildren, List<? extends EObject> semanticChildren) {
        Element element;
        HashMap<Element, View> problems = new HashMap<Element, View>();
        for (View view : visualChildren) {
            EObject semantic;
            if (!view.isSetElement() || !((semantic = view.getElement()) instanceof Element) || !UMLRTExtensionUtil.isInherited((Element)(element = (Element)semantic)) || this.isDiagramElement((EObject)element, view)) continue;
            problems.put(UMLRTExtensionUtil.getRootDefinition((Element)element), view);
        }
        if (!problems.isEmpty()) {
            HashMap<View, Element> hashMap = new HashMap<View, Element>();
            for (EObject eObject : semanticChildren) {
                View toFix;
                if (!(eObject instanceof Element) || (toFix = (View)problems.remove(element = (Element)eObject)) == null) continue;
                hashMap.put(toFix, element);
            }
            if (!hashMap.isEmpty()) {
                CommandUtil.executeUnsafeCommand(() -> fixup.entrySet().forEach(e -> ((View)e.getKey()).setElement((EObject)e.getValue())), (Object)this.host());
            }
        }
    }

    private boolean isDiagramElement(EObject semantic, View view) {
        Diagram diagram = view.getDiagram();
        return diagram != null && diagram.getElement() == semantic;
    }
}

