/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.stereotype;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.stereotype.RTAppliedStereotypeCommentEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTCapsuleStructureDiagramUtils;
import org.eclipse.uml2.common.util.CacheAdapter;

public class RTAppliedStereotypeEditPolicyProvider
extends AbstractProvider
implements IEditPolicyProvider {
    private final Map<String, Class<? extends EditPolicy>> editPolicies = ImmutableMap.of((Object)"AppliedStereotypeComment", RTAppliedStereotypeCommentEditPolicy.class);

    public boolean provides(IOperation operation) {
        Diagram diagram = this.getDiagramView(((CreateEditPoliciesOperation)operation).getEditPart());
        return diagram != null && this.isCapsuleStructureDiagram(diagram);
    }

    public void createEditPolicies(EditPart editPart) {
        this.editPolicies.forEach((role, epClass) -> {
            EditPolicy existing = editPart.getEditPolicy(role);
            if (existing != null) {
                try {
                    editPart.installEditPolicy(role, (EditPolicy)epClass.newInstance());
                }
                catch (Exception e) {
                    Activator.log.error("Failed to override edit policy: " + role, (Throwable)e);
                }
            }
        });
    }

    Diagram getDiagramView(EditPart editPart) {
        DiagramEditPart diagramEP = DiagramEditPartsUtil.getDiagramEditPart((EditPart)editPart);
        return diagramEP == null ? null : diagramEP.getDiagramView();
    }

    private boolean isCapsuleStructureDiagram(Diagram diagram) {
        CacheAdapter cache = CacheAdapter.getCacheAdapter((Notifier)diagram);
        Boolean result = (Boolean)cache.get((EObject)diagram, (Object)"isCapsuleStructureDiagram");
        if (result == null) {
            result = UMLRTCapsuleStructureDiagramUtils.isCapsuleStructureDiagram(diagram);
            cache.put((EObject)diagram, (Object)"isCapsuleStructureDiagram", (Object)result);
        }
        return result;
    }
}

