/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.properties.widget;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractResourceUndoContextPolicy;
import org.eclipse.emf.workspace.IResourceUndoContextPolicy;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultRowSelectionLayerConfiguration;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.nattable.layer.PapyrusGridLayer;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NamedStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.properties.widgets.NattablePropertyEditor;
import org.eclipse.papyrusrt.umlrt.tooling.properties.providers.RTNattableRowDataProvider;
import org.eclipse.papyrusrt.umlrt.tooling.tables.internal.handlers.RTTransactionalEditCellCommandHandler;
import org.eclipse.swt.widgets.Composite;

public class RTNatTablePropertyEditor
extends NattablePropertyEditor {
    public RTNatTablePropertyEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected ServicesRegistry createServiceRegistry(EObject sourceElement) throws Exception {
        ServicesRegistry result = super.createServiceRegistry(sourceElement);
        TransactionalEditingDomain domain = (TransactionalEditingDomain)result.getService(TransactionalEditingDomain.class);
        CommandStack stack = domain.getCommandStack();
        if (stack instanceof IWorkspaceCommandStack) {
            MethodHandle policySetter = MethodHandles.publicLookup().findVirtual(stack.getClass(), "setResourceUndoContextPolicy", MethodType.methodType(Void.TYPE, IResourceUndoContextPolicy.class));
            AbstractResourceUndoContextPolicy policy = new AbstractResourceUndoContextPolicy(){

                protected boolean pessimisticCrossReferences() {
                    return false;
                }
            };
            try {
                policySetter.invoke(stack, (IResourceUndoContextPolicy)policy);
            }
            catch (Error e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        return result;
    }

    protected NatTable createNatTableWidget(INattableModelManager manager, Composite parent, int style, Collection<?> rows) {
        TransactionalEditingDomain domain;
        Command fillColumnsCommand;
        NatTable result = super.createNatTableWidget(manager, parent, style, rows);
        GridLayer grid = (GridLayer)TypeUtils.as((Object)(result == null ? null : result.getLayer()), GridLayer.class);
        if (grid != null) {
            this.replaceEditCellCommandHandler(manager, grid);
        }
        if ((fillColumnsCommand = RTNatTablePropertyEditor.getSetFillColumnTableStyleCommand(domain = this.getTableEditingDomain(), manager.getTable())).canExecute()) {
            domain.getCommandStack().execute(fillColumnsCommand);
        }
        if (manager instanceof NattableModelManager) {
            SelectionLayer selectionLayer = manager.getBodyLayerStack().getSelectionLayer();
            RTNattableRowDataProvider rowDataProvider = new RTNattableRowDataProvider((NattableModelManager)manager);
            IRowIdAccessor<Object> rowIdAccessor = new IRowIdAccessor<Object>(){

                public Serializable getRowId(Object rowObject) {
                    return Integer.valueOf(rowObject.hashCode());
                }
            };
            selectionLayer.setSelectionModel((ISelectionModel)new RowSelectionModel(selectionLayer, (IRowDataProvider)rowDataProvider, (IRowIdAccessor)rowIdAccessor, false));
            selectionLayer.addConfiguration((IConfiguration)new DefaultRowSelectionLayerConfiguration());
        }
        return result;
    }

    private static final Command getSetFillColumnTableStyleCommand(TransactionalEditingDomain domain, final Table table) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                NamedStyle fillColumnsSizeStyle = table.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "fillColumnsSize");
                if (fillColumnsSizeStyle == null) {
                    fillColumnsSizeStyle = table.createStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle());
                    ((BooleanValueStyle)fillColumnsSizeStyle).setName("fillColumnsSize");
                }
                ((BooleanValueStyle)fillColumnsSizeStyle).setBooleanValue(true);
            }
        };
    }

    private void replaceEditCellCommandHandler(INattableModelManager manager, GridLayer grid) {
        Map commandHandlers;
        if (grid instanceof PapyrusGridLayer && (commandHandlers = (Map)RTNatTablePropertyEditor.getField(grid, "commandHandlers")) != null) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)manager.getTable().getContext());
            RTTransactionalEditCellCommandHandler handler = new RTTransactionalEditCellCommandHandler(domain);
            commandHandlers.put(handler.getCommandClass(), handler);
        }
    }

    static <T> T getField(Object object, String fieldName) {
        Object result = null;
        Class<?> search = object.getClass();
        while (search != null) {
            try {
                Field field = search.getDeclaredField(fieldName);
                field.setAccessible(true);
                result = field.get(object);
                break;
            }
            catch (Exception exception) {
                search = search.getSuperclass();
            }
        }
        return (T)result;
    }
}

