/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.UserEditableRegion;
import org.eclipse.papyrusrt.codegen.cpp.AbstractElementGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.TypesUtil;
import org.eclipse.papyrusrt.codegen.cpp.internal.GeneratorUtils;
import org.eclipse.papyrusrt.codegen.cpp.profile.RTCppProperties.AttributeKind;
import org.eclipse.papyrusrt.codegen.cpp.profile.RTCppProperties.ClassKind;
import org.eclipse.papyrusrt.codegen.cpp.profile.RTCppProperties.DependencyKind;
import org.eclipse.papyrusrt.codegen.cpp.profile.RTCppProperties.InitializationKind;
import org.eclipse.papyrusrt.codegen.cpp.profile.RTCppProperties.OperationKind;
import org.eclipse.papyrusrt.codegen.cpp.profile.facade.RTCppGenerationProperties;
import org.eclipse.papyrusrt.codegen.lang.cpp.Element;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.Dependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.TypeDependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.AbstractFunction;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.BitField;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Constructor;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppClass;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.DeclarationBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.ElementList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Function;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.LinkageSpec;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Macro;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberField;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberFunction;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.PrimitiveType;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.AbstractFunctionCall;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.AddressOfExpr;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.BinaryOperation;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.BooleanLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.CharacterLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ConstructorCall;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.DereferenceExpr;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ElementAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ExpressionBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.IndexExpr;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.IntegralLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.LogicalComparison;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.MemberAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.MemberFunctionCall;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.This;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.UnaryOperation;
import org.eclipse.papyrusrt.codegen.lang.cpp.external.StandardLibrary;
import org.eclipse.papyrusrt.codegen.lang.cpp.name.FileName;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.CodeBlock;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.ConditionalStatement;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.ExpressionStatement;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.ForStatement;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.ReturnStatement;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.UserCode;
import org.eclipse.papyrusrt.xtumlrt.common.AbstractAction;
import org.eclipse.papyrusrt.xtumlrt.common.ActionCode;
import org.eclipse.papyrusrt.xtumlrt.common.Attribute;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.CommonPackage;
import org.eclipse.papyrusrt.xtumlrt.common.Entity;
import org.eclipse.papyrusrt.xtumlrt.common.Generalization;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.common.Operation;
import org.eclipse.papyrusrt.xtumlrt.common.Parameter;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.common.Type;
import org.eclipse.papyrusrt.xtumlrt.common.TypedMultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.ValueSpecification;
import org.eclipse.papyrusrt.xtumlrt.common.VisibilityKind;
import org.eclipse.papyrusrt.xtumlrt.util.QualifiedNames;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTExtensions;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;
import org.eclipse.uml2.uml.util.UMLUtil;

public class BasicClassGenerator
extends AbstractElementGenerator {
    protected final StructuredType element;
    protected final Map<Attribute, MemberField> fields = new LinkedHashMap<Attribute, MemberField>();

    public BasicClassGenerator(CppCodePattern cpp, Type element) {
        super(cpp);
        assert (element instanceof StructuredType);
        this.element = (StructuredType)element;
    }

    @Override
    protected CppCodePattern.Output getOutputKind() {
        return CppCodePattern.Output.BasicClass;
    }

    @Override
    public String getLabel() {
        return String.valueOf(super.getLabel()) + ' ' + this.element.getName();
    }

    protected CppClass.Visibility getVisibility(VisibilityKind visibility) {
        switch (visibility) {
            case PUBLIC: {
                return CppClass.Visibility.PUBLIC;
            }
            case PROTECTED: {
                return CppClass.Visibility.PROTECTED;
            }
            case PRIVATE: {
                return CppClass.Visibility.PRIVATE;
            }
        }
        return null;
    }

    protected org.eclipse.papyrusrt.codegen.lang.cpp.Type getReturnType(Operation operation) {
        TypedMultiplicityElement returnTypedElement = operation.getReturnType();
        if (returnTypedElement == null) {
            return PrimitiveType.VOID;
        }
        Type returnType = returnTypedElement.getType();
        if (returnType == null) {
            return PrimitiveType.VOID;
        }
        org.eclipse.papyrusrt.codegen.lang.cpp.Type type = TypesUtil.createCppType(this.cpp, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)operation, returnType);
        return type;
    }

    @Override
    public boolean generate() {
        if (!(this.element instanceof StructuredType)) {
            throw new RuntimeException("Element '" + QualifiedNames.cachedFullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element) + "' is not a StructuredType (Class or Capsule)");
        }
        CppClass cls = this.cpp.getWritableCppClass(CppCodePattern.Output.BasicClass, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element);
        this.generateBases(cls);
        return this.generate(cls);
    }

    protected boolean generate(CppClass cls) {
        this.generateAttributes(cls);
        this.generateOperations(cls);
        this.generateExtraDeclarations(cls);
        this.generateExtraDependencies();
        this.processRTGenerationProperties(cls);
        return true;
    }

    protected void processRTGenerationProperties(CppClass cls) {
        ClassKind structKind = RTCppGenerationProperties.getPassiveClassPropKind((CommonElement)this.element);
        if (structKind != null) {
            switch (structKind) {
                case CLASS: {
                    cls.setKind(CppClass.Kind.CLASS);
                    break;
                }
                case STRUCT: {
                    cls.setKind(CppClass.Kind.STRUCT);
                    break;
                }
                case UNION: {
                    cls.setKind(CppClass.Kind.UNION);
                    break;
                }
                case TYPEDEF: {
                    CodeGenPlugin.warning((String)("'" + QualifiedNames.cachedFullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element) + "' has 'typedef' declaration type, but this is not supported yet."));
                    break;
                }
            }
        } else if (this.element.eClass() == CommonPackage.eINSTANCE.getStructuredType()) {
            cls.setKind(CppClass.Kind.STRUCT);
        }
        Boolean genAssignmentOperatorBool = RTCppGenerationProperties.getClassGenerationPropGenerateAssignmentOperator((CommonElement)this.element);
        Boolean genCopyConstructorBool = RTCppGenerationProperties.getClassGenerationPropGenerateCopyConstructor((CommonElement)this.element);
        Boolean genDefaultConstructorBool = RTCppGenerationProperties.getClassGenerationPropGenerateDefaultConstructor((CommonElement)this.element);
        Boolean genDestructorBool = RTCppGenerationProperties.getClassGenerationPropGenerateDestructor((CommonElement)this.element);
        Boolean genEqualityOperatorBool = RTCppGenerationProperties.getClassGenerationPropGenerateEqualityOperator((CommonElement)this.element);
        Boolean genInequalityOperatorBool = RTCppGenerationProperties.getClassGenerationPropGenerateInequalityOperator((CommonElement)this.element);
        Boolean genExtractionOperatorBool = RTCppGenerationProperties.getClassGenerationPropGenerateExtractionOperator((CommonElement)this.element);
        Boolean genInsertionOperatorBool = RTCppGenerationProperties.getClassGenerationPropGenerateInsertionOperator((CommonElement)this.element);
        Boolean genStateMachineBool = RTCppGenerationProperties.getClassGenerationPropGenerateStateMachine((CommonElement)this.element);
        if (genDefaultConstructorBool != null && genDefaultConstructorBool.booleanValue()) {
            this.generateDefaultConstructor(cls);
        }
        if (genCopyConstructorBool != null && genCopyConstructorBool.booleanValue()) {
            this.generateCopyConstructor(cls);
        }
        if (genDestructorBool != null && genDestructorBool.booleanValue()) {
            this.generateDestructor(cls);
        }
        if (genAssignmentOperatorBool != null && genAssignmentOperatorBool.booleanValue()) {
            this.generateAssignmentOperator(cls);
        }
        if (genEqualityOperatorBool != null && genEqualityOperatorBool.booleanValue()) {
            this.generateEqualityOperator(cls);
        }
        if (genExtractionOperatorBool != null && genExtractionOperatorBool.booleanValue()) {
            this.generateExtractionOperator(cls);
        }
        if (genInequalityOperatorBool != null && genInequalityOperatorBool.booleanValue()) {
            this.generateInequalityOperator(cls);
        }
        if (genInsertionOperatorBool != null && genInsertionOperatorBool.booleanValue()) {
            this.generateInsertionOperator(cls);
        }
        if (genStateMachineBool != null && genStateMachineBool.booleanValue()) {
            this.generateStateMachine(cls);
        }
    }

    protected boolean generateOperations(CppClass cls) {
        for (Operation operation : this.element.getOperations()) {
            this.generate(cls, operation);
        }
        return true;
    }

    protected AbstractFunction generate(CppClass cls, Operation operation) {
        CppClass.Visibility cppVisibility = this.getVisibility(operation.getVisibility());
        if (cppVisibility == null) {
            return null;
        }
        org.eclipse.papyrusrt.codegen.lang.cpp.Type returnType = this.getReturnType(operation);
        if (returnType == null) {
            throw new RuntimeException("could not determine return type for " + operation.toString());
        }
        MemberFunction function = null;
        OperationKind opKind = RTCppGenerationProperties.getOperationPropKind((CommonElement)operation);
        if (opKind == null) {
            function = this.generateMemberFunction(cls, operation, cppVisibility, returnType);
        } else {
            switch (opKind) {
                case MEMBER: {
                    function = this.generateMemberFunction(cls, operation, cppVisibility, returnType);
                    break;
                }
                case FRIEND: {
                    function = this.generateFriendFunction(cls, operation, returnType);
                    break;
                }
                case GLOBAL: {
                    function = this.generateGlobalFunction(operation, returnType);
                    break;
                }
                default: {
                    throw new RuntimeException("Operation '" + QualifiedNames.cachedFullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)operation) + "' has an unrecognized kind: '" + opKind.toString() + "'");
                }
            }
        }
        Boolean genDefBool = RTCppGenerationProperties.getOperationPropGenDef((CommonElement)operation);
        if (genDefBool != null && !genDefBool.booleanValue()) {
            function.setOnlyDecl();
        }
        return function;
    }

    protected MemberFunction generateMemberFunction(CppClass cls, Operation operation, CppClass.Visibility cppVisibility, org.eclipse.papyrusrt.codegen.lang.cpp.Type returnType) {
        boolean isVirtual;
        MemberFunction function = new MemberFunction(returnType, operation.getName());
        this.generateParameters(operation, (AbstractFunction)function);
        this.generateBody(operation, (AbstractFunction)function);
        Boolean isInlineBool = RTCppGenerationProperties.getOperationPropInline((CommonElement)operation);
        Boolean isVirtualBool = RTCppGenerationProperties.getOperationPropPolymorphic((CommonElement)operation);
        boolean isInline = isInlineBool != null && isInlineBool != false;
        boolean bl = isVirtual = isVirtualBool != null && isVirtualBool != false;
        if (isInline) {
            function.setInline();
        }
        if (operation.isStatic()) {
            cls.addStaticMember(cppVisibility, function);
        } else {
            if (isVirtual) {
                function.setVirtual();
            }
            cls.addMember(cppVisibility, function);
        }
        if (operation.isQuery()) {
            function.setQuery();
        }
        return function;
    }

    protected Function generateFriendFunction(CppClass cls, Operation operation, org.eclipse.papyrusrt.codegen.lang.cpp.Type returnType) {
        Function function = this.generateTopLevelFunction(operation, returnType);
        cls.addFriendFunction(function);
        return function;
    }

    protected Function generateGlobalFunction(Operation operation, org.eclipse.papyrusrt.codegen.lang.cpp.Type returnType) {
        Function function = this.generateTopLevelFunction(operation, returnType);
        ElementList elementList = this.cpp.getElementList(this.getOutputKind(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element);
        if (elementList == null) {
            return function;
        }
        elementList.addElement(new IUserElement[]{function});
        return function;
    }

    protected Function generateTopLevelFunction(Operation operation, org.eclipse.papyrusrt.codegen.lang.cpp.Type returnType) {
        boolean isInline;
        LinkageSpec linkageSpec = operation.isStatic() ? LinkageSpec.STATIC : LinkageSpec.EXTERN;
        Function function = new Function(linkageSpec, returnType, operation.getName());
        this.generateParameters(operation, (AbstractFunction)function);
        this.generateBody(operation, (AbstractFunction)function);
        Boolean isInlineBool = RTCppGenerationProperties.getOperationPropInline((CommonElement)operation);
        boolean bl = isInline = isInlineBool != null && isInlineBool != false;
        if (isInline) {
            function.setInline();
        }
        return function;
    }

    protected void generateParameters(Operation operation, AbstractFunction function) {
        for (Parameter param : operation.getParameters()) {
            switch (param.getDirection()) {
                case OUT: {
                    break;
                }
                case IN: {
                    org.eclipse.papyrusrt.codegen.lang.cpp.Type type = TypesUtil.createCppType(this.cpp, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)param, param.getType());
                    function.add(new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(type, param.getName()));
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled paramater direction for " + param.toString());
                }
            }
        }
    }

    protected void generateBody(Operation operation, AbstractFunction function) {
        ActionCode code;
        AbstractAction act = operation.getBody();
        ActionCode actionCode = code = act instanceof ActionCode ? (ActionCode)act : null;
        if (code != null) {
            ArrayList<String> qNames = new ArrayList<String>();
            EObject container = operation.eContainer();
            while (container != null) {
                if (container instanceof Entity || container instanceof Package || container instanceof Model) {
                    qNames.add(0, ((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)container).getName());
                }
                container = container.eContainer();
            }
            UserEditableRegion.Label label = new UserEditableRegion.Label();
            label.setQualifiedName(String.join((CharSequence)"::", qNames));
            label.setType(operation.eClass().getName().toLowerCase());
            label.setDetails(operation.getName());
            org.eclipse.uml2.uml.Element srcElement = this.cpp.getTranslator().getSource((CommonElement)operation);
            if (srcElement != null) {
                label.setUri(srcElement.eResource().getURI().toString());
            } else {
                label.setUri(operation.eResource().getURI().toString());
            }
            StringBuilder result = new StringBuilder();
            result.append("/* " + UserEditableRegion.userEditBegin((UserEditableRegion.Label)label) + " */").append(System.lineSeparator());
            String source = code.getSource();
            if (!UMLUtil.isEmpty((String)source)) {
                result.append(source);
            }
            result.append("/* " + UserEditableRegion.userEditEnd() + " */").append(System.lineSeparator());
            function.add(new Statement[]{new UserCode(result.toString())});
        }
    }

    protected boolean generateAttributes(CppClass cls) {
        for (Attribute attr : XTUMLRTExtensions.getAllAttributes((StructuredType)this.element)) {
            this.generate(cls, attr);
        }
        return true;
    }

    protected MemberField generate(CppClass cls, Attribute attr) {
        CppClass.Visibility cppVisibility = this.getVisibility(attr.getVisibility());
        if (cppVisibility == null) {
            return null;
        }
        org.eclipse.papyrusrt.codegen.lang.cpp.Type type = TypesUtil.createCppType(this.cpp, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)attr, attr.getType());
        MemberField field = null;
        AttributeKind attrKind = RTCppGenerationProperties.getAttributePropKind((CommonElement)attr);
        if (attrKind == null) {
            field = this.generateMemberAttribute(cls, attr, cppVisibility, type, null);
        } else {
            switch (attrKind) {
                case MEMBER: 
                case MUTABLE_MEMBER: {
                    field = this.generateMemberAttribute(cls, attr, cppVisibility, type, attrKind);
                    break;
                }
                case GLOBAL: {
                    this.generateGlobalVariable(cls, attr, type);
                    break;
                }
                case DEFINE: {
                    this.generateMacroDefinition(cls, attr);
                    break;
                }
                default: {
                    throw new RuntimeException("Attribute '" + QualifiedNames.cachedFullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)attr) + "' has an unrecognized kind: '" + attrKind.toString() + "'");
                }
            }
        }
        return field;
    }

    protected void generateMacroDefinition(CppClass cls, Attribute attr) {
        ValueSpecification defVal = attr.getDefault();
        if (defVal != null) {
            String replacement = XTUMLRTUtil.getStringValue((ValueSpecification)defVal);
            if (replacement != null && !replacement.isEmpty()) {
                ElementList elementList = this.cpp.getElementList(this.getOutputKind(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element);
                if (elementList == null) {
                    return;
                }
                Macro macro = new Macro(attr.getName(), (Expression)new ExpressionBlob(replacement));
                elementList.addElement(new IUserElement[]{macro});
            }
        } else {
            CodeGenPlugin.warning((String)("Default value for macro attribute '" + QualifiedNames.cachedFullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)attr) + "' is null"));
        }
    }

    protected void generateGlobalVariable(CppClass cls, Attribute attr, org.eclipse.papyrusrt.codegen.lang.cpp.Type type) {
        ElementList elementList = this.cpp.getElementList(this.getOutputKind(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element);
        if (elementList == null) {
            return;
        }
        LinkageSpec linkageSpec = attr.isStatic() ? LinkageSpec.STATIC : LinkageSpec.UNSPECIFIED;
        Variable var = new Variable(linkageSpec, type, attr.getName());
        elementList.addElement(new IUserElement[]{var});
    }

    protected MemberField generateMemberAttribute(CppClass cls, Attribute attr, CppClass.Visibility cppVisibility, org.eclipse.papyrusrt.codegen.lang.cpp.Type type, AttributeKind attrKind) {
        MemberField field = null;
        ExpressionBlob initExpr = null;
        String sizeStr = RTCppGenerationProperties.getAttributePropSize((CommonElement)attr);
        ValueSpecification defVal = attr.getDefault();
        if (sizeStr != null && !sizeStr.trim().isEmpty()) {
            field = new BitField(type, attr.getName(), (Expression)new ExpressionBlob(sizeStr));
        } else if (defVal == null || XTUMLRTUtil.getStringValue((ValueSpecification)defVal).isEmpty()) {
            field = new MemberField(type, attr.getName());
        } else {
            String strVal = XTUMLRTUtil.getStringValue((ValueSpecification)defVal);
            initExpr = new ExpressionBlob(strVal);
            field = new MemberField(type, attr.getName(), (Expression)initExpr);
        }
        this.generateAttributeInitialization(cls, attr, field, (Expression)initExpr);
        if (attr.isStatic()) {
            cls.addStaticMember(cppVisibility, field);
        } else {
            if (!attr.isReadOnly() && attrKind == AttributeKind.MUTABLE_MEMBER) {
                field.setMutable();
            }
            cls.addMember(cppVisibility, field);
        }
        this.fields.put(attr, field);
        return field;
    }

    protected void generateBases(CppClass cls) {
        StructuredType type = this.element;
        EList generalizations = type.getGeneralizations();
        if (generalizations != null) {
            for (Generalization generalization : generalizations) {
                boolean isVirtual;
                StructuredType superType = generalization.getSuper();
                if (superType == null) continue;
                CppClass base = this.cpp.getWritableCppClass(CppCodePattern.Output.BasicClass, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)superType);
                Boolean isVirtualBool = RTCppGenerationProperties.getGeneralizationPropVirtual((CommonElement)generalization);
                boolean bl = isVirtual = isVirtualBool != null && isVirtualBool != false;
                if (isVirtual) {
                    cls.addVirtualBase(CppClass.Access.PUBLIC, (NamedElement)base);
                    continue;
                }
                cls.addBase(CppClass.Access.PUBLIC, (NamedElement)base);
            }
        }
    }

    protected void generateExtraDependencies() {
        ElementList elementList = this.cpp.getElementList(this.getOutputKind(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element);
        EList dependencies = this.element.getDependencies();
        if (dependencies != null) {
            for (org.eclipse.papyrusrt.xtumlrt.common.Dependency dependency : dependencies) {
                DependencyKind depKindInHead = RTCppGenerationProperties.getDependencyPropKindInHeader((CommonElement)dependency);
                DependencyKind depKindInImpl = RTCppGenerationProperties.getDependencyPropKindInImplementation((CommonElement)dependency);
                org.eclipse.papyrusrt.xtumlrt.common.NamedElement supplier = dependency.getSupplier();
                if (supplier == null) continue;
                Dependency cppDependencyInHead = null;
                Dependency cppDependencyInImpl = null;
                Element cppElement = this.cpp.getCppElement(supplier);
                if (cppElement == null) continue;
                if (depKindInHead == null && depKindInImpl == null) {
                    depKindInHead = DependencyKind.INCLUSION;
                }
                cppDependencyInHead = this.getDependency(cppElement, supplier, depKindInHead);
                cppDependencyInImpl = this.getDependency(cppElement, supplier, depKindInImpl);
                if (cppDependencyInHead != null) {
                    elementList.addDeclDependency(cppDependencyInHead);
                }
                if (cppDependencyInImpl == null) continue;
                elementList.addDefnDependency(cppDependencyInImpl);
            }
        }
    }

    protected Dependency getDependency(Element cppElement, org.eclipse.papyrusrt.xtumlrt.common.NamedElement supplier, DependencyKind kind) {
        if (kind == null) {
            return null;
        }
        Object cppDependency = null;
        cppDependency = supplier instanceof Type ? new TypeDependency(cppElement.getType()) : new ElementDependency(cppElement);
        switch (kind) {
            case FORWARD_REFERENCE: {
                cppDependency.setKind(Dependency.Kind.Reference);
                break;
            }
            case INCLUSION: {
                cppDependency.setKind(Dependency.Kind.Use);
                break;
            }
            default: {
                cppDependency.setKind(Dependency.Kind.None);
            }
        }
        return cppDependency;
    }

    protected void generateExtraDeclarations(CppClass cls) {
        String privDecl = RTCppGenerationProperties.getClassPropPrivateDeclarations((CommonElement)this.element);
        String protDecl = RTCppGenerationProperties.getClassPropProtectedDeclarations((CommonElement)this.element);
        String publDecl = RTCppGenerationProperties.getClassPropPublicDeclarations((CommonElement)this.element);
        if (privDecl != null && !privDecl.trim().isEmpty()) {
            cls.addDeclarationBlob(CppClass.Visibility.PRIVATE, new DeclarationBlob(privDecl));
        }
        if (protDecl != null && !protDecl.trim().isEmpty()) {
            cls.addDeclarationBlob(CppClass.Visibility.PROTECTED, new DeclarationBlob(protDecl));
        }
        if (publDecl != null && !publDecl.trim().isEmpty()) {
            cls.addDeclarationBlob(CppClass.Visibility.PUBLIC, new DeclarationBlob(publDecl));
        }
    }

    protected void generateAssignmentOperator(CppClass cls) {
        MemberFunction func = new MemberFunction(cls.getType().ref(), AbstractFunction.OverloadedOperator.ASSIGNMENT);
        org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter param = new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(cls.getType().const_().ref(), "other");
        func.add(param);
        LogicalComparison condition = new LogicalComparison((Expression)new AddressOfExpr((Expression)new ElementAccess((NamedElement)param)), LogicalComparison.Operator.EQUIVALENT, (Expression)new This(cls));
        ConditionalStatement cond = new ConditionalStatement();
        CodeBlock codeBlock = cond.add((Expression)condition);
        codeBlock.add(new Statement[]{new ReturnStatement((Expression)new DereferenceExpr((Expression)new This(cls)))});
        func.add(new Statement[]{cond});
        StructuredType type = this.element;
        EList generalizations = type.getGeneralizations();
        if (generalizations != null) {
            for (Generalization generalization : generalizations) {
                StructuredType superType = generalization.getSuper();
                if (superType == null) continue;
                CppClass base = this.cpp.getWritableCppClass(CppCodePattern.Output.BasicClass, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)superType);
                MemberFunction baseFunc = new MemberFunction(base.getType().ref(), AbstractFunction.OverloadedOperator.ASSIGNMENT);
                MemberFunctionCall call = new MemberFunctionCall((NamedElement)base, baseFunc);
                call.addArgument((Expression)new ElementAccess((NamedElement)param));
                func.add((Expression)call);
            }
        }
        for (Map.Entry entry : this.fields.entrySet()) {
            MemberField field = (MemberField)entry.getValue();
            Attribute a = (Attribute)entry.getKey();
            Expression bound = GeneratorUtils.generateBoundExpression(a);
            if (field.getType().isArray()) {
                Variable i = new Variable((org.eclipse.papyrusrt.codegen.lang.cpp.Type)PrimitiveType.INT, "i", (Expression)new IntegralLiteral(0));
                LogicalComparison c = new LogicalComparison((Expression)new ElementAccess((NamedElement)i), LogicalComparison.Operator.LESS_THAN, bound);
                ForStatement forStmt = new ForStatement(i, (Expression)c, (Expression)new UnaryOperation(UnaryOperation.Operator.PRE_INCREMENT, (Expression)new ElementAccess((NamedElement)i)));
                forStmt.add((Statement)new ExpressionStatement((Expression)new BinaryOperation((Expression)new IndexExpr((Expression)new MemberAccess((NamedElement)cls, (NamedElement)field), (Expression)new ExpressionBlob("i")), BinaryOperation.Operator.ASSIGN, (Expression)new IndexExpr((Expression)new MemberAccess((Expression)new ElementAccess((NamedElement)param), (NamedElement)field), (Expression)new ExpressionBlob("i")))));
                func.add(new Statement[]{forStmt});
                continue;
            }
            func.add((Expression)new BinaryOperation((Expression)new MemberAccess((NamedElement)cls, (NamedElement)field), BinaryOperation.Operator.ASSIGN, (Expression)new MemberAccess((Expression)new ElementAccess((NamedElement)param), (NamedElement)field)));
        }
        func.add(new Statement[]{new ReturnStatement((Expression)new DereferenceExpr((Expression)new This(cls)))});
        cls.addMember(CppClass.Visibility.PUBLIC, func);
    }

    protected void generateCopyConstructor(CppClass cls) {
        Constructor copyCtor = this.cpp.getCopyConstructor(this.getOutputKind(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element);
        org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter param = copyCtor.setCopyConstructor(cls);
        StructuredType type = this.element;
        EList generalizations = type.getGeneralizations();
        if (generalizations != null) {
            for (Generalization generalization : generalizations) {
                StructuredType superType = generalization.getSuper();
                if (superType == null) continue;
                Constructor superCtor = null;
                superCtor = new Constructor();
                CppClass base = this.cpp.getWritableCppClass(CppCodePattern.Output.BasicClass, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)superType);
                superCtor.setCopyConstructor(base);
                ConstructorCall copyBaseCtorCall = null;
                copyBaseCtorCall = new ConstructorCall(superCtor);
                copyBaseCtorCall.addArgument((Expression)new ElementAccess((NamedElement)param));
                copyCtor.addBaseInitializer((AbstractFunctionCall)copyBaseCtorCall);
            }
        }
        for (Map.Entry entry : this.fields.entrySet()) {
            if (((Attribute)entry.getKey()).isStatic()) continue;
            MemberField field = (MemberField)entry.getValue();
            Attribute a = (Attribute)entry.getKey();
            Expression bound = GeneratorUtils.generateBoundExpression(a);
            if (field.getType().isArray()) {
                Variable i = new Variable((org.eclipse.papyrusrt.codegen.lang.cpp.Type)PrimitiveType.INT, "i", (Expression)new IntegralLiteral(0));
                LogicalComparison c = new LogicalComparison((Expression)new ElementAccess((NamedElement)i), LogicalComparison.Operator.LESS_THAN, bound);
                ForStatement forStmt = new ForStatement(i, (Expression)c, (Expression)new UnaryOperation(UnaryOperation.Operator.PRE_INCREMENT, (Expression)new ElementAccess((NamedElement)i)));
                forStmt.add((Statement)new ExpressionStatement((Expression)new BinaryOperation((Expression)new IndexExpr((Expression)new MemberAccess((NamedElement)cls, (NamedElement)field), (Expression)new ExpressionBlob("i")), BinaryOperation.Operator.ASSIGN, (Expression)new IndexExpr((Expression)new MemberAccess((Expression)new ElementAccess((NamedElement)param), (NamedElement)field), (Expression)new ExpressionBlob("i")))));
                copyCtor.add(new Statement[]{forStmt});
                continue;
            }
            copyCtor.add((Expression)new BinaryOperation((Expression)new MemberAccess((NamedElement)cls, (NamedElement)field), BinaryOperation.Operator.ASSIGN, (Expression)new MemberAccess((Expression)new ElementAccess((NamedElement)param), (NamedElement)field)));
        }
    }

    protected void generateDefaultConstructor(CppClass cls) {
        this.cpp.getConstructor(this.getOutputKind(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element);
    }

    protected void generateDestructor(CppClass cls) {
        this.cpp.getDestructor(this.getOutputKind(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element);
    }

    protected void generateEqualityOperator(CppClass cls) {
        MemberFunction func = new MemberFunction((org.eclipse.papyrusrt.codegen.lang.cpp.Type)PrimitiveType.BOOL, AbstractFunction.OverloadedOperator.EQUALITY);
        org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter param = new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(cls.getType().const_().ref(), "other");
        func.add(param);
        StructuredType type = this.element;
        EList generalizations = type.getGeneralizations();
        if (generalizations != null) {
            for (Generalization generalization : generalizations) {
                Boolean genEqualityOperatorBool;
                StructuredType superType = generalization.getSuper();
                if (superType == null || (genEqualityOperatorBool = RTCppGenerationProperties.getClassGenerationPropGenerateEqualityOperator((CommonElement)superType)) == null || genEqualityOperatorBool != null && !genEqualityOperatorBool.booleanValue()) continue;
                CppClass base = this.cpp.getWritableCppClass(CppCodePattern.Output.BasicClass, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)superType);
                MemberFunction baseFunc = new MemberFunction(base.getType().ref(), AbstractFunction.OverloadedOperator.EQUALITY);
                MemberFunctionCall call = new MemberFunctionCall((NamedElement)base, baseFunc);
                call.addArgument((Expression)new ElementAccess((NamedElement)param));
                ConditionalStatement attrCond = new ConditionalStatement();
                UnaryOperation attrEquals = new UnaryOperation(UnaryOperation.Operator.LOGICAL_NOT, (Expression)call);
                CodeBlock action = attrCond.add((Expression)attrEquals);
                action.add(new Statement[]{new ReturnStatement((Expression)BooleanLiteral.FALSE())});
                func.add(new Statement[]{attrCond});
            }
        }
        for (Map.Entry entry : this.fields.entrySet()) {
            if (((Attribute)entry.getKey()).isStatic()) continue;
            MemberField field = (MemberField)entry.getValue();
            Attribute a = (Attribute)entry.getKey();
            Expression bound = GeneratorUtils.generateBoundExpression(a);
            if (field.getType().isArray()) {
                Variable i = new Variable((org.eclipse.papyrusrt.codegen.lang.cpp.Type)PrimitiveType.INT, "i", (Expression)new IntegralLiteral(0));
                LogicalComparison c = new LogicalComparison((Expression)new ElementAccess((NamedElement)i), LogicalComparison.Operator.LESS_THAN, bound);
                ForStatement forStmt = new ForStatement(i, (Expression)c, (Expression)new UnaryOperation(UnaryOperation.Operator.PRE_INCREMENT, (Expression)new ElementAccess((NamedElement)i)));
                ConditionalStatement attrCond = new ConditionalStatement();
                UnaryOperation attrEquals = new UnaryOperation(UnaryOperation.Operator.LOGICAL_NOT, (Expression)new LogicalComparison((Expression)new IndexExpr((Expression)new MemberAccess((NamedElement)cls, (NamedElement)field), (Expression)new ExpressionBlob("i")), LogicalComparison.Operator.EQUIVALENT, (Expression)new IndexExpr((Expression)new MemberAccess((Expression)new ElementAccess((NamedElement)param), (NamedElement)field), (Expression)new ExpressionBlob("i"))));
                CodeBlock action = attrCond.add((Expression)attrEquals);
                action.add(new Statement[]{new ReturnStatement((Expression)BooleanLiteral.FALSE())});
                forStmt.add((Statement)attrCond);
                func.add(new Statement[]{forStmt});
                continue;
            }
            ConditionalStatement attrCond = new ConditionalStatement();
            UnaryOperation attrEquals = new UnaryOperation(UnaryOperation.Operator.LOGICAL_NOT, (Expression)new LogicalComparison((Expression)new MemberAccess((NamedElement)cls, (NamedElement)field), LogicalComparison.Operator.EQUIVALENT, (Expression)new MemberAccess((Expression)new ElementAccess((NamedElement)param), (NamedElement)field)));
            CodeBlock action = attrCond.add((Expression)attrEquals);
            action.add(new Statement[]{new ReturnStatement((Expression)BooleanLiteral.FALSE())});
            func.add(new Statement[]{attrCond});
        }
        func.add(new Statement[]{new ReturnStatement((Expression)BooleanLiteral.TRUE())});
        cls.addMember(CppClass.Visibility.PUBLIC, func);
    }

    protected void generateExtractionOperator(CppClass cls) {
        Function func = new Function(LinkageSpec.UNSPECIFIED, StandardLibrary.std_istream.ref(), AbstractFunction.OverloadedOperator.INSERTION);
        org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter param1 = new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(StandardLibrary.std_istream.ref(), "is");
        org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter param2 = new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(cls.getType().const_().ref(), "obj");
        func.add(param1);
        func.add(param2);
        for (Map.Entry<Attribute, MemberField> entry : this.fields.entrySet()) {
            MemberField field = entry.getValue();
            Expression[] fieldExtraction = new Expression[]{new ElementAccess((NamedElement)param1), new MemberAccess((Expression)new ElementAccess((NamedElement)param2), (NamedElement)field)};
            func.add(BinaryOperation.chain((BinaryOperation.Operator)BinaryOperation.Operator.RIGHT_SHIFT, (Expression[])fieldExtraction));
        }
        func.add(new Statement[]{new ReturnStatement((Expression)new ElementAccess((NamedElement)param1))});
        cls.addFriendFunction(func);
    }

    protected void generateInequalityOperator(CppClass cls) {
        MemberFunction func = new MemberFunction((org.eclipse.papyrusrt.codegen.lang.cpp.Type)PrimitiveType.BOOL, AbstractFunction.OverloadedOperator.INEQUALITY);
        org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter param = new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(cls.getType().const_().ref(), "other");
        func.add(param);
        StructuredType type = this.element;
        EList generalizations = type.getGeneralizations();
        if (generalizations != null) {
            for (Generalization generalization : generalizations) {
                Boolean genInequalityOperatorBool;
                StructuredType superType = generalization.getSuper();
                if (superType == null || (genInequalityOperatorBool = RTCppGenerationProperties.getClassGenerationPropGenerateInequalityOperator((CommonElement)superType)) == null || genInequalityOperatorBool != null && !genInequalityOperatorBool.booleanValue()) continue;
                CppClass base = this.cpp.getWritableCppClass(CppCodePattern.Output.BasicClass, (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)superType);
                MemberFunction baseFunc = new MemberFunction(base.getType().ref(), AbstractFunction.OverloadedOperator.INEQUALITY);
                MemberFunctionCall call = new MemberFunctionCall((NamedElement)base, baseFunc);
                call.addArgument((Expression)new ElementAccess((NamedElement)param));
                ConditionalStatement attrCond = new ConditionalStatement();
                CodeBlock action = attrCond.add((Expression)call);
                action.add(new Statement[]{new ReturnStatement((Expression)BooleanLiteral.TRUE())});
                func.add(new Statement[]{attrCond});
            }
        }
        for (Map.Entry entry : this.fields.entrySet()) {
            if (((Attribute)entry.getKey()).isStatic()) continue;
            MemberField field = (MemberField)entry.getValue();
            ConditionalStatement attrCond = new ConditionalStatement();
            LogicalComparison attrNotEquals = new LogicalComparison((Expression)new MemberAccess((NamedElement)cls, (NamedElement)field), LogicalComparison.Operator.NOT_EQUIVALENT, (Expression)new MemberAccess((Expression)new ElementAccess((NamedElement)param), (NamedElement)field));
            CodeBlock action = attrCond.add((Expression)attrNotEquals);
            action.add(new Statement[]{new ReturnStatement((Expression)BooleanLiteral.TRUE())});
            func.add(new Statement[]{attrCond});
        }
        func.add(new Statement[]{new ReturnStatement((Expression)BooleanLiteral.FALSE())});
        cls.addMember(CppClass.Visibility.PUBLIC, func);
    }

    protected void generateInsertionOperator(CppClass cls) {
        Function func = new Function(LinkageSpec.UNSPECIFIED, StandardLibrary.std_ostream.ref(), AbstractFunction.OverloadedOperator.EXTRACTION);
        org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter param1 = new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(StandardLibrary.std_ostream.ref(), "os");
        org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter param2 = new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(cls.getType().const_().ref(), "obj");
        func.add(param1);
        func.add(param2);
        for (Map.Entry<Attribute, MemberField> entry : this.fields.entrySet()) {
            MemberField field = entry.getValue();
            Expression[] fieldInsertion = new Expression[]{new ElementAccess((NamedElement)param1), new MemberAccess((Expression)new ElementAccess((NamedElement)param2), (NamedElement)field), new CharacterLiteral("\\n")};
            func.add(BinaryOperation.chain((BinaryOperation.Operator)BinaryOperation.Operator.LEFT_SHIFT, (Expression[])fieldInsertion));
        }
        func.add(new Statement[]{new ReturnStatement((Expression)new ElementAccess((NamedElement)param1))});
        cls.addFriendFunction(func);
    }

    protected void generateStateMachine(CppClass cls) {
        CodeGenPlugin.warning((String)("'" + QualifiedNames.cachedFullName((org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element) + "' has stereotype attribute 'generateStateMachine' set to true, but this is not yet supported."));
    }

    protected void generateAttributeInitialization(CppClass cls, Attribute attr, MemberField field, Expression initExpr) {
        InitializationKind attrInitKind = RTCppGenerationProperties.getAttributePropInitialization((CommonElement)attr);
        if (attr.isStatic() && !attr.isReadOnly()) {
            field.setInitKind(MemberField.InitKind.ASSIGNMENT);
            return;
        }
        if (attrInitKind == null && initExpr != null) {
            if (attr.isStatic()) {
                field.setInitKind(MemberField.InitKind.CONSTANT);
            } else {
                field.setInitKind(MemberField.InitKind.CONSTRUCTOR);
            }
            return;
        }
        if (attrInitKind != null && !attr.isStatic()) {
            switch (attrInitKind) {
                case ASSIGNMENT: {
                    field.setInitKind(MemberField.InitKind.ASSIGNMENT);
                    break;
                }
                case CONSTANT: {
                    field.setInitKind(MemberField.InitKind.CONSTANT);
                    break;
                }
                case CONSTRUCTOR: {
                    field.setInitKind(MemberField.InitKind.CONSTRUCTOR);
                    break;
                }
            }
        }
        if (!attr.isStatic() && attrInitKind != null && initExpr != null) {
            Constructor ctor = null;
            switch (attrInitKind) {
                case ASSIGNMENT: {
                    ctor = this.cpp.getConstructor(this.getOutputKind(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element);
                    ctor.add((Expression)new BinaryOperation((Expression)new MemberAccess((NamedElement)cls, (NamedElement)field), BinaryOperation.Operator.ASSIGN, initExpr));
                    break;
                }
                case CONSTANT: {
                    break;
                }
                case CONSTRUCTOR: {
                    ctor = this.cpp.getConstructor(this.getOutputKind(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element);
                    ctor.addFieldInitializer(field, new Expression[]{initExpr});
                    break;
                }
            }
        }
    }

    @Override
    public List<FileName> getGeneratedFilenames() {
        ArrayList<FileName> result = new ArrayList<FileName>();
        ElementList el = this.cpp.getElementList(this.getOutputKind(), (org.eclipse.papyrusrt.xtumlrt.common.NamedElement)this.element);
        result.add(el.getName());
        return result;
    }
}

