/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.edit.utils.GMFCommandUtils;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.commands.ExcludeRequest;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.types.advice.IInheritanceEditHelperAdvice;
import org.eclipse.papyrusrt.umlrt.core.utils.RegionUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.StateUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.TransitionUtils;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;

public class RTRegionEditHelperAdvice
extends AbstractEditHelperAdvice
implements IInheritanceEditHelperAdvice {
    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        ICommand result = this.getInheritanceEditCommand(request);
        if (result == null) {
            result = super.getBeforeEditCommand(request);
        }
        return result;
    }

    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateRelationshipRequest) {
            return this.approveCreateRelationshipRequest((CreateRelationshipRequest)request);
        }
        if (request instanceof CreateElementRequest) {
            return this.approveCreateRequest((CreateElementRequest)request);
        }
        if (request instanceof MoveRequest) {
            return this.approveMoveRequest((MoveRequest)request);
        }
        if (request instanceof SetRequest) {
            return this.approveSetRequest((SetRequest)request);
        }
        if (request instanceof ExcludeRequest) {
            return this.approveExcludeRequest((ExcludeRequest)request);
        }
        return super.approveRequest(request);
    }

    private boolean approveCreateRelationshipRequest(CreateRelationshipRequest request) {
        if (ElementTypeUtils.isTypeCompatible(request.getElementType(), (IElementType)UMLElementTypes.TRANSITION)) {
            return this.approveCreateTransition(request);
        }
        return super.approveRequest((IEditCommandRequest)request);
    }

    protected boolean approveCreateTransition(CreateRelationshipRequest request) {
        boolean result = true;
        EObject source = request.getSource();
        EObject implicitSource = TransitionUtils.getImplicitState(source);
        EObject target = request.getTarget();
        EObject implicitTarget = TransitionUtils.getImplicitState(target);
        EObject container = request.getContainer();
        if (StateUtils.isSimpleState(implicitSource)) {
            if (container instanceof Region) {
                boolean bl = result = result && ((Region)container).getOwnedElements().contains((Object)implicitSource);
                if (implicitTarget instanceof State) {
                    if (((Region)container).getOwnedElements().contains((Object)implicitTarget) && target instanceof Pseudostate) {
                        result = result && (!((Pseudostate)target).getKind().equals((Object)PseudostateKind.INITIAL_LITERAL) || !((Pseudostate)target).getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL));
                    }
                } else if (implicitTarget == implicitSource && target instanceof Pseudostate) {
                    result = result && ((Pseudostate)target).getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL);
                }
            } else {
                result = false;
            }
        } else if (StateUtils.isCompositeState(implicitSource)) {
            if (container instanceof Region) {
                if (((Region)container).getOwnedElements().contains((Object)implicitSource)) {
                    if (implicitTarget instanceof State) {
                        if (((Region)container).getOwnedElements().contains((Object)implicitTarget)) {
                            if (source instanceof Pseudostate) {
                                boolean bl = result = result && !((Pseudostate)source).getKind().equals((Object)PseudostateKind.ENTRY_POINT_LITERAL);
                            }
                            if (target instanceof Pseudostate) {
                                result = result && !((Pseudostate)target).getKind().equals((Object)PseudostateKind.INITIAL_LITERAL) && !((Pseudostate)target).getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL);
                            }
                        } else if (target != null) {
                            if (target instanceof Pseudostate) {
                                boolean bl = result = result && !((Pseudostate)target).getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL);
                            }
                            if (source instanceof Pseudostate) {
                                result = result && !((Pseudostate)source).getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL);
                            }
                        }
                    }
                } else if (((State)implicitSource).getRegions().contains((Object)container)) {
                    if (implicitSource == implicitTarget) {
                        if (source instanceof Pseudostate) {
                            boolean bl = result = result && ((Pseudostate)source).getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL);
                        }
                        if (target instanceof Pseudostate) {
                            result = result && ((Pseudostate)target).getKind().equals((Object)PseudostateKind.ENTRY_POINT_LITERAL);
                        }
                    } else if (implicitTarget != null) {
                        if (((Region)container).getOwnedElements().contains((Object)implicitTarget)) {
                            if (target instanceof Pseudostate) {
                                result = result && ((Pseudostate)target).getKind().equals((Object)PseudostateKind.ENTRY_POINT_LITERAL);
                            }
                        } else {
                            result = false;
                        }
                    }
                } else {
                    result = false;
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    protected boolean approveSetRequest(SetRequest request) {
        EStructuralFeature feature = request.getFeature();
        for (Object o : request.getElementsToEdit()) {
            if (!(o instanceof Region) || !UMLPackage.Literals.REGION__SUBVERTEX.equals(feature) && !UMLPackage.Literals.REGION__TRANSITION.equals(feature)) continue;
            return false;
        }
        return super.approveRequest((IEditCommandRequest)request);
    }

    protected boolean approveMoveRequest(MoveRequest request) {
        return RegionUtils.shouldApproveMoveRequest(request);
    }

    protected boolean approveCreateRequest(CreateElementRequest request) {
        IElementType typeToCreate = request.getElementType();
        if (!(request.getContainer() instanceof Region)) {
            return true;
        }
        Region targetRegion = (Region)request.getContainer();
        if (ElementTypeUtils.isTypeCompatible(typeToCreate, (IElementType)UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_INITIAL)) {
            return targetRegion.getSubvertices().stream().filter(Pseudostate.class::isInstance).map(Pseudostate.class::cast).noneMatch(p -> PseudostateKind.INITIAL_LITERAL == p.getKind());
        }
        if (ElementTypeUtils.isTypeCompatible(typeToCreate, (IElementType)UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_DEEP_HISTORY)) {
            if (targetRegion.getState() == null) {
                return false;
            }
            return targetRegion.getSubvertices().stream().filter(Pseudostate.class::isInstance).map(Pseudostate.class::cast).noneMatch(p -> PseudostateKind.DEEP_HISTORY_LITERAL == p.getKind());
        }
        if (ElementTypeUtils.isTypeCompatible(typeToCreate, (IElementType)UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_ENTRY_POINT)) {
            return false;
        }
        return !ElementTypeUtils.isTypeCompatible(typeToCreate, (IElementType)UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_EXIT_POINT);
    }

    protected boolean approveExcludeRequest(ExcludeRequest request) {
        return !(request.getElementToExclude() instanceof Pseudostate);
    }

    protected ICommand getAfterCreateRelationshipCommand(final CreateRelationshipRequest request) {
        if (UMLPackage.Literals.REGION__TRANSITION.equals(request.getContainmentFeature())) {
            return new AbstractTransactionalCommand(request.getEditingDomain(), "Edit Transition", Collections.EMPTY_LIST){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    CommandResult result = CommandResult.newOKCommandResult();
                    Transition transition = (Transition)request.getNewElement();
                    Vertex source = transition.getSource();
                    Vertex target = transition.getTarget();
                    if (source instanceof Pseudostate && !PseudostateKind.ENTRY_POINT_LITERAL.equals((Object)((Pseudostate)source).getKind()) && !PseudostateKind.EXIT_POINT_LITERAL.equals((Object)((Pseudostate)source).getKind())) {
                        transition.setKind(TransitionKind.EXTERNAL_LITERAL);
                        return result;
                    }
                    transition.setKind(TransitionUtils.getTransitionKind(transition, (EObject)source, (EObject)target));
                    return result;
                }
            };
        }
        return super.getAfterCreateRelationshipCommand(request);
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        ConfigureElementCommand command = new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
                EObject elementToConfigure = request.getElementToConfigure();
                if (!(elementToConfigure instanceof Region)) {
                    return CommandResult.newErrorCommandResult((String)"Element to configure is not a region");
                }
                Region region = (Region)elementToConfigure;
                try {
                    Pseudostate pseudoState = RTRegionEditHelperAdvice.this.createInitialState(region, monitor, info, null);
                    State initialState = RTRegionEditHelperAdvice.this.createFirstSimpleState(region, monitor, info, "State1");
                    RTRegionEditHelperAdvice.this.createInitialTransition(region, (Vertex)pseudoState, (Vertex)initialState, monitor, info, "Initial");
                    return CommandResult.newOKCommandResult((Object)region);
                }
                catch (ExecutionException e) {
                    return CommandResult.newErrorCommandResult((Throwable)e);
                }
            }
        };
        ICommand superCommand = super.getBeforeConfigureCommand(request);
        if (superCommand != null) {
            return command.compose((IUndoableOperation)superCommand).reduce();
        }
        return command.reduce();
    }

    protected Pseudostate createInitialState(Region region, IProgressMonitor monitor, IAdaptable info, String pseudoStateName) throws ExecutionException {
        EObject newElement = null;
        CreateElementRequest createElementRequest = new CreateElementRequest((EObject)region, (IElementType)UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_INITIAL);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)region);
        if (provider == null) {
            throw new ExecutionException("Impossible to get the provider from " + region);
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        if (createGMFCommand != null) {
            if (createGMFCommand.canExecute()) {
                IStatus status = createGMFCommand.execute(monitor, info);
                if (status.isOK()) {
                    newElement = GMFCommandUtils.getCommandEObjectResult((ICommand)createGMFCommand);
                    if (!(newElement instanceof Pseudostate)) {
                        throw new ExecutionException("Element creation problem for PseudoState.");
                    }
                    ((Pseudostate)newElement).setName(pseudoStateName);
                    return (Pseudostate)newElement;
                }
                throw new ExecutionException("Impossible to create the pseudo state");
            }
            throw new ExecutionException("Command to create the pseudo state is not executable");
        }
        throw new ExecutionException("Impossible to find a command to create the Pseudostate");
    }

    protected State createFirstSimpleState(Region region, IProgressMonitor monitor, IAdaptable info, String firstStateName) throws ExecutionException {
        EObject newElement = null;
        CreateElementRequest createElementRequest = new CreateElementRequest((EObject)region, (IElementType)UMLRTElementTypesEnumerator.RT_STATE);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)region);
        if (provider == null) {
            throw new ExecutionException("Impossible to get the provider from " + region);
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        if (createGMFCommand != null) {
            if (createGMFCommand.canExecute()) {
                IStatus status = createGMFCommand.execute(monitor, info);
                if (status.isOK()) {
                    newElement = GMFCommandUtils.getCommandEObjectResult((ICommand)createGMFCommand);
                    if (!(newElement instanceof State)) {
                        throw new ExecutionException("Element creation problem for State.");
                    }
                    ((State)newElement).setName(firstStateName);
                    return (State)newElement;
                }
                throw new ExecutionException("Impossible to create the first simple state");
            }
            throw new ExecutionException("Command to create the first simple state is not executable");
        }
        throw new ExecutionException("Impossible to find a command to create the first simple state");
    }

    protected Transition createInitialTransition(Region region, Vertex source, Vertex target, IProgressMonitor monitor, IAdaptable info, String firstTransitionName) throws ExecutionException {
        EObject newElement = null;
        CreateElementRequest createElementRequest = new CreateElementRequest((EObject)region, (IElementType)UMLElementTypes.TRANSITION);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)region);
        if (provider == null) {
            throw new ExecutionException("Impossible to get the provider from " + region);
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        if (createGMFCommand != null) {
            if (createGMFCommand.canExecute()) {
                IStatus status = createGMFCommand.execute(monitor, info);
                if (status.isOK()) {
                    newElement = GMFCommandUtils.getCommandEObjectResult((ICommand)createGMFCommand);
                    if (!(newElement instanceof Transition)) {
                        throw new ExecutionException("Element creation problem for Transition .");
                    }
                    ((Transition)newElement).setName(firstTransitionName);
                    if (source != null) {
                        ((Transition)newElement).setSource(source);
                    }
                    if (target != null) {
                        ((Transition)newElement).setTarget(target);
                    }
                    return (Transition)newElement;
                }
                throw new ExecutionException("Impossible to create the initial Transition");
            }
            throw new ExecutionException("Command to create initial Transition is not executable");
        }
        throw new ExecutionException("Impossible to find a command to create the initial Transition");
    }
}

