/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.edit.utils.GMFCommandUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.internal.commands.CreateHeadlessStateMachineDiagramCommand;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.RegionUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.StateMachineUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;

public class RTStateMachineEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            return this.approveCreateElementRequest((CreateElementRequest)request);
        }
        if (request instanceof MoveRequest) {
            return this.approveMoveRequest((MoveRequest)request);
        }
        return super.approveRequest(request);
    }

    protected boolean approveMoveRequest(MoveRequest request) {
        return RegionUtils.shouldApproveMoveRequest(request);
    }

    protected boolean approveCreateElementRequest(CreateElementRequest createElementRequest) {
        IElementType type = createElementRequest.getElementType();
        IHintedType regionType = UMLElementTypes.REGION;
        if (regionType != null) {
            if (ElementTypeUtils.isTypeCompatible(type, (IElementType)regionType)) {
                EObject container = createElementRequest.getContainer();
                if (container instanceof StateMachine) {
                    return ((StateMachine)container).getRegions().size() < 1;
                }
                return super.approveRequest((IEditCommandRequest)createElementRequest);
            }
            return false;
        }
        Activator.log.error("Impossible to find Region element type", null);
        return super.approveRequest((IEditCommandRequest)createElementRequest);
    }

    public void configureRequest(IEditCommandRequest request) {
        if (request instanceof MoveRequest) {
            StateMachineUtils.retargetToRegion((MoveRequest)request);
        }
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        ConfigureElementCommand command = new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
                EObject elementToConfigure = request.getElementToConfigure();
                if (!(elementToConfigure instanceof StateMachine)) {
                    return CommandResult.newErrorCommandResult((String)"Element to configure is not a state machine");
                }
                StateMachine stateMachine = (StateMachine)elementToConfigure;
                stateMachine.setIsReentrant(false);
                stateMachine.getContext().setClassifierBehavior((Behavior)stateMachine);
                if (!stateMachine.getExtendedStateMachines().isEmpty()) {
                    return CommandResult.newOKCommandResult((Object)stateMachine);
                }
                try {
                    Region region = RTStateMachineEditHelperAdvice.this.createRegion(stateMachine, monitor, info, "Region");
                    return CommandResult.newOKCommandResult((Object)region);
                }
                catch (ExecutionException e) {
                    return CommandResult.newErrorCommandResult((Throwable)e);
                }
            }
        };
        ICommand superCommand = super.getBeforeConfigureCommand(request);
        if (superCommand != null) {
            return command.compose((IUndoableOperation)superCommand).reduce();
        }
        return command.reduce();
    }

    protected ICommand getAfterConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                RTStateMachineEditHelperAdvice.createStateMachineDiagram(request.getElementToConfigure(), null);
                return CommandResult.newOKCommandResult((Object)request.getElementToConfigure());
            }
        };
    }

    public static Diagram createStateMachineDiagram(EObject owner, String name) {
        ModelSet modelSet;
        ServicesRegistry registry;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(owner);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
        try {
            modelSet = (ModelSet)registry.getService(ModelSet.class);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
        ViewPrototype prototype = ViewPrototype.get((PolicyChecker)PolicyChecker.getFor((EObject)owner), (String)"UMLRTStateMachine", (EObject)owner, (EObject)owner);
        return new CreateHeadlessStateMachineDiagramCommand().createDiagram(modelSet, owner, owner, prototype, null, false);
    }

    protected Region createRegion(StateMachine stateMachine, IProgressMonitor monitor, IAdaptable info, String regionName) throws ExecutionException {
        EObject newElement = null;
        CreateElementRequest createElementRequest = new CreateElementRequest((EObject)stateMachine, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrusrt.umlrt.core.RTRegion"));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)stateMachine);
        if (provider == null) {
            throw new ExecutionException("Impossible to get the provider from " + stateMachine);
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        if (createGMFCommand != null) {
            if (createGMFCommand.canExecute()) {
                IStatus status = createGMFCommand.execute(monitor, info);
                if (status.isOK()) {
                    newElement = GMFCommandUtils.getCommandEObjectResult((ICommand)createGMFCommand);
                    if (!(newElement instanceof Region)) {
                        throw new ExecutionException("Element creation problem for " + UMLRTElementTypesEnumerator.RT_REGION.getDisplayName() + ".");
                    }
                    ((Region)newElement).setName(regionName);
                    return (Region)newElement;
                }
                throw new ExecutionException("Impossible to create the region");
            }
            throw new ExecutionException("Command to create the region is not executable");
        }
        throw new ExecutionException("Impossible to find a command to create the region");
    }
}

