/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.properties.ui.providers.CreateInFeatureContentProvider;
import org.eclipse.papyrus.infra.properties.ui.providers.FeatureContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.DelegatingLabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.tools.databinding.ExtendedMultiplicityObservableValue;
import org.eclipse.papyrus.uml.tools.providers.UMLContainerContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.internal.defaultlanguage.DefaultLanguageRegistry;
import org.eclipse.papyrusrt.umlrt.core.internal.defaultlanguage.NoDefautLanguage;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTMessageUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.system.profile.util.SystemElementsUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Messages;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.CompositeValidator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.properties.TransitionProperties;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.ChangeListenerUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.MessageParameterTypeReferenceConverter;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.NullReferenceValueFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.modelelement.properties.RTPropertyEditorFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.providers.TypeNameResolutionHelper;
import org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement.RTPackageObservableValue;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.CapsulePartTypeValueFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.PropertyReplicationObservableValue;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.ProtocolMessageParameterFactory;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.RTPortTypeValueFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsulePart;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTProtocol;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRTExtModelElement
extends UMLModelElement {
    private static final String TRIGGER = "trigger";
    private static final String GUARD = "guard";

    public UMLRTExtModelElement(EObject source) {
        this(source, (EditingDomain)TransactionUtil.getEditingDomain((EObject)source));
    }

    public UMLRTExtModelElement(EObject source, EditingDomain domain) {
        super(source, domain);
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (propertyPath.contains("RTmultiplicity")) {
            return new StaticContentProvider((Object[])new String[]{"1", "0..1"});
        }
        if (propertyPath.contains("language")) {
            ArrayList availableLanguages = new ArrayList(DefaultLanguageRegistry.getInstance().getLanguages());
            Collections.addAll(availableLanguages, NoDefautLanguage.INSTANCE);
            return new StaticContentProvider(availableLanguages.toArray());
        }
        if (propertyPath.contains("replication")) {
            return new StaticContentProvider((Object[])new String[]{"None (1)", "1", "*"});
        }
        return super.getContentProvider(propertyPath);
    }

    public boolean isMandatory(String propertyPath) {
        if (propertyPath.contains("language")) {
            return true;
        }
        if (this.getFeature(propertyPath) == UMLPackage.Literals.TYPED_ELEMENT__TYPE && (this.source instanceof Property && CapsulePartUtils.isCapsulePart((Property)((Property)this.source)) || RTPortUtils.isRTPort((EObject)this.source) || RTMessageUtils.isRTMessageParameter((EObject)this.source))) {
            return true;
        }
        return super.isMandatory(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        if (propertyPath.endsWith("language")) {
            return new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IDefaultLanguage) {
                        return ((IDefaultLanguage)element).getName();
                    }
                    return super.getText(element);
                }
            };
        }
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.Literals.TYPED_ELEMENT__TYPE && RTMessageUtils.isRTMessageParameter((EObject)this.source)) {
            ILabelProvider delegate = super.getLabelProvider(propertyPath);
            return new DelegatingLabelProvider(delegate){

                protected String customGetText(Object element) {
                    return element == null ? Messages.NoTypeForTypedElement_Label : null;
                }
            };
        }
        return super.getLabelProvider(propertyPath);
    }

    public IObservable doGetObservable(String propertyPath) {
        IObservableList<Trigger> observable = null;
        switch (propertyPath) {
            case "RTmultiplicity": {
                observable = new ExtendedMultiplicityObservableValue(this.source, this.domain);
                break;
            }
            case "language": {
                observable = new RTPackageObservableValue((Package)this.source, (TransactionalEditingDomain)this.domain);
                break;
            }
            case "replication": {
                observable = new PropertyReplicationObservableValue(this.source, (TransactionalEditingDomain)this.domain);
                break;
            }
            case "trigger": {
                if (this.source instanceof Transition) {
                    observable = TransitionProperties.triggers().observe((Transition)this.source);
                    break;
                }
                observable = super.doGetObservable(propertyPath);
                break;
            }
            default: {
                observable = super.doGetObservable(propertyPath);
            }
        }
        if (this.getSource() instanceof RTPort) {
            observable.addChangeListener((IChangeListener)new UMLRTExtModelElementChangeListener());
        }
        return observable;
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        UMLPropertyEditorFactory result = null;
        EReference reference = null;
        EClass type = null;
        if (propertyPath.equals("type")) {
            reference = UMLPackage.Literals.TYPED_ELEMENT__TYPE;
            if (this.source instanceof Port) {
                result = new RTPortTypeValueFactory(reference);
            } else if (this.source instanceof Property) {
                result = new CapsulePartTypeValueFactory(reference);
            } else if (RTMessageUtils.isRTMessageParameter((EObject)this.source)) {
                result = NullReferenceValueFactory.INSTANCE;
            }
        } else if (TRIGGER.equals(propertyPath) && this.source instanceof Transition) {
            reference = UMLPackage.Literals.TRANSITION__TRIGGER;
            result = new RTPropertyEditorFactory(reference);
        } else if (GUARD.equals(propertyPath) && this.source instanceof Transition) {
            reference = UMLPackage.Literals.TRANSITION__GUARD;
            result = new RTPropertyEditorFactory(reference);
        } else {
            EStructuralFeature feature = this.getFeature(propertyPath);
            if (feature == UMLPackage.Literals.BEHAVIORAL_FEATURE__OWNED_PARAMETER && RTMessageUtils.isRTMessage((EObject)this.getSource())) {
                reference = (EReference)feature;
                result = new ProtocolMessageParameterFactory();
            }
        }
        if (result instanceof UMLPropertyEditorFactory) {
            UMLPropertyEditorFactory factory = result;
            type = reference.getEReferenceType();
            factory.setContainerLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
            factory.setReferenceLabelProvider((ILabelProvider)new EMFLabelProvider());
            UMLContainerContentProvider contentProvider = new UMLContainerContentProvider(this.source, reference);
            ResourceSet rs = this.source == null ? null : (this.source.eResource() == null ? null : this.source.eResource().getResourceSet());
            EMFGraphicalContentProvider provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)rs, (String)HistoryUtil.getHistoryID((EObject)this.source, (EStructuralFeature)reference, (String)"container"));
            factory.setContainerContentProvider((IStaticContentProvider)provider);
            factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
        }
        return result != null ? result : super.getValueFactory(propertyPath);
    }

    public boolean forceRefresh(String propertyPath) {
        return true;
    }

    protected boolean isFeatureEditable(String propertyPath) {
        boolean editable = false;
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (this.source instanceof Transition) {
            return true;
        }
        if (this.source instanceof Port) {
            boolean isSystemProtocol;
            UMLRTPort port = UMLRTPort.getInstance((Port)((Port)this.source));
            if (port == null) {
                return false;
            }
            UMLRTProtocol protocol = port.getType();
            boolean bl = isSystemProtocol = protocol != null && SystemElementsUtils.isSystemProtocol((Collaboration)protocol.toUML());
            editable = "replication".equals(propertyPath) ? true : (feature == UMLPackage.Literals.PORT__IS_CONJUGATED ? (isSystemProtocol || port.isInherited() ? false : super.isFeatureEditable(propertyPath)) : ("type".equals(propertyPath) ? super.isFeatureEditable(propertyPath) : (feature == UMLPackage.Literals.PORT__IS_SERVICE ? (isSystemProtocol || port.isInherited() ? false : !port.isConnected() && port.isBehavior()) : (feature == UMLPackage.Literals.PORT__IS_BEHAVIOR ? (isSystemProtocol ? false : !(!port.isWired() || port.isWired() && !port.isService() || port.isWired() && port.isService() && !port.isBehavior() && port.isConnectedInside())) : super.isFeatureEditable(propertyPath)))));
        } else if (this.source instanceof Property) {
            UMLRTCapsulePart capsulePart = UMLRTCapsulePart.getInstance((Property)((Property)this.source));
            editable = capsulePart != null || super.isFeatureEditable(propertyPath);
        } else if (this.source instanceof Parameter) {
            editable = feature == UMLPackage.Literals.NAMED_ELEMENT__NAME ? !UMLRTExtensionUtil.isInherited((Element)((Parameter)this.source)) : super.isFeatureEditable(propertyPath);
        } else if (this.source instanceof Package) {
            editable = propertyPath.endsWith("language") ? true : super.isFeatureEditable(propertyPath);
        } else if (this.source instanceof Operation) {
            editable = super.isFeatureEditable(propertyPath);
        }
        return editable;
    }

    public IValidator getValidator(String propertyPath) {
        IValidator result = super.getValidator(propertyPath);
        if ("replication".equals(propertyPath)) {
            result = CompositeValidator.of(result, new IValidator(){

                public IStatus validate(Object value) {
                    if (((String)value).matches("-\\d*.?\\d+|\\d*\\.\\d+")) {
                        return new Status(4, "org.eclipse.papyrusrt.umlrt.tooling.ui", "Only positive Integers are allowed");
                    }
                    if (((String)value).contains("..")) {
                        return new Status(4, "org.eclipse.papyrusrt.umlrt.tooling.ui", ".. notation is not allowed");
                    }
                    return Status.OK_STATUS;
                }
            });
        }
        return result;
    }

    public IPapyrusConverter getPapyrusConverter(String propertyPath) {
        Object result;
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == UMLPackage.Literals.TYPED_ELEMENT__TYPE) {
            if (RTMessageUtils.isRTMessageParameter((EObject)this.source)) {
                INameResolutionHelper helper = this.getNameResolutionHelper(propertyPath);
                result = new MessageParameterTypeReferenceConverter(helper);
            } else {
                result = super.getPapyrusConverter(propertyPath);
            }
        } else {
            result = super.getPapyrusConverter(propertyPath);
        }
        return result;
    }

    public INameResolutionHelper getNameResolutionHelper(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        Object result = feature == UMLPackage.Literals.TYPED_ELEMENT__TYPE ? new TypeNameResolutionHelper((TypedElement)this.source) : super.getNameResolutionHelper(propertyPath);
        return result;
    }

    public class UMLRTExtModelElementChangeListener
    implements IChangeListener {
        public void handleChange(ChangeEvent event) {
            try {
                ChangeListenerUtils.fireDataSourceChanged(UMLRTExtModelElement.this.dataSource);
            }
            catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                Activator.log.debug(e.getMessage());
            }
        }
    }
}

