/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl;

import java.util.Objects;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTReplicatedElement;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.UMLRTUMLRTPackage;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.FacadeObjectImpl;
import org.eclipse.papyrusrt.umlrt.uml.internal.facade.impl.UMLRTNamedElementImpl;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

public abstract class UMLRTReplicatedElementImpl
extends UMLRTNamedElementImpl
implements UMLRTReplicatedElement {
    protected static final int REPLICATION_FACTOR_EDEFAULT = 0;
    protected static final String REPLICATION_FACTOR_AS_STRING_EDEFAULT = null;
    protected static final boolean SYMBOLIC_REPLICATION_FACTOR_EDEFAULT = false;

    protected UMLRTReplicatedElementImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return UMLRTUMLRTPackage.Literals.REPLICATED_ELEMENT;
    }

    protected FacadeObjectImpl.BasicFacadeAdapter<? extends UMLRTReplicatedElementImpl> createFacadeAdapter() {
        return new ReplicationAdapter<UMLRTReplicatedElementImpl>(this);
    }

    @Override
    public int getReplicationFactor() {
        return UMLRTReplicatedElementImpl.getReplicationFactor(this.toUML().getUpperValue());
    }

    static int getReplicationFactor(ValueSpecification value) {
        return value == null ? 1 : UMLRTReplicatedElementImpl.integerValue(value);
    }

    private static int integerValue(ValueSpecification value) {
        String stringValue;
        int result = value instanceof LiteralUnlimitedNatural ? ((LiteralUnlimitedNatural)value).getValue() : (value instanceof LiteralInteger ? ((LiteralInteger)value).getValue() : (UMLRTReplicatedElementImpl.isIntegerValued(stringValue = value.stringValue()) ? Integer.valueOf(stringValue) : 1));
        return result;
    }

    static String getReplicationFactorAsString(ValueSpecification value) {
        return value == null ? "1" : value.stringValue();
    }

    @Override
    public void setReplicationFactor(int newReplicationFactor) {
        if (this.isSymbolicReplicationFactor() || this.getReplicationFactor() != newReplicationFactor) {
            Property property = this.toUML();
            property.setLower(newReplicationFactor);
            property.setUpper(newReplicationFactor);
        }
    }

    @Override
    public String getReplicationFactorAsString() {
        return UMLRTReplicatedElementImpl.getReplicationFactorAsString(this.toUML().getUpperValue());
    }

    @Override
    public void setReplicationFactorAsString(String newReplicationFactorAsString) {
        if (!Objects.equals(newReplicationFactorAsString, this.getReplicationFactorAsString())) {
            try {
                int asInt = Integer.parseInt(newReplicationFactorAsString);
                this.setReplicationFactor(asInt);
            }
            catch (Exception exception) {
                Property property = this.toUML();
                UMLRTReplicatedElementImpl.setReplicationFactor((MultiplicityElement)property, UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE, newReplicationFactorAsString);
                UMLRTReplicatedElementImpl.setReplicationFactor((MultiplicityElement)property, UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE, newReplicationFactorAsString);
            }
        }
    }

    static void setReplicationFactor(MultiplicityElement mult, EReference bound, String replication) {
        OpaqueExpression expr;
        OpaqueExpression opaqueExpression = mult.eGet((EStructuralFeature)bound) instanceof OpaqueExpression ? (OpaqueExpression)mult.eGet((EStructuralFeature)bound) : (expr = bound == UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE ? (OpaqueExpression)mult.createLowerValue(null, null, UMLPackage.Literals.OPAQUE_EXPRESSION) : (OpaqueExpression)mult.createUpperValue(null, null, UMLPackage.Literals.OPAQUE_EXPRESSION));
        if (expr.getBodies().isEmpty()) {
            expr.getBodies().add((Object)replication);
        } else {
            expr.getBodies().set(0, (Object)replication);
        }
    }

    @Override
    public boolean isSymbolicReplicationFactor() {
        return UMLRTReplicatedElementImpl.isSymbolicReplicationFactor(this.toUML().getUpperValue());
    }

    static boolean isSymbolicReplicationFactor(ValueSpecification value) {
        return value != null && !(value instanceof LiteralUnlimitedNatural) && !(value instanceof LiteralInteger) && !UMLRTReplicatedElementImpl.isIntegerValuedExpression(value);
    }

    private static boolean isIntegerValuedExpression(ValueSpecification value) {
        String stringValue = value.stringValue();
        return UMLRTReplicatedElementImpl.isIntegerValued(stringValue);
    }

    private static boolean isIntegerValued(String stringValue) {
        return stringValue != null && stringValue.chars().allMatch(ch -> ch >= 48 && ch <= 57);
    }

    @Override
    public Property toUML() {
        return (Property)super.toUML();
    }

    @Override
    public UMLRTCapsule getCapsule() {
        return UMLRTCapsule.getInstance(this.toUML().getClass_());
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 14: {
                return this.getReplicationFactor();
            }
            case 15: {
                return this.getReplicationFactorAsString();
            }
            case 16: {
                return this.isSymbolicReplicationFactor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    protected Object facadeGetAll(int referenceID) {
        return this.eGet(referenceID, true, true);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 14: {
                this.setReplicationFactor((Integer)newValue);
                return;
            }
            case 15: {
                this.setReplicationFactorAsString((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 14: {
                this.setReplicationFactor(0);
                return;
            }
            case 15: {
                this.setReplicationFactorAsString(REPLICATION_FACTOR_AS_STRING_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 14: {
                return this.getReplicationFactor() != 0;
            }
            case 15: {
                return REPLICATION_FACTOR_AS_STRING_EDEFAULT == null ? this.getReplicationFactorAsString() != null : !REPLICATION_FACTOR_AS_STRING_EDEFAULT.equals(this.getReplicationFactorAsString());
            }
            case 16: {
                return this.isSymbolicReplicationFactor();
            }
        }
        return super.eIsSet(featureID);
    }

    protected static class ReplicationAdapter<F extends UMLRTReplicatedElementImpl>
    extends UMLRTNamedElementImpl.NamedElementAdapter<F> {
        ReplicationAdapter(F facade) {
            super(facade);
        }

        @Override
        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            if (newTarget instanceof MultiplicityElement) {
                MultiplicityElement mult = (MultiplicityElement)newTarget;
                if (mult.getLowerValue() != null) {
                    this.adaptAdditional((Notifier)mult.getLowerValue());
                }
                if (mult.getUpperValue() != null) {
                    this.adaptAdditional((Notifier)mult.getUpperValue());
                }
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            if (oldTarget instanceof MultiplicityElement) {
                this.unadaptAdditional();
            }
            super.unsetTarget(oldTarget);
        }

        @Override
        protected void handleObjectReplaced(Notification msg, int position, EObject oldObject, EObject newObject) {
            if (msg.getFeature() == UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE) {
                if (oldObject != null) {
                    this.unadaptAdditional((Notifier)oldObject);
                }
                if (newObject != null) {
                    this.adaptAdditional((Notifier)newObject);
                }
                this.handleLowerBoundChanged(ReplicationAdapter.valueOf((ValueSpecification)oldObject), ReplicationAdapter.valueOf((ValueSpecification)newObject));
            } else if (msg.getFeature() == UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE) {
                if (oldObject != null) {
                    this.unadaptAdditional((Notifier)oldObject);
                }
                if (newObject != null) {
                    this.adaptAdditional((Notifier)newObject);
                }
                this.handleUpperBoundChanged(ReplicationAdapter.valueOf((ValueSpecification)oldObject), ReplicationAdapter.valueOf((ValueSpecification)newObject));
            } else {
                super.handleObjectReplaced(msg, position, oldObject, newObject);
            }
        }

        protected static Object valueOf(ValueSpecification valueSpecification) {
            return valueSpecification == null ? Integer.valueOf(1) : new UMLSwitch<Object>(){

                public Object caseLiteralInteger(LiteralInteger object) {
                    return object.getValue();
                }

                public Object caseLiteralUnlimitedNatural(LiteralUnlimitedNatural object) {
                    return object.getValue();
                }

                public Object caseLiteralString(LiteralString object) {
                    return object.getValue();
                }

                public Object caseOpaqueExpression(OpaqueExpression object) {
                    return object.getBodies().isEmpty() ? null : object.getBodies().get(0);
                }

                public Object caseValueSpecification(ValueSpecification object) {
                    return object.stringValue();
                }
            }.doSwitch((EObject)valueSpecification);
        }

        protected static int asIntegerBound(Object bound) {
            int result = 1;
            if (bound instanceof Integer) {
                result = (Integer)bound;
            } else if (bound instanceof String) {
                try {
                    result = Integer.parseInt((String)bound);
                }
                catch (Exception exception) {}
            }
            return result;
        }

        @Override
        protected void handleValueReplaced(Notification msg, int position, Object oldValue, Object newValue) {
            if (msg.getFeature() == UMLPackage.Literals.LITERAL_INTEGER__VALUE || msg.getFeature() == UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL__VALUE || msg.getFeature() == UMLPackage.Literals.LITERAL_STRING__VALUE || msg.getFeature() == UMLPackage.Literals.OPAQUE_EXPRESSION__BODY && position == 0) {
                Property mult = ((UMLRTReplicatedElementImpl)this.get()).toUML();
                ValueSpecification bound = (ValueSpecification)msg.getNotifier();
                if (bound == mult.getLowerValue()) {
                    this.handleLowerBoundChanged(oldValue, newValue);
                } else {
                    this.handleUpperBoundChanged(oldValue, newValue);
                }
            } else {
                super.handleValueReplaced(msg, position, oldValue, newValue);
            }
        }

        @Override
        protected void handleValueAdded(Notification msg, int position, Object value) {
            if (msg.getFeature() == UMLPackage.Literals.OPAQUE_EXPRESSION__BODY && position == 0) {
                Property mult = ((UMLRTReplicatedElementImpl)this.get()).toUML();
                ValueSpecification bound = (ValueSpecification)msg.getNotifier();
                if (bound == mult.getLowerValue()) {
                    this.handleLowerBoundChanged(null, value);
                } else {
                    this.handleUpperBoundChanged(null, value);
                }
            } else {
                super.handleValueAdded(msg, position, value);
            }
        }

        @Override
        protected void handleValueRemoved(Notification msg, int position, Object value) {
            if (msg.getFeature() == UMLPackage.Literals.OPAQUE_EXPRESSION__BODY && ((OpaqueExpression)msg.getNotifier()).getBodies().isEmpty()) {
                Property mult = ((UMLRTReplicatedElementImpl)this.get()).toUML();
                ValueSpecification bound = (ValueSpecification)msg.getNotifier();
                if (bound == mult.getLowerValue()) {
                    this.handleLowerBoundChanged(value, null);
                } else {
                    this.handleUpperBoundChanged(value, null);
                }
            } else {
                super.handleValueRemoved(msg, position, value);
            }
        }

        protected void handleLowerBoundChanged(Object oldValue, Object newValue) {
        }

        protected void handleUpperBoundChanged(Object oldValue, Object newValue) {
            if (((UMLRTReplicatedElementImpl)this.get()).eNotificationRequired()) {
                if (newValue instanceof Integer) {
                    Integer oldInt = oldValue instanceof Integer ? (Integer)oldValue : 1;
                    ((UMLRTReplicatedElementImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), 1, (EStructuralFeature)UMLRTUMLRTPackage.Literals.REPLICATED_ELEMENT__REPLICATION_FACTOR, (Object)oldInt, newValue));
                    String oldString = oldValue instanceof String ? (String)oldValue : oldInt.toString();
                    ((UMLRTReplicatedElementImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), 1, (EStructuralFeature)UMLRTUMLRTPackage.Literals.REPLICATED_ELEMENT__REPLICATION_FACTOR_AS_STRING, (Object)oldString, (Object)String.valueOf(newValue)));
                } else {
                    String oldString = oldValue == null ? null : oldValue.toString();
                    String newString = newValue == null ? null : newValue.toString();
                    ((UMLRTReplicatedElementImpl)this.get()).eNotify((Notification)new ENotificationImpl((InternalEObject)this.get(), 1, (EStructuralFeature)UMLRTUMLRTPackage.Literals.REPLICATED_ELEMENT__REPLICATION_FACTOR_AS_STRING, (Object)oldString, (Object)newString));
                }
            }
        }
    }
}

